/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.util;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.impl.alloc.AllocationValueIterator;
import com.sap.jvm.profiling.util.splitarray.SplitArray32;
import com.sap.jvm.profiling.util.splitarray.SplitArray48;
import java.io.IOException;
import java.util.Arrays;

public class IdHashSet {
    private static final int VERSION = 0;
    private static final int EXT_FORMAT_32 = 0;
    private static final int EXT_FORMAT_64 = 0;
    private static final int BUCKET_SHIFT = 16;
    private static final int BUCKET_MASK = 65535;
    private int[] offsets;
    private char[] idOffsets;
    private int nrOfBuckets;
    private long minId;
    private long maxId;
    private int hashCode;
    private int nrOfIds;

    public IdHashSet(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        this.nrOfIds = reader.readInt32();
        long baseId = reader.readInt64();
        this.maxId = reader.readInt64();
        if (reader.readInt32() == 0) {
            SplitArray32 ids = new SplitArray32((long)this.nrOfIds);
            for (int i = 0; i < this.nrOfIds; ++i) {
                ids.set(i, reader.readInt32());
            }
            this.create(ids, baseId, this.maxId);
        } else {
            SplitArray48 ids = new SplitArray48((long)this.nrOfIds);
            for (int i = 0; i < this.nrOfIds; ++i) {
                ids.set((long)i, reader.readInt64());
            }
            this.create(ids, baseId, this.maxId);
        }
    }

    public IdHashSet(SplitArray32 ids, long minId, long maxId) {
        this.nrOfIds = (int)ids.size();
        this.create(ids, minId, maxId);
    }

    public IdHashSet(SplitArray48 ids, long minId, long maxId) {
        this.nrOfIds = (int)ids.size();
        this.create(ids, minId, maxId);
    }

    public static IdHashSet fromAllocations(ResourceName name, ProgressReporter reporter) throws IOException {
        Snapshot snapshot = SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name);
        AllocationValueIterator it = new AllocationValueIterator(snapshot, name, reporter, I18n._s((String)"Reading the allocation ids ...."));
        long minId = Long.MAX_VALUE;
        long maxId = Long.MIN_VALUE;
        int nrOfIds = 0;
        while (it.next()) {
            long id = it.getAllocEvent().getObjectId() >>> 26;
            minId = Math.min(minId, id);
            maxId = Math.max(maxId, id);
            ++nrOfIds;
        }
        it = new AllocationValueIterator(snapshot, name, reporter, I18n._s((String)"Analyzing the allocation ids ...."));
        if (maxId - minId < 0x100000000L) {
            SplitArray32 ids = new SplitArray32((long)nrOfIds);
            nrOfIds = 0;
            while (it.next()) {
                long id = it.getAllocEvent().getObjectId() >>> 26;
                ids.set(nrOfIds, (int)(id - minId));
                ++nrOfIds;
            }
            return new IdHashSet(ids, minId, maxId);
        }
        SplitArray48 ids = new SplitArray48((long)nrOfIds);
        nrOfIds = 0;
        while (it.next()) {
            long id = it.getAllocEvent().getObjectId() >>> 26;
            ids.set((long)nrOfIds, id - minId);
            ++nrOfIds;
        }
        return new IdHashSet(ids, minId, maxId);
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.idOffsets.length);
        writer.writeInt64(this.minId);
        writer.writeInt64(this.maxId);
        if (this.maxId - this.minId < 0x100000000L) {
            writer.writeInt32(0);
            for (int i = 0; i < this.offsets.length - 1; ++i) {
                int baseOffset = i << 16;
                int from = this.offsets[i];
                int to = this.offsets[i + 1];
                for (int j = from; j < to; ++j) {
                    writer.writeInt32(baseOffset + this.idOffsets[j]);
                }
            }
        } else {
            writer.writeInt32(0);
            for (int i = 0; i < this.offsets.length - 1; ++i) {
                long baseOffset = (long)i << 16;
                int from = this.offsets[i];
                int to = this.offsets[i + 1];
                for (int j = from; j < to; ++j) {
                    writer.writeInt64(baseOffset + (long)this.idOffsets[j]);
                }
            }
        }
    }

    public boolean contains(long id) {
        if (id < this.minId || id > this.maxId) {
            return false;
        }
        int bucket = (int)(id - this.minId >>> 16);
        char offset = (char)(id - this.minId & 0xFFFFL);
        int from = this.offsets[bucket];
        int to = this.offsets[bucket + 1];
        while (from < to) {
            int mid = from + (to - from) / 2;
            if (this.idOffsets[mid] == offset) {
                return true;
            }
            if (offset > this.idOffsets[mid]) {
                from = mid + 1;
                continue;
            }
            to = mid;
        }
        return false;
    }

    private void create(SplitArray32 ids, long minId, long maxId) {
        int bucket;
        if (ids.size() == 0L) {
            this.minId = 0L;
            this.maxId = -1L;
        }
        this.minId = minId;
        this.maxId = maxId;
        this.nrOfBuckets = (int)(1L + (maxId - minId >>> 16));
        this.offsets = new int[this.nrOfBuckets + 1];
        int i = 0;
        while ((long)i < ids.size()) {
            int n = bucket = ids.get(i) >>> 16;
            this.offsets[n] = this.offsets[n] + 1;
            ++i;
        }
        for (i = 1; i < this.offsets.length; ++i) {
            int n = i;
            this.offsets[n] = this.offsets[n] + this.offsets[i - 1];
        }
        this.idOffsets = new char[(int)ids.size()];
        this.offsets[this.offsets.length - 1] = this.idOffsets.length;
        i = 0;
        while ((long)i < ids.size()) {
            int newOffset;
            bucket = ids.get(i) >>> 16;
            this.offsets[bucket] = newOffset = this.offsets[bucket] - 1;
            this.idOffsets[newOffset] = (char)(ids.get(i) & 0xFFFF);
            ++i;
        }
        this.sortIdOffsets();
    }

    private void create(SplitArray48 ids, long minId, long maxId) {
        int bucket;
        if (ids.size() == 0L) {
            this.minId = 0L;
            this.maxId = -1L;
        }
        this.minId = minId;
        this.maxId = maxId;
        this.nrOfBuckets = (int)(1L + (maxId - minId >>> 16));
        this.offsets = new int[this.nrOfBuckets + 1];
        int i = 0;
        while ((long)i < ids.size()) {
            int n = bucket = (int)(ids.get(i) >>> 16);
            this.offsets[n] = this.offsets[n] + 1;
            ++i;
        }
        for (i = 1; i < this.offsets.length; ++i) {
            int n = i;
            this.offsets[n] = this.offsets[n] + this.offsets[i - 1];
        }
        this.idOffsets = new char[(int)ids.size()];
        this.offsets[this.offsets.length - 1] = this.idOffsets.length;
        i = 0;
        while ((long)i < ids.size()) {
            int newOffset;
            bucket = (int)(ids.get(i) >>> 16);
            this.offsets[bucket] = newOffset = this.offsets[bucket] - 1;
            this.idOffsets[newOffset] = (char)(ids.get(i) & 0xFFFFL);
            ++i;
        }
        this.sortIdOffsets();
    }

    private void sortIdOffsets() {
        for (int i = 0; i < this.nrOfBuckets; ++i) {
            int from = this.offsets[i];
            int to = this.offsets[i + 1];
            this.sortIdOffsets(from, to);
        }
    }

    private void sortIdOffsets(int from, int to) {
        if (from < to) {
            if (from + 1 == to) {
                return;
            }
            int pivotPos = this.partition(from, to);
            this.sortIdOffsets(from, pivotPos);
            this.sortIdOffsets(pivotPos + 1, to);
        }
    }

    private int partition(int from, int to) {
        int mid = from + (to - from) / 2;
        char pivot = this.idOffsets[mid];
        char tmp = this.idOffsets[to - 1];
        this.idOffsets[to - 1] = pivot;
        this.idOffsets[mid] = tmp;
        int curr = from;
        for (int i = from; i < to - 1; ++i) {
            if (this.idOffsets[i] >= pivot) continue;
            tmp = this.idOffsets[curr];
            this.idOffsets[curr] = this.idOffsets[i];
            this.idOffsets[i] = tmp;
            ++curr;
        }
        this.idOffsets[to - 1] = this.idOffsets[curr];
        this.idOffsets[curr] = pivot;
        return curr;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IdHashSet) {
            IdHashSet other = (IdHashSet)obj;
            return this.equals(other);
        }
        return false;
    }

    public boolean equals(IdHashSet other) {
        if (other == this) {
            return true;
        }
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        return Arrays.equals(this.idOffsets, other.idOffsets);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.idOffsets);
        }
        return this.hashCode;
    }

    public String toString() {
        return this.idOffsets.length + " ids in the range from " + this.minId + " to " + this.maxId;
    }

    public int size() {
        return this.nrOfIds;
    }
}

