/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.util;

import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.util.ValueTreeNodeBase;

public final class MethodPath {
    private final MethodLocation[] path;

    public MethodPath(MethodLocation[] path) {
        this.path = (MethodLocation[])path.clone();
    }

    public MethodPath(ValueTreeNodeBase<MethodLocation, ?> node) {
        this(MethodPath.getPathFromNode(node));
    }

    public MethodLocation[] getPath() {
        return this.path;
    }

    public int length() {
        return this.path.length;
    }

    public boolean matches(StackFrames stack, int offset) {
        return this.matches(stack, offset, stack.getNrOfFrames());
    }

    public boolean matches(StackFrames stack, int bottom, int top) {
        return stack.matchesPath(bottom, top, this.path, this.path.length);
    }

    public boolean matchesReverse(StackFrames stack, int offset) {
        return this.matchesReverse(stack, 0, offset + 1);
    }

    public boolean matchesReverse(StackFrames stack, int bottom, int top) {
        return stack.matchesReversePath(bottom, top, this.path, this.path.length);
    }

    private static MethodLocation[] getPathFromNode(ValueTreeNodeBase<MethodLocation, ?> node) {
        if (node == null) {
            return new MethodLocation[0];
        }
        MethodLocation[] path = new MethodLocation[node.getDepth()];
        node.fillInPathFromRoots((MethodLocation[])path);
        return path;
    }
}

