/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.util;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.JRubyMethodCategorizer;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.filter.FilterParseException;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.tracing.Trace;

public class StackJRubyfier {
    private static String[][] javaInvocations = new String[][]{{"+sun.reflect.*(*)", "+java.lang.reflect.*(*)", "+org.jruby.javasupport.JavaMethod.invoke*(*)|org.jruby.javasupport.JavaConstructor.newInstance*(*)", "+org.jruby.java.invokers.*(*)", "org.jruby.runtime.callsite.CachingCallSite.*(*)"}, {"+java.lang.invoke.MethodHandleImpl*(*)"}};
    private final JavaInvocationElement[][] javaInvocationFilters;
    private final MethodFilter topInvocationFilter;
    private final MethodFilter exitingJavaFilter;
    private final JRubyMethodCategorizer categorizer;
    private final StackFrames origStack;
    private final StackFrames rubyStack;
    private MethodLocation[] javaFrames;
    private int nrOfJavaFrames;
    private MethodLocation[] jrubyFrames;
    private int nrOfJRubyFrames;
    private int[] jrubyMapping;
    private final MethodLocation noStack;

    public StackJRubyfier(StackFrames origStack, StackFrames rubyStack, ProfilingSession session) {
        int initialSize = 10;
        this.origStack = origStack;
        this.rubyStack = rubyStack;
        this.javaFrames = new MethodLocation[initialSize];
        this.jrubyFrames = new MethodLocation[initialSize];
        this.jrubyMapping = new int[initialSize];
        this.categorizer = session.getJRubyMethodCategorizer();
        this.javaInvocationFilters = new JavaInvocationElement[javaInvocations.length][];
        this.noStack = session.getMethodLocationManager().getNoStackMethodLocation();
        MethodFilter[] topFilters = new MethodFilter[javaInvocations.length];
        try {
            this.exitingJavaFilter = new MethodFilter(session, "<synthetic>", "org.jruby.embed.ScriptingContainer.call*(*)|org.jruby.embed.ScriptingContainer.run*(*)|overwrites org.jruby.javasupport.EmbedEvalUnit$EvalUnit.run()|org.jruby.Ruby.eval*(*)|org.jruby.Ruby.exec*(*)|org.jruby.Ruby.run*(*)|overwrites org.jruby.ast.Node.interpret(*)");
            for (int i = 0; i < this.javaInvocationFilters.length; ++i) {
                this.javaInvocationFilters[i] = new JavaInvocationElement[javaInvocations[i].length];
                for (int j = 0; j < this.javaInvocationFilters[i].length; ++j) {
                    this.javaInvocationFilters[i][j] = new JavaInvocationElement(javaInvocations[i][j], session);
                }
                topFilters[i] = this.javaInvocationFilters[i][0].filter;
            }
        }
        catch (FilterParseException e) {
            Trace.error((Throwable)e, (String)"Parsing failed");
            throw new RuntimeException(e);
        }
        this.topInvocationFilter = MethodFilter.createWide("<synthetic>", topFilters, true);
    }

    public void rubify(int startFrame, boolean startInJava, boolean skipBoundMethods) {
        this.nrOfJavaFrames = this.origStack.getNrOfFrames();
        if (this.javaFrames.length < this.nrOfJavaFrames) {
            this.javaFrames = new MethodLocation[Math.max(this.nrOfJavaFrames, this.javaFrames.length * 2)];
        }
        for (int i = startFrame; i < this.nrOfJavaFrames; ++i) {
            this.javaFrames[i] = this.origStack.getMethodLocation(i);
        }
        if (this.jrubyFrames.length < this.nrOfJavaFrames) {
            this.jrubyFrames = new MethodLocation[Math.max(this.nrOfJRubyFrames, this.jrubyFrames.length * 2)];
            this.jrubyMapping = new int[this.jrubyFrames.length];
        }
        this.nrOfJRubyFrames = 0;
        boolean isInJava = startInJava;
        for (int i = startFrame; i < this.nrOfJavaFrames; ++i) {
            MethodLocation location = this.javaFrames[i];
            MethodObject method = location.getMethod();
            if (method.isBoundJRubyMethod()) {
                if (skipBoundMethods) continue;
                this.addJRubyFrame(i);
                continue;
            }
            if (!isInJava) {
                if (this.categorizer.isCompiledJRuby(method) || this.categorizer.isInterpretedJRuby(method)) {
                    int lineNr = location.getLineNumber();
                    if (lineNr > 0 && lineNr < 65535) {
                        this.addJRubyFrame(i);
                    }
                } else if (this.isStartingJava(i)) {
                    isInJava = true;
                }
            } else if (this.isExitingJava(i)) {
                isInJava = false;
            }
            if (!isInJava) continue;
            this.addJRubyFrame(i);
        }
        if (this.nrOfJRubyFrames == 0) {
            this.jrubyFrames[0] = this.noStack;
            this.nrOfJRubyFrames = 1;
        }
        this.rubyStack.fillIn(this.jrubyFrames, this.nrOfJRubyFrames);
    }

    private boolean isStartingJava(int index) {
        if (index < 1) {
            return false;
        }
        if (!this.topInvocationFilter.matches(this.javaFrames[index - 1].getMethod())) {
            return false;
        }
        for (int i = 0; i < this.javaInvocationFilters.length; ++i) {
            if (index < this.javaInvocationFilters[i].length) continue;
            boolean isMatch = true;
            JavaInvocationElement[] currStack = this.javaInvocationFilters[i];
            if (currStack[0].matches(this.javaFrames[index])) continue;
            int currIndex = index - 1;
            for (int j = 0; j < currStack.length; ++j) {
                if (currIndex < 0) {
                    isMatch = false;
                    break;
                }
                JavaInvocationElement curr = currStack[j];
                if (!curr.matches(this.javaFrames[currIndex])) {
                    isMatch = false;
                    break;
                }
                --currIndex;
                if (!curr.matchesMultiple()) continue;
                while (currIndex >= 0 && curr.matches(this.javaFrames[currIndex])) {
                    --currIndex;
                }
            }
            if (!isMatch) continue;
            return true;
        }
        return false;
    }

    private boolean isExitingJava(int index) {
        if (index > 0) {
            return this.exitingJavaFilter.matches(this.javaFrames[index - 1].getMethod());
        }
        return false;
    }

    private void addJRubyFrame(int index) {
        this.jrubyFrames[this.nrOfJRubyFrames] = this.javaFrames[index];
        this.jrubyMapping[this.nrOfJRubyFrames] = index;
        ++this.nrOfJRubyFrames;
    }

    public int getJavaIndexForJRubyIndex(int index) {
        return this.jrubyMapping[index];
    }

    public int getTopmostJRubyIndexForJavaIndex(int index) {
        if (this.nrOfJRubyFrames == 0) {
            return 0;
        }
        int mid = this.nrOfJRubyFrames / 2;
        int bottom = 0;
        int top = this.nrOfJRubyFrames;
        while (bottom < top) {
            int javaIndex = this.jrubyMapping[mid];
            if (javaIndex < index) {
                bottom = mid + 1;
            } else if (javaIndex > index) {
                top = mid - 1;
            } else {
                return mid;
            }
            mid = (top + bottom) / 2;
        }
        return bottom;
    }

    private static final class JavaInvocationElement {
        private final MethodFilter filter;
        private final boolean matchMultiple;

        public JavaInvocationElement(String spec, ProfilingSession session) throws FilterParseException {
            this.matchMultiple = spec.startsWith("+");
            this.filter = new MethodFilter(session, "<synthetic>", this.matchMultiple ? spec.substring(1) : spec);
        }

        public boolean matches(MethodLocation location) {
            return this.filter.matches(location.getMethod());
        }

        public boolean matchesMultiple() {
            return this.matchMultiple;
        }
    }
}

