/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.util.column;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.util.LongToIntConverter;
import com.sap.jvm.util.threads.RunWaiter;
import com.sap.jvm.util.threads.ThreadRunner;
import java.io.IOException;

public class LongColumnBase {
    private static final int VERSION = 2;
    private static final byte RAW_FORMAT = 0;
    private static final byte INT_FORMAT = 1;
    private static final byte CHAR_FORMAT = 2;
    private static final byte BYTE_FORMAT = 3;
    private static final byte CONSTANT_FORMAT = 4;
    private int nrOfRows;
    private final int nrOfColumns;
    private final long[][] uncompressed;
    private final int[][] compressed;
    private final int[][] bits;
    private final int[] nrOfBits;
    private final long[] offsets;
    private final long[] minValues;
    private final long[] maxValues;
    private final LongToIntConverter converter;
    private int[] nonZeroColumns;
    private long zeroColumnOffset;

    public LongColumnBase(int nrOfColumns) {
        this.nrOfColumns = nrOfColumns;
        this.uncompressed = new long[nrOfColumns][];
        this.compressed = new int[nrOfColumns][];
        this.bits = new int[nrOfColumns][];
        this.nrOfBits = new int[nrOfColumns];
        this.offsets = new long[nrOfColumns];
        this.minValues = new long[nrOfColumns];
        this.maxValues = new long[nrOfColumns];
        this.converter = new LongToIntConverter();
    }

    public long[][] setNrOfRows(int nrOfRows) {
        this.nrOfRows = nrOfRows;
        return this.uncompressed;
    }

    public void createNonZeroColumnInfo() {
        int[] columns = new int[this.nrOfColumns];
        int nrOfNonZeroColumns = 0;
        for (int i = 0; i < this.nrOfColumns; ++i) {
            if (this.uncompressed[i] != null || this.compressed[i] != null || this.bits[i] != null) {
                columns[nrOfNonZeroColumns] = i;
                ++nrOfNonZeroColumns;
                continue;
            }
            this.zeroColumnOffset += this.offsets[i];
        }
        this.nonZeroColumns = new int[nrOfNonZeroColumns];
        System.arraycopy(columns, 0, this.nonZeroColumns, 0, nrOfNonZeroColumns);
    }

    protected void readColumns(ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(2);
        this.nrOfRows = reader.readInt32();
        for (int column = 0; column < this.nrOfColumns; ++column) {
            int i;
            this.uncompressed[column] = new long[this.nrOfRows];
            long[] values = this.uncompressed[column];
            byte format = reader.readInt8();
            if (format == 0) {
                for (int i2 = 0; i2 < this.nrOfRows; ++i2) {
                    reporter.reportNextOrThrow();
                    values[i2] = reader.readInt64();
                }
            } else if (format == 1) {
                long off = reader.readInt64();
                for (i = 0; i < this.nrOfRows; ++i) {
                    reporter.reportNextOrThrow();
                    values[i] = off + (long)reader.readInt32();
                }
            } else if (format == 2) {
                long off = reader.readInt64();
                for (i = 0; i < this.nrOfRows; ++i) {
                    reporter.reportNextOrThrow();
                    values[i] = off + (long)reader.readUint16();
                }
            } else if (format == 3) {
                long off = reader.readInt64();
                for (i = 0; i < this.nrOfRows; ++i) {
                    reporter.reportNextOrThrow();
                    values[i] = off + (long)reader.readUint8();
                }
            } else {
                assert (format == 4);
                long off = reader.readInt64();
                for (i = 0; i < this.nrOfRows; ++i) {
                    reporter.reportNextOrThrow();
                    values[i] = off;
                }
            }
            this.convertColumnIfPossible(column);
        }
        this.createNonZeroColumnInfo();
    }

    public int size() {
        return this.nrOfRows;
    }

    public void writeColumns(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(2);
        writer.writeInt32(this.nrOfRows);
        for (int column = 0; column < this.nrOfColumns; ++column) {
            if (this.uncompressed[column] != null) {
                writer.writeInt8(0);
                for (long value : this.uncompressed[column]) {
                    reporter.reportNextOrThrow();
                    writer.writeInt64(value);
                }
                continue;
            }
            if (this.compressed[column] != null) {
                writer.writeInt8(0);
                for (int raw : this.compressed[column]) {
                    reporter.reportNextOrThrow();
                    writer.writeInt64(this.converter.getValue(raw));
                }
                continue;
            }
            if (this.bits[column] != null) {
                if (this.nrOfBits[column] == 1) {
                    this.writeBits1(column, writer, reporter);
                    continue;
                }
                if (this.nrOfBits[column] == 2) {
                    this.writeBits2(column, writer, reporter);
                    continue;
                }
                if (this.nrOfBits[column] == 4) {
                    this.writeBits4(column, writer, reporter);
                    continue;
                }
                if (this.nrOfBits[column] == 8) {
                    this.writeBits8(column, writer, reporter);
                    continue;
                }
                if (this.nrOfBits[column] == 16) {
                    this.writeBits16(column, writer, reporter);
                    continue;
                }
                assert (this.nrOfBits[column] == 32);
                long offset = this.offsets[column];
                writer.writeInt8(1);
                writer.writeInt64(offset);
                for (int raw : this.bits[column]) {
                    writer.writeInt32(raw);
                }
                continue;
            }
            writer.writeInt8(4);
            writer.writeInt64(this.offsets[column]);
            reporter.reportWorkOrThrow((long)this.nrOfRows);
        }
    }

    private void writeBits1(int column, ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeInt8(3);
        writer.writeInt64(this.offsets[column]);
        int index = -1;
        int shift = 32;
        int[] raw = this.bits[column];
        int value = 0;
        for (int i = 0; i < this.nrOfRows; ++i) {
            if (shift >= 32) {
                shift = 0;
                value = raw[++index];
                reporter.reportWorkOrThrow(32L);
            }
            writer.writeInt8((int)((byte)(value >>> shift & 1)));
            ++shift;
        }
    }

    private void writeBits2(int column, ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeInt8(3);
        writer.writeInt64(this.offsets[column]);
        int index = -1;
        int shift = 32;
        int[] raw = this.bits[column];
        int value = 0;
        for (int i = 0; i < this.nrOfRows; ++i) {
            if (shift >= 32) {
                shift = 0;
                value = raw[++index];
                reporter.reportWorkOrThrow(16L);
            }
            writer.writeInt8((int)((byte)(value >>> shift & 3)));
            shift += 2;
        }
    }

    private void writeBits4(int column, ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeInt8(3);
        writer.writeInt64(this.offsets[column]);
        int index = -1;
        int shift = 32;
        int[] raw = this.bits[column];
        int value = 0;
        for (int i = 0; i < this.nrOfRows; ++i) {
            if (shift >= 32) {
                shift = 0;
                value = raw[++index];
                reporter.reportWorkOrThrow(8L);
            }
            writer.writeInt8((int)((byte)(value >>> shift & 0xF)));
            shift += 4;
        }
    }

    private void writeBits8(int column, ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeInt8(3);
        writer.writeInt64(this.offsets[column]);
        int index = -1;
        int shift = 32;
        int[] raw = this.bits[column];
        int value = 0;
        for (int i = 0; i < this.nrOfRows; ++i) {
            if (shift >= 32) {
                shift = 0;
                value = raw[++index];
                reporter.reportWorkOrThrow(4L);
            }
            writer.writeInt8((int)((byte)(value >>> shift & 0xFF)));
            shift += 8;
        }
    }

    private void writeBits16(int column, ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeInt8(2);
        writer.writeInt64(this.offsets[column]);
        int index = -1;
        int shift = 32;
        int[] raw = this.bits[column];
        int value = 0;
        for (int i = 0; i < this.nrOfRows; ++i) {
            if (shift >= 32) {
                shift = 0;
                value = raw[++index];
                reporter.reportWorkOrThrow(2L);
            }
            writer.writeUint16((char)(value >>> shift & 0xFFFF));
            shift += 16;
        }
    }

    public void convertColumnIfPossible(int column) {
        int overflowRows = 0;
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (long value : this.uncompressed[column]) {
            max = Math.max(max, value);
            min = Math.min(min, value);
            if (value <= Integer.MAX_VALUE) continue;
            ++overflowRows;
        }
        this.minValues[column] = min;
        this.maxValues[column] = max;
        if (min == max) {
            this.uncompressed[column] = null;
            this.offsets[column] = min;
            return;
        }
        int bitsUsed = 64 - Long.numberOfLeadingZeros(max - min);
        if ((bitsUsed = Integer.highestOneBit(bitsUsed * 2 - 1)) < 32) {
            int index = 0;
            int off = 0;
            long[] values = this.uncompressed[column];
            int len = this.nrOfRows + 31 >> 5 - Integer.numberOfTrailingZeros(bitsUsed);
            int[] raw = new int[len];
            assert (this.nrOfRows < 0x3FFFFFF);
            for (int i = 0; i < this.nrOfRows; ++i) {
                int n = index++;
                raw[n] = raw[n] | (int)(values[i] - min) << off;
                if ((off += bitsUsed) < 32) continue;
                off -= 32;
            }
            this.bits[column] = raw;
            this.nrOfBits[column] = bitsUsed;
            this.offsets[column] = min;
            this.uncompressed[column] = null;
            return;
        }
        if (bitsUsed == 32) {
            long[] values = this.uncompressed[column];
            int[] raw = new int[this.nrOfRows];
            for (int i = 0; i < this.nrOfRows; ++i) {
                raw[i] = (int)(values[i] - min + Integer.MIN_VALUE);
            }
            this.bits[column] = raw;
            this.nrOfBits[column] = bitsUsed;
            this.offsets[column] = min - Integer.MIN_VALUE;
            this.uncompressed[column] = null;
            return;
        }
        double minSmallFraction = 0.45;
        if (min >= 0L && (double)overflowRows < (double)this.nrOfRows * minSmallFraction) {
            this.compressed[column] = new int[this.nrOfRows];
            for (int i = 0; i < this.nrOfRows; ++i) {
                this.compressed[column][i] = this.converter.add(0, this.uncompressed[column][i]);
            }
            this.uncompressed[column] = null;
        }
    }

    public long getMinValue(int column) {
        return this.minValues[column];
    }

    public long getMaxValue(int column) {
        return this.maxValues[column];
    }

    public long getValue(int column, int row) {
        if (this.uncompressed[column] != null) {
            return this.uncompressed[column][row];
        }
        if (this.compressed[column] != null) {
            return this.converter.getValue(this.compressed[column][row]);
        }
        if (this.bits[column] != null) {
            int mask;
            int shift;
            int index;
            int bitsUsed = this.nrOfBits[column];
            if (bitsUsed == 32) {
                return this.offsets[column] + (long)this.bits[column][row];
            }
            if (bitsUsed == 1) {
                index = row >> 5;
                shift = row & 0x1F;
                mask = 1;
            } else if (bitsUsed == 2) {
                index = row >> 4;
                shift = (row & 0xF) << 1;
                mask = 3;
            } else if (bitsUsed == 4) {
                index = row >> 3;
                shift = (row & 7) << 2;
                mask = 15;
            } else if (bitsUsed == 8) {
                index = row >> 2;
                shift = (row & 3) << 3;
                mask = 255;
            } else {
                assert (this.nrOfBits[column] == 16);
                index = row >> 1;
                shift = (row & 1) << 4;
                mask = 65535;
            }
            return this.offsets[column] + (long)(this.bits[column][index] >>> shift & mask);
        }
        return this.offsets[column];
    }

    public long getTotalValue(int row) {
        long result = 0L;
        for (int column : this.nonZeroColumns) {
            result += this.getValue(column, row);
        }
        return result + this.zeroColumnOffset;
    }

    public long getWork(int size) {
        return (long)this.nrOfColumns * (long)(size + 31);
    }

    public int[] sortAscending(int[] initialOrder, int column, int nrOfThreads) {
        if (this.uncompressed[column] == null && this.compressed[column] == null && this.bits[column] == null) {
            return initialOrder;
        }
        if (this.uncompressed[column] != null) {
            int order = this.getSortDirectionUncompressed(initialOrder, 0, initialOrder.length, column);
            if (order == -1) {
                this.stableReverseUncompressed(initialOrder, 0, initialOrder.length, column);
            } else if (order == 0) {
                this.mergeSortAscendingUncompressed(initialOrder, 0, initialOrder.length, this.uncompressed[column], nrOfThreads);
            }
            assert (this.getSortDirectionUncompressed(initialOrder, 0, initialOrder.length, column) == 1);
            return initialOrder;
        }
        if (this.compressed[column] != null) {
            int order = this.getSortDirectionCompressed(initialOrder, 0, initialOrder.length, column);
            if (order == -1) {
                this.stableReverseCompressed(initialOrder, 0, initialOrder.length, column);
            } else if (order == 0) {
                this.mergeSortAscendingCompressed(initialOrder, 0, initialOrder.length, this.compressed[column], nrOfThreads);
            }
            assert (this.getSortDirectionCompressed(initialOrder, 0, initialOrder.length, column) == 1);
            return initialOrder;
        }
        if (this.nrOfBits[column] == 32) {
            int order = this.getSortDirectionInt(initialOrder, 0, initialOrder.length, column);
            if (order == -1) {
                this.stableReverseInt(initialOrder, 0, initialOrder.length, column);
            } else if (order == 0) {
                this.mergeSortAscendingInt(initialOrder, 0, initialOrder.length, this.bits[column], nrOfThreads);
            }
            assert (this.getSortDirectionInt(initialOrder, 0, initialOrder.length, column) == 1);
            return initialOrder;
        }
        if (this.nrOfBits[column] == 16) {
            return this.bucketSort16Bit(initialOrder, column, true);
        }
        if (this.nrOfBits[column] == 8) {
            return this.bucketSort8Bit(initialOrder, column, true);
        }
        if (this.nrOfBits[column] == 4) {
            return this.bucketSort4Bit(initialOrder, column, true);
        }
        if (this.nrOfBits[column] == 2) {
            return this.bucketSort2Bit(initialOrder, column, true);
        }
        assert (this.nrOfBits[column] == 1);
        return this.bucketSort1Bit(initialOrder, column, true);
    }

    private void mergeSortAscendingUncompressed(final int[] in, final int from, int to, final long[] values, final int nrOfThreads) {
        assert ((nrOfThreads & nrOfThreads - 1) == 0);
        int len = to - from;
        if (len < 16) {
            for (int i = from + 1; i < to; ++i) {
                int lo = from;
                int hi = i;
                long val = values[in[i]];
                while (lo < hi) {
                    int mid = (lo + hi) / 2;
                    if (val >= values[in[mid]]) {
                        lo = mid + 1;
                        continue;
                    }
                    hi = mid;
                }
                int tmp = in[i];
                System.arraycopy(in, lo, in, lo + 1, i - lo);
                in[lo] = tmp;
            }
            return;
        }
        final int mid = len / 2 + from;
        if (nrOfThreads > 1) {
            RunWaiter w = ThreadRunner.run((Runnable)new Runnable(){

                @Override
                public void run() {
                    LongColumnBase.this.mergeSortAscendingUncompressed(in, from, mid, values, nrOfThreads / 2);
                }
            });
            this.mergeSortAscendingUncompressed(in, mid, to, values, nrOfThreads / 2);
            w.waitOnFinish();
        } else {
            this.mergeSortAscendingUncompressed(in, from, mid, values, nrOfThreads);
            this.mergeSortAscendingUncompressed(in, mid, to, values, nrOfThreads);
        }
        int half = mid - from;
        int[] copy = new int[half];
        System.arraycopy(in, from, copy, 0, half);
        int p1 = 0;
        int p2 = mid;
        long v1 = values[copy[p1]];
        long v2 = values[in[p2]];
        for (int i = from; i < to; ++i) {
            if (v1 <= v2) {
                in[i] = copy[p1];
                if (++p1 < half) {
                    v1 = values[copy[p1]];
                    continue;
                }
                System.arraycopy(in, p2, in, i + 1, to - i - 1);
                return;
            }
            in[i] = in[p2];
            if (++p2 < to) {
                v2 = values[in[p2]];
                continue;
            }
            System.arraycopy(copy, p1, in, i + 1, to - i - 1);
            return;
        }
    }

    private void mergeSortAscendingInt(final int[] in, final int from, int to, final int[] values, final int nrOfThreads) {
        assert ((nrOfThreads & nrOfThreads - 1) == 0);
        int len = to - from;
        if (len < 16) {
            for (int i = from + 1; i < to; ++i) {
                int lo = from;
                int hi = i;
                int val = values[in[i]];
                while (lo < hi) {
                    int mid = (lo + hi) / 2;
                    if (val >= values[in[mid]]) {
                        lo = mid + 1;
                        continue;
                    }
                    hi = mid;
                }
                int tmp = in[i];
                System.arraycopy(in, lo, in, lo + 1, i - lo);
                in[lo] = tmp;
            }
            return;
        }
        final int mid = len / 2 + from;
        if (nrOfThreads > 1) {
            RunWaiter w = ThreadRunner.run((Runnable)new Runnable(){

                @Override
                public void run() {
                    LongColumnBase.this.mergeSortAscendingInt(in, from, mid, values, nrOfThreads / 2);
                }
            });
            this.mergeSortAscendingInt(in, mid, to, values, nrOfThreads / 2);
            w.waitOnFinish();
        } else {
            this.mergeSortAscendingInt(in, from, mid, values, nrOfThreads);
            this.mergeSortAscendingInt(in, mid, to, values, nrOfThreads);
        }
        int half = mid - from;
        int[] copy = new int[half];
        System.arraycopy(in, from, copy, 0, half);
        int p1 = 0;
        int p2 = mid;
        int v1 = values[copy[p1]];
        int v2 = values[in[p2]];
        for (int i = from; i < to; ++i) {
            if (v1 <= v2) {
                in[i] = copy[p1];
                if (++p1 < half) {
                    v1 = values[copy[p1]];
                    continue;
                }
                System.arraycopy(in, p2, in, i + 1, to - i - 1);
                return;
            }
            in[i] = in[p2];
            if (++p2 < to) {
                v2 = values[in[p2]];
                continue;
            }
            System.arraycopy(copy, p1, in, i + 1, to - i - 1);
            return;
        }
    }

    private void mergeSortAscendingCompressed(final int[] in, final int from, int to, final int[] values, final int nrOfThreads) {
        assert ((nrOfThreads & nrOfThreads - 1) == 0);
        int len = to - from;
        if (len < 16) {
            for (int i = from + 1; i < to; ++i) {
                int lo = from;
                int hi = i;
                long val = this.converter.getValue(values[in[i]]);
                while (lo < hi) {
                    int mid = (lo + hi) / 2;
                    if (val >= this.converter.getValue(values[in[mid]])) {
                        lo = mid + 1;
                        continue;
                    }
                    hi = mid;
                }
                int tmp = in[i];
                System.arraycopy(in, lo, in, lo + 1, i - lo);
                in[lo] = tmp;
            }
            return;
        }
        final int mid = len / 2 + from;
        if (nrOfThreads > 1) {
            RunWaiter w = ThreadRunner.run((Runnable)new Runnable(){

                @Override
                public void run() {
                    LongColumnBase.this.mergeSortAscendingCompressed(in, from, mid, values, nrOfThreads / 2);
                }
            });
            this.mergeSortAscendingCompressed(in, mid, to, values, nrOfThreads / 2);
            w.waitOnFinish();
        } else {
            this.mergeSortAscendingCompressed(in, from, mid, values, nrOfThreads);
            this.mergeSortAscendingCompressed(in, mid, to, values, nrOfThreads);
        }
        int half = mid - from;
        int[] copy = new int[half];
        System.arraycopy(in, from, copy, 0, half);
        int p1 = 0;
        int p2 = mid;
        long v1 = this.converter.getValue(values[copy[p1]]);
        long v2 = this.converter.getValue(values[in[p2]]);
        for (int i = from; i < to; ++i) {
            if (v1 <= v2) {
                in[i] = copy[p1];
                if (++p1 < half) {
                    v1 = this.converter.getValue(values[copy[p1]]);
                    continue;
                }
                System.arraycopy(in, p2, in, i + 1, to - i - 1);
                return;
            }
            in[i] = in[p2];
            if (++p2 < to) {
                v2 = this.converter.getValue(values[in[p2]]);
                continue;
            }
            System.arraycopy(copy, p1, in, i + 1, to - i - 1);
            return;
        }
    }

    public int[] sortDescending(int[] initialOrder, int column, int nrOfThreads) {
        if (this.uncompressed[column] == null && this.compressed[column] == null && this.bits[column] == null) {
            return initialOrder;
        }
        if (this.uncompressed[column] != null) {
            int order = this.getSortDirectionUncompressed(initialOrder, 0, initialOrder.length, column);
            if (order == 1) {
                this.stableReverseUncompressed(initialOrder, 0, initialOrder.length, column);
            } else if (order == 0) {
                this.mergeSortDescendingUncompressed(initialOrder, 0, initialOrder.length, this.uncompressed[column], nrOfThreads);
            }
            assert (this.getSortDirectionUncompressed(initialOrder, 0, initialOrder.length, column) == -1);
            return initialOrder;
        }
        if (this.compressed[column] != null) {
            int order = this.getSortDirectionCompressed(initialOrder, 0, initialOrder.length, column);
            if (order == 1) {
                this.stableReverseCompressed(initialOrder, 0, initialOrder.length, column);
            } else if (order == 0) {
                this.mergeSortDescendingCompressed(initialOrder, 0, initialOrder.length, this.compressed[column], nrOfThreads);
            }
            assert (this.getSortDirectionCompressed(initialOrder, 0, initialOrder.length, column) == -1);
            return initialOrder;
        }
        if (this.nrOfBits[column] == 32) {
            int order = this.getSortDirectionInt(initialOrder, 0, initialOrder.length, column);
            if (order == 1) {
                this.stableReverseInt(initialOrder, 0, initialOrder.length, column);
            } else if (order == 0) {
                this.mergeSortDescendingInt(initialOrder, 0, initialOrder.length, this.bits[column], nrOfThreads);
            }
            assert (this.getSortDirectionInt(initialOrder, 0, initialOrder.length, column) == -1);
            return initialOrder;
        }
        if (this.nrOfBits[column] == 16) {
            return this.bucketSort16Bit(initialOrder, column, false);
        }
        if (this.nrOfBits[column] == 8) {
            return this.bucketSort8Bit(initialOrder, column, false);
        }
        if (this.nrOfBits[column] == 4) {
            return this.bucketSort4Bit(initialOrder, column, false);
        }
        if (this.nrOfBits[column] == 2) {
            return this.bucketSort2Bit(initialOrder, column, false);
        }
        assert (this.nrOfBits[column] == 1);
        return this.bucketSort1Bit(initialOrder, column, false);
    }

    private void mergeSortDescendingUncompressed(final int[] in, final int from, int to, final long[] values, final int nrOfThreads) {
        assert ((nrOfThreads & nrOfThreads - 1) == 0);
        int len = to - from;
        if (len < 16) {
            for (int i = from + 1; i < to; ++i) {
                int lo = from;
                int hi = i;
                long val = values[in[i]];
                while (lo < hi) {
                    int mid = (lo + hi) / 2;
                    if (val <= values[in[mid]]) {
                        lo = mid + 1;
                        continue;
                    }
                    hi = mid;
                }
                int tmp = in[i];
                System.arraycopy(in, lo, in, lo + 1, i - lo);
                in[lo] = tmp;
            }
            return;
        }
        final int mid = len / 2 + from;
        if (nrOfThreads > 1) {
            RunWaiter w = ThreadRunner.run((Runnable)new Runnable(){

                @Override
                public void run() {
                    LongColumnBase.this.mergeSortDescendingUncompressed(in, from, mid, values, nrOfThreads / 2);
                }
            });
            this.mergeSortDescendingUncompressed(in, mid, to, values, nrOfThreads / 2);
            w.waitOnFinish();
        } else {
            this.mergeSortDescendingUncompressed(in, from, mid, values, nrOfThreads);
            this.mergeSortDescendingUncompressed(in, mid, to, values, nrOfThreads);
        }
        int half = mid - from;
        int[] copy = new int[half];
        System.arraycopy(in, from, copy, 0, half);
        int p1 = 0;
        int p2 = mid;
        long v1 = values[copy[p1]];
        long v2 = values[in[p2]];
        for (int i = from; i < to; ++i) {
            if (v1 >= v2) {
                in[i] = copy[p1];
                if (++p1 < half) {
                    v1 = values[copy[p1]];
                    continue;
                }
                System.arraycopy(in, p2, in, i + 1, to - i - 1);
                return;
            }
            in[i] = in[p2];
            if (++p2 < to) {
                v2 = values[in[p2]];
                continue;
            }
            System.arraycopy(copy, p1, in, i + 1, to - i - 1);
            return;
        }
    }

    private void mergeSortDescendingInt(final int[] in, final int from, int to, final int[] values, final int nrOfThreads) {
        assert ((nrOfThreads & nrOfThreads - 1) == 0);
        int len = to - from;
        if (len < 16) {
            for (int i = from + 1; i < to; ++i) {
                int lo = from;
                int hi = i;
                int val = values[in[i]];
                while (lo < hi) {
                    int mid = (lo + hi) / 2;
                    if (val <= values[in[mid]]) {
                        lo = mid + 1;
                        continue;
                    }
                    hi = mid;
                }
                int tmp = in[i];
                System.arraycopy(in, lo, in, lo + 1, i - lo);
                in[lo] = tmp;
            }
            return;
        }
        final int mid = len / 2 + from;
        if (nrOfThreads > 1) {
            RunWaiter w = ThreadRunner.run((Runnable)new Runnable(){

                @Override
                public void run() {
                    LongColumnBase.this.mergeSortDescendingInt(in, from, mid, values, nrOfThreads / 2);
                }
            });
            this.mergeSortDescendingInt(in, mid, to, values, nrOfThreads / 2);
            w.waitOnFinish();
        } else {
            this.mergeSortDescendingInt(in, from, mid, values, nrOfThreads);
            this.mergeSortDescendingInt(in, mid, to, values, nrOfThreads);
        }
        int half = mid - from;
        int[] copy = new int[half];
        System.arraycopy(in, from, copy, 0, half);
        int p1 = 0;
        int p2 = mid;
        int v1 = values[copy[p1]];
        int v2 = values[in[p2]];
        for (int i = from; i < to; ++i) {
            if (v1 >= v2) {
                in[i] = copy[p1];
                if (++p1 < half) {
                    v1 = values[copy[p1]];
                    continue;
                }
                System.arraycopy(in, p2, in, i + 1, to - i - 1);
                return;
            }
            in[i] = in[p2];
            if (++p2 < to) {
                v2 = values[in[p2]];
                continue;
            }
            System.arraycopy(copy, p1, in, i + 1, to - i - 1);
            return;
        }
    }

    private void mergeSortDescendingCompressed(final int[] in, final int from, int to, final int[] values, final int nrOfThreads) {
        assert ((nrOfThreads & nrOfThreads - 1) == 0);
        int len = to - from;
        if (len < 16) {
            for (int i = from + 1; i < to; ++i) {
                int lo = from;
                int hi = i;
                long val = this.converter.getValue(values[in[i]]);
                while (lo < hi) {
                    int mid = (lo + hi) / 2;
                    if (val <= this.converter.getValue(values[in[mid]])) {
                        lo = mid + 1;
                        continue;
                    }
                    hi = mid;
                }
                int tmp = in[i];
                System.arraycopy(in, lo, in, lo + 1, i - lo);
                in[lo] = tmp;
            }
            return;
        }
        final int mid = len / 2 + from;
        if (nrOfThreads > 1) {
            RunWaiter w = ThreadRunner.run((Runnable)new Runnable(){

                @Override
                public void run() {
                    LongColumnBase.this.mergeSortDescendingCompressed(in, from, mid, values, nrOfThreads / 2);
                }
            });
            this.mergeSortDescendingCompressed(in, mid, to, values, nrOfThreads / 2);
            w.waitOnFinish();
        } else {
            this.mergeSortDescendingCompressed(in, from, mid, values, nrOfThreads);
            this.mergeSortDescendingCompressed(in, mid, to, values, nrOfThreads);
        }
        int half = mid - from;
        int[] copy = new int[half];
        System.arraycopy(in, from, copy, 0, half);
        int p1 = 0;
        int p2 = mid;
        long v1 = this.converter.getValue(values[copy[p1]]);
        long v2 = this.converter.getValue(values[in[p2]]);
        for (int i = from; i < to; ++i) {
            if (v1 >= v2) {
                in[i] = copy[p1];
                if (++p1 < half) {
                    v1 = this.converter.getValue(values[copy[p1]]);
                    continue;
                }
                System.arraycopy(in, p2, in, i + 1, to - i - 1);
                return;
            }
            in[i] = in[p2];
            if (++p2 < to) {
                v2 = this.converter.getValue(values[in[p2]]);
                continue;
            }
            System.arraycopy(copy, p1, in, i + 1, to - i - 1);
            return;
        }
    }

    private int getSortDirectionUncompressed(int[] in, int from, int to, int column) {
        long[] values = this.uncompressed[column];
        int ltCount = 0;
        int gtCount = 0;
        long v1 = values[in[from]];
        for (int i = from + 1; i < to; ++i) {
            long v2 = values[in[i]];
            if (v1 < v2) {
                if (gtCount > 0) {
                    return 0;
                }
                ++ltCount;
            } else if (v1 > v2) {
                if (ltCount > 0) {
                    return 0;
                }
                ++gtCount;
            }
            v1 = v2;
        }
        return ltCount > 0 ? 1 : -1;
    }

    private int[] bucketSort1Bit(int[] in, int column, boolean ascending) {
        int newOffset;
        int i;
        assert (this.nrOfBits[column] == 1);
        int[] raw = this.bits[column];
        int index = -1;
        int shift = 32;
        int value = 0;
        int[] counts = new int[65536];
        for (int i2 = 0; i2 < this.nrOfRows; ++i2) {
            if (shift >= 32) {
                shift = 0;
                value = raw[++index];
            }
            char c = (char)(value >>> shift & 1);
            counts[c] = counts[c] + 1;
            ++shift;
        }
        int offset = 0;
        if (ascending) {
            for (i = 0; i < counts.length; ++i) {
                newOffset = offset + counts[i];
                counts[i] = offset;
                offset = newOffset;
            }
        } else {
            for (i = counts.length - 1; i >= 0; --i) {
                newOffset = offset + counts[i];
                counts[i] = offset;
                offset = newOffset;
            }
        }
        int[] result = new int[in.length];
        for (int pos : in) {
            index = pos >> 5;
            shift = pos & 0x1F;
            int mask = 1;
            int offsetIndex = raw[index] >>> shift & mask;
            result[counts[offsetIndex]] = pos;
            int n = offsetIndex;
            counts[n] = counts[n] + 1;
        }
        return result;
    }

    private int[] bucketSort2Bit(int[] in, int column, boolean ascending) {
        int newOffset;
        int i;
        assert (this.nrOfBits[column] == 2);
        int[] raw = this.bits[column];
        int index = -1;
        int shift = 32;
        int value = 0;
        int[] counts = new int[65536];
        for (int i2 = 0; i2 < this.nrOfRows; ++i2) {
            if (shift >= 32) {
                shift = 0;
                value = raw[++index];
            }
            char c = (char)(value >>> shift & 3);
            counts[c] = counts[c] + 1;
            shift += 2;
        }
        int offset = 0;
        if (ascending) {
            for (i = 0; i < counts.length; ++i) {
                newOffset = offset + counts[i];
                counts[i] = offset;
                offset = newOffset;
            }
        } else {
            for (i = counts.length - 1; i >= 0; --i) {
                newOffset = offset + counts[i];
                counts[i] = offset;
                offset = newOffset;
            }
        }
        int[] result = new int[in.length];
        for (int pos : in) {
            index = pos >> 4;
            shift = (pos & 0xF) << 1;
            int mask = 3;
            int offsetIndex = raw[index] >>> shift & mask;
            result[counts[offsetIndex]] = pos;
            int n = offsetIndex;
            counts[n] = counts[n] + 1;
        }
        return result;
    }

    private int[] bucketSort4Bit(int[] in, int column, boolean ascending) {
        int newOffset;
        int i;
        assert (this.nrOfBits[column] == 4);
        int[] raw = this.bits[column];
        int index = -1;
        int shift = 32;
        int value = 0;
        int[] counts = new int[65536];
        for (int i2 = 0; i2 < this.nrOfRows; ++i2) {
            if (shift >= 32) {
                shift = 0;
                value = raw[++index];
            }
            char c = (char)(value >>> shift & 0xF);
            counts[c] = counts[c] + 1;
            shift += 4;
        }
        int offset = 0;
        if (ascending) {
            for (i = 0; i < counts.length; ++i) {
                newOffset = offset + counts[i];
                counts[i] = offset;
                offset = newOffset;
            }
        } else {
            for (i = counts.length - 1; i >= 0; --i) {
                newOffset = offset + counts[i];
                counts[i] = offset;
                offset = newOffset;
            }
        }
        int[] result = new int[in.length];
        for (int pos : in) {
            index = pos >> 3;
            shift = (pos & 7) << 2;
            int mask = 15;
            int offsetIndex = raw[index] >>> shift & mask;
            result[counts[offsetIndex]] = pos;
            int n = offsetIndex;
            counts[n] = counts[n] + 1;
        }
        return result;
    }

    private int[] bucketSort8Bit(int[] in, int column, boolean ascending) {
        int newOffset;
        int i;
        assert (this.nrOfBits[column] == 8);
        int[] raw = this.bits[column];
        int index = -1;
        int shift = 32;
        int value = 0;
        int[] counts = new int[65536];
        for (int i2 = 0; i2 < this.nrOfRows; ++i2) {
            if (shift >= 32) {
                shift = 0;
                value = raw[++index];
            }
            char c = (char)(value >>> shift & 0xFF);
            counts[c] = counts[c] + 1;
            shift += 8;
        }
        int offset = 0;
        if (ascending) {
            for (i = 0; i < counts.length; ++i) {
                newOffset = offset + counts[i];
                counts[i] = offset;
                offset = newOffset;
            }
        } else {
            for (i = counts.length - 1; i >= 0; --i) {
                newOffset = offset + counts[i];
                counts[i] = offset;
                offset = newOffset;
            }
        }
        int[] result = new int[in.length];
        for (int pos : in) {
            index = pos >> 2;
            shift = (pos & 3) << 3;
            int mask = 255;
            int offsetIndex = raw[index] >>> shift & mask;
            result[counts[offsetIndex]] = pos;
            int n = offsetIndex;
            counts[n] = counts[n] + 1;
        }
        return result;
    }

    private int[] bucketSort16Bit(int[] in, int column, boolean ascending) {
        int newOffset;
        int i;
        assert (this.nrOfBits[column] == 16);
        int[] raw = this.bits[column];
        int index = -1;
        int shift = 32;
        int value = 0;
        int[] counts = new int[65536];
        for (int i2 = 0; i2 < this.nrOfRows; ++i2) {
            if (shift >= 32) {
                shift = 0;
                value = raw[++index];
            }
            char c = (char)(value >>> shift & 0xFFFF);
            counts[c] = counts[c] + 1;
            shift += 16;
        }
        int offset = 0;
        if (ascending) {
            for (i = 0; i < counts.length; ++i) {
                newOffset = offset + counts[i];
                counts[i] = offset;
                offset = newOffset;
            }
        } else {
            for (i = counts.length - 1; i >= 0; --i) {
                newOffset = offset + counts[i];
                counts[i] = offset;
                offset = newOffset;
            }
        }
        int[] result = new int[in.length];
        for (int pos : in) {
            index = pos >> 1;
            shift = (pos & 1) << 4;
            int mask = 65535;
            int offsetIndex = raw[index] >>> shift & mask;
            result[counts[offsetIndex]] = pos;
            int n = offsetIndex;
            counts[n] = counts[n] + 1;
        }
        return result;
    }

    private int getSortDirectionInt(int[] in, int from, int to, int column) {
        assert (this.nrOfBits[column] == 32);
        int ltCount = 0;
        int gtCount = 0;
        int[] values = this.bits[column];
        int v1 = values[in[from]];
        for (int i = from + 1; i < to; ++i) {
            int v2 = values[in[i]];
            if (v1 < v2) {
                if (gtCount > 0) {
                    return 0;
                }
                ++ltCount;
            } else if (v1 > v2) {
                if (ltCount > 0) {
                    return 0;
                }
                ++gtCount;
            }
            v1 = v2;
        }
        return ltCount > 0 ? 1 : -1;
    }

    private int getSortDirectionCompressed(int[] in, int from, int to, int column) {
        int ltCount = 0;
        int gtCount = 0;
        int[] values = this.compressed[column];
        long v1 = this.converter.getValue(values[in[from]]);
        for (int i = from + 1; i < to; ++i) {
            long v2 = this.converter.getValue(values[in[i]]);
            if (v1 < v2) {
                if (gtCount > 0) {
                    return 0;
                }
                ++ltCount;
            } else if (v1 > v2) {
                if (ltCount > 0) {
                    return 0;
                }
                ++gtCount;
            }
            v1 = v2;
        }
        return ltCount > 0 ? 1 : -1;
    }

    private void stableReverseUncompressed(int[] in, int from, int to, int column) {
        long[] values = this.uncompressed[column];
        int mid = (to - from) / 2;
        int p = to - 1;
        int i = from;
        while (i < mid) {
            int tmp = in[i];
            in[i] = in[p];
            in[p] = tmp;
            ++i;
            --p;
        }
        int start = from;
        long v1 = values[in[start]];
        long v2 = 0L;
        while (start < to) {
            int end;
            for (end = start + 1; end < to && (v2 = values[in[end]]) == v1; ++end) {
            }
            mid = start + end >> 1;
            p = end - 1;
            int i2 = start;
            while (i2 < mid) {
                int tmp = in[i2];
                in[i2] = in[p];
                in[p] = tmp;
                ++i2;
                --p;
            }
            v1 = v2;
            start = end;
        }
    }

    private void stableReverseInt(int[] in, int from, int to, int column) {
        assert (this.nrOfBits[column] == 32);
        int mid = (to - from) / 2;
        int p = to - 1;
        int i = from;
        while (i < mid) {
            int tmp = in[i];
            in[i] = in[p];
            in[p] = tmp;
            ++i;
            --p;
        }
        int[] values = this.bits[column];
        int start = from;
        int v1 = values[in[start]];
        int v2 = 0;
        while (start < to) {
            int end;
            for (end = start + 1; end < to && (v2 = values[in[end]]) == v1; ++end) {
            }
            mid = start + end >> 1;
            p = end - 1;
            int i2 = start;
            while (i2 < mid) {
                int tmp = in[i2];
                in[i2] = in[p];
                in[p] = tmp;
                ++i2;
                --p;
            }
            v1 = v2;
            start = end;
        }
    }

    private void stableReverseCompressed(int[] in, int from, int to, int column) {
        int mid = (to - from) / 2;
        int p = to - 1;
        int i = from;
        while (i < mid) {
            int tmp = in[i];
            in[i] = in[p];
            in[p] = tmp;
            ++i;
            --p;
        }
        int start = from;
        int[] values = this.compressed[column];
        long v1 = this.converter.getValue(values[in[start]]);
        long v2 = 0L;
        while (start < to) {
            int end;
            for (end = start + 1; end < to && (v2 = this.converter.getValue(values[in[end]])) == v1; ++end) {
            }
            mid = start + end >> 1;
            p = end - 1;
            int i2 = start;
            while (i2 < mid) {
                int tmp = in[i2];
                in[i2] = in[p];
                in[p] = tmp;
                ++i2;
                --p;
            }
            v1 = v2;
            start = end;
        }
    }
}

