/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.startup;

import com.sap.jvm.profiling.startup.JvmProfiler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class DisplayErrorPopup {
    private static void popUp(String text) {
        JOptionPane.showMessageDialog(null, new JTextArea(text), "Error", 0);
    }

    static void show(String text) {
        if (!JvmProfiler.theOS.isMacOs()) {
            DisplayErrorPopup.popUp(text);
        } else {
            try {
                ArrayList<String> commandLine = new ArrayList<String>(4);
                commandLine.add(JvmProfiler.javaHome + (JvmProfiler.theOS.isWindows() ? "/bin/javaw" : "/bin/java"));
                if (JvmProfiler.isJDKModularized) {
                    commandLine.add("--add-modules=sapjvm.profiling.tools");
                } else {
                    commandLine.add("-cp");
                    commandLine.add(JvmProfiler.javaHome + "/lib/jvmx_tools_impl.jar");
                }
                commandLine.add("com.sap.jvm.profiling.startup.DisplayErrorPopup");
                Process p = new ProcessBuilder(commandLine).start();
                BufferedReader r = new BufferedReader(new StringReader(text));
                BufferedWriter w = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
                String line = r.readLine();
                if (line != null) {
                    w.write(line);
                    line = r.readLine();
                }
                while (line != null) {
                    w.write("\n" + line);
                    line = r.readLine();
                }
                w.close();
                while (p.isAlive()) {
                    try {
                        p.waitFor();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                System.err.println("Caught IOException when forking a new process to display a Popup.");
                e.printStackTrace();
                System.err.println("Wanted to say this:");
                System.err.println(text);
            }
        }
    }

    public static void main(String[] args) {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        StringBuilder sb = new StringBuilder();
        try {
            String line = in.readLine();
            if (line != null) {
                sb.append(line);
                line = in.readLine();
            }
            while (line != null) {
                sb.append("\n" + line);
                line = in.readLine();
            }
        }
        catch (IOException e) {
            if (sb.length() != 0) {
                sb.append("\n");
            }
            sb.append("DisplayErrorPopup: Caught IOException reading input: " + e.getMessage());
        }
        DisplayErrorPopup.popUp(sb.toString());
    }
}

