/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.startup;

import com.sap.jvm.profiling.startup.DisplayErrorPopup;
import com.sap.jvm.profiling.startup.SplashScreen;
import com.sap.jvm.profiling.startup.WorkspaceSelectDialog;
import com.sap.jvm.tracing.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class JvmProfiler {
    static final String VERSION = "2.4.14";
    private static final Integer EXIT_RESTART = 23;
    private static final String WORKSPACE_DIRECTORY = "jvmprofiler_24";
    private static final String osProperty = System.getProperty("os.name");
    private static final String archProperty = System.getProperty("os.arch");
    static final String javaHome = JvmProfiler.detectJavaHome();
    static final OS theOS = JvmProfiler.detectOS();
    static final boolean isJDKModularized = JvmProfiler.isJDK9OrHigher();
    private static File OSGIBundle;
    private static Method eclipseStarterRun;
    private static PrintStream out;
    private static SimpleDateFormat date;
    private static String instanceLocation;
    private static String os;
    private static String ws;
    private static String arch;
    private static List<String> eclipseArgsList;
    private static StringBuilder fileArgs;

    public static void main(String[] args) {
        try {
            JvmProfiler.checkedMain(args);
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter((Writer)sw, true));
            DisplayErrorPopup.show(sw.getBuffer().toString());
            System.exit(-1);
        }
    }

    private static void checkedMain(String[] args) throws Exception {
        JvmProfiler.setLookAndFeel();
        JvmProfiler.getWorkspaceLocation();
        JvmProfiler.setLogFile();
        SplashScreen.show();
        JvmProfiler.determineOSArchitecture();
        JvmProfiler.resolveBundles();
        JvmProfiler.parseArguments(args);
        JvmProfiler.setEclipseRuntimeProperties();
        JvmProfiler.startProfiler();
    }

    private static String detectJavaHome() {
        String jh = System.getProperty("java.home").replace('\\', '/');
        return jh.endsWith("/jre") ? jh.substring(0, jh.length() - "/jre".length()) : jh;
    }

    private static OS detectOS() {
        String osPropLower = osProperty.toLowerCase();
        if (osPropLower.indexOf("mac os x") != -1) {
            return OS.MACOS;
        }
        if (osPropLower.indexOf("linux") != -1) {
            return OS.LINUX;
        }
        if (osPropLower.indexOf("windows") != -1) {
            return OS.WINDOWS;
        }
        return OS.UNSUPPORTED;
    }

    private static boolean isJDK9OrHigher() {
        String javaVersion = System.getProperty("java.version");
        int indexOfFirstDot = javaVersion.indexOf(".");
        if (indexOfFirstDot >= 0) {
            try {
                return Integer.valueOf(javaVersion.substring(0, indexOfFirstDot)) >= 9;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private static void setLookAndFeel() {
        if (!theOS.isMacOs()) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                JvmProfiler.logInfo("Could not install the system look and feel.");
                JvmProfiler.logException(e);
            }
        }
    }

    private static void getWorkspaceLocation() throws IOException {
        String userHome = System.getProperty("user.home");
        String defaultWorkspace = userHome + File.separator + WORKSPACE_DIRECTORY;
        File wpMarkerFile = new File(userHome, ".profiler24");
        Properties props = new Properties();
        if (wpMarkerFile.exists()) {
            try {
                props.load(new FileInputStream(wpMarkerFile));
                instanceLocation = props.getProperty("WP_LOCATION");
            }
            catch (IOException e) {
                Trace.error((Throwable)e);
                props = new Properties();
            }
        }
        if (instanceLocation == null) {
            String home = System.getProperty("user.home") + File.separator + WORKSPACE_DIRECTORY;
            instanceLocation = new File(home + "\\.metadata\\.plugins\\com.sap.jvm.profiling.ui.workbench\\workspace").exists() ? home : WorkspaceSelectDialog.show(defaultWorkspace, null);
            if (instanceLocation == null || instanceLocation.isEmpty()) {
                throw new IOException("Workspace location must hava a value after running the selection dialog.");
            }
            wpMarkerFile.createNewFile();
            props.put("WP_LOCATION", instanceLocation);
            props.put("WP_SWITCH_KEY", String.valueOf(false));
            props.store(new FileOutputStream(wpMarkerFile), "SAPJVM Profiler Workspace");
        } else if (Boolean.parseBoolean(props.getProperty("WP_SWITCH_KEY"))) {
            String wp;
            ArrayList<String> history = new ArrayList<String>();
            for (int i = 0; i < 10 && (wp = props.getProperty("WP_HISTORY_" + i)) != null; ++i) {
                history.add(wp);
            }
            if ((instanceLocation = WorkspaceSelectDialog.show(instanceLocation, history)) == null || instanceLocation.isEmpty()) {
                throw new IOException("Workspace location must hava a value after running the selection dialog.");
            }
            props.put("WP_LOCATION", instanceLocation);
            props.put("WP_SWITCH_KEY", String.valueOf(false));
            props.store(new FileOutputStream(wpMarkerFile), "SAPJVM Profiler Workspace");
        }
    }

    private static void setLogFile() {
        File logDir = new File(instanceLocation + "/configuration");
        if (!logDir.exists() && !logDir.mkdirs()) {
            return;
        }
        File logFile = new File(logDir, "startup.log");
        if (!logFile.exists()) {
            try {
                logFile.createNewFile();
            }
            catch (IOException e) {
                return;
            }
        }
        if (!logFile.canWrite()) {
            return;
        }
        try {
            out = new PrintStream(new FileOutputStream(logFile, false), true);
        }
        catch (FileNotFoundException e) {
            return;
        }
    }

    private static void determineOSArchitecture() throws Exception {
        JvmProfiler.logInfo("Checking the runtime environment...");
        switch (theOS) {
            case LINUX: {
                os = "linux";
                ws = "gtk";
                break;
            }
            case MACOS: {
                os = "macosx";
                ws = "cocoa";
                break;
            }
            case WINDOWS: {
                os = "win32";
                ws = "win32";
                break;
            }
            default: {
                String problem = "Invalid OS. " + osProperty + " is not supported by the SAP JVM Profiler.";
                JvmProfiler.logError(problem);
                throw new Exception(problem);
            }
        }
        if ("i386".equals(archProperty) || "x86".equals(archProperty)) {
            arch = "x86";
        } else if ("amd64".equals(archProperty) || "x86_64".equals(archProperty)) {
            arch = "x86_64";
        } else if ("ia64".equals(archProperty)) {
            arch = "ia64";
        } else {
            String problem = "Invalid platform architecture. " + archProperty + " is not supported by the SAP JVM Profiler.";
            JvmProfiler.logError(problem);
            throw new Exception(problem);
        }
    }

    private static void resolveBundles() throws Exception {
        JvmProfiler.logInfo("Resolving the Eclipse startup bundle...");
        File pluginsDir = new File(javaHome + "/lib/plugins");
        for (File bundle : pluginsDir.listFiles()) {
            if (!bundle.getName().startsWith("org.eclipse.osgi_")) continue;
            OSGIBundle = bundle;
        }
        if (OSGIBundle == null) {
            JvmProfiler.logError("OSGI Bundle is unresolved");
            throw new IOException("OSGI Bundle is unresolved");
        }
        URLClassLoader initialEclipseUCL = new URLClassLoader(new URL[]{OSGIBundle.toURI().toURL()});
        Class<?> eclipseStarterClass = initialEclipseUCL.loadClass("org.eclipse.core.runtime.adaptor.EclipseStarter");
        eclipseStarterRun = eclipseStarterClass.getMethod("run", String[].class, Runnable.class);
    }

    private static void parseArguments(String[] args) {
        JvmProfiler.logInfo("Parsing arguments...");
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (new File(args[i]).isFile()) {
                    JvmProfiler.logInfo("File argument: " + args[i]);
                    if (fileArgs.length() > 0) {
                        fileArgs.append("%SEP%");
                    }
                    fileArgs.append(args[i]);
                    continue;
                }
                JvmProfiler.logInfo("Eclipse argument: " + args[i]);
                eclipseArgsList.add(args[i]);
            }
        }
    }

    private static void setEclipseRuntimeProperties() {
        JvmProfiler.logInfo("Setting up profiler runtime...");
        System.setProperty("eclipse.product", "com.sap.jvm.profiling.ui.rcp.SapJVMProfilingProduct");
        System.setProperty("osgi.instance.area", instanceLocation);
        System.setProperty("osgi.configuration.area", instanceLocation + "/configuration");
        System.setProperty("osgi.os", os);
        System.setProperty("osgi.ws", ws);
        System.setProperty("osgi.arch", arch);
        System.setProperty("osgi.bundles", "com.ibm.icu,com.sap.tools.memory.bobj,com.sap.tools.memory.netweaver.ui,com.sap.tools.memory.netweaver,com.sap.tools.memory.scripts,com.sap.tools.memory.sidecar,com.sap.tools.offlineanalysis.api,com.sap.tools.offlineanalysis.branding,com.sap.tools.threads.api,com.sap.tools.threads.ui,javax.el,javax.inject,javax.servlet.jsp,javax.servlet,org.apache.batik.constants,org.apache.batik.css,org.apache.batik.i18n,org.apache.batik.util,org.apache.commons.codec,org.apache.commons.io,org.apache.commons.jxpath,org.apache.commons.logging,org.apache.felix.scr,org.apache.jasper.glassfish,org.apache.lucene.analyzers-common,org.apache.lucene.analyzers-smartcn,org.apache.lucene.core,org.apache.xmlgraphics,org.eclipse.birt.chart.device.extension,org.eclipse.birt.chart.device.swt,org.eclipse.birt.chart.engine.extension,org.eclipse.birt.chart.engine,org.eclipse.birt.core,org.eclipse.compare.core, org.eclipse.core.commands,org.eclipse.core.contenttype,org.eclipse.core.databinding.observable,org.eclipse.core.databinding.property,org.eclipse.core.databinding,org.eclipse.core.expressions,org.eclipse.core.filebuffers,org.eclipse.core.filesystem, org.eclipse.core.jobs,org.eclipse.core.net,org.eclipse.core.resources,org.eclipse.core.runtime@start,org.eclipse.core.variables,org.eclipse.e4.core.commands,org.eclipse.e4.core.contexts,org.eclipse.e4.core.di.annotations,org.eclipse.e4.core.di.extensions.supplier,org.eclipse.e4.core.di.extensions,org.eclipse.e4.core.di,org.eclipse.e4.core.services,org.eclipse.e4.emf.xpath,org.eclipse.e4.ui.bindings,org.eclipse.e4.ui.css.core,org.eclipse.e4.ui.css.swt.theme,org.eclipse.e4.ui.css.swt,org.eclipse.e4.ui.di,org.eclipse.e4.ui.dialogs,org.eclipse.e4.ui.ide,org.eclipse.e4.ui.model.workbench,org.eclipse.e4.ui.services,org.eclipse.e4.ui.widgets,org.eclipse.e4.ui.workbench.addons.swt,org.eclipse.e4.ui.workbench.renderers.swt,org.eclipse.e4.ui.workbench.swt,org.eclipse.e4.ui.workbench,org.eclipse.e4.ui.workbench3,org.eclipse.emf.common,org.eclipse.emf.ecore.change,org.eclipse.emf.ecore.xmi,org.eclipse.emf.ecore,org.eclipse.equinox.app,org.eclipse.equinox.bidi,org.eclipse.equinox.common@2:start,org.eclipse.equinox.ds@1:start,org.eclipse.equinox.event,org.eclipse.equinox.http.jetty,org.eclipse.equinox.http.registry,org.eclipse.equinox.http.servlet,org.eclipse.equinox.jsp.jasper.registry,org.eclipse.equinox.jsp.jasper,org.eclipse.equinox.p2.core, org.eclipse.equinox.p2.engine,org.eclipse.equinox.p2.metadata.repository, org.eclipse.equinox.p2.metadata,org.eclipse.equinox.p2.repository,org.eclipse.equinox.preferences,org.eclipse.equinox.registry,org.eclipse.equinox.security, org.eclipse.help.base,org.eclipse.help.ui,org.eclipse.help.webapp,org.eclipse.help,org.eclipse.jdt.annotation,org.eclipse.jetty.http,org.eclipse.jetty.io,org.eclipse.jetty.security,org.eclipse.jetty.server,org.eclipse.jetty.servlet,org.eclipse.jetty.util,org.eclipse.jface.databinding,org.eclipse.jface.text,org.eclipse.jface,org.eclipse.mat.api,org.eclipse.mat.chart.ui,org.eclipse.mat.chart,org.eclipse.mat.hprof,org.eclipse.mat.jruby.resolver,org.eclipse.mat.parser,org.eclipse.mat.report,org.eclipse.mat.ui.help,org.eclipse.mat.ui,org.eclipse.osgi.services,org.eclipse.osgi.util,org.eclipse.pde.runtime,org.eclipse.swt." + ws + "." + os + "." + arch + ",org.eclipse.swt,org.eclipse.text,org.eclipse.ui.cheatsheets,org.eclipse.ui.editors@start, org.eclipse.ui.forms,org.eclipse.ui.ide, org.eclipse.ui.intro,org.eclipse.ui.navigator,org.eclipse.ui.views.log,org.eclipse.ui.views,org.eclipse.ui.workbench.texteditor,org.eclipse.ui.workbench,org.eclipse.ui,org.eclipse.urischeme,org.mozilla.javascript,org.tukaani.xz,org.w3c.css.sac,org.w3c.dom.events,org.w3c.dom.smil,org.w3c.dom.svg,com.sap.jvm.i18n,com.sap.jvm.inspector,com.sap.jvm.profiling.controller,com.sap.jvm.profiling.core,com.sap.jvm.profiling.presentation,com.sap.jvm.profiling.snapshot,com.sap.jvm.profiling.ui.help,com.sap.jvm.profiling.ui.icons,com.sap.jvm.profiling.ui.library.swt,com.sap.jvm.profiling.ui.library,com.sap.jvm.profiling.ui.rcp,com.sap.jvm.profiling.ui.util,com.sap.jvm.profiling.ui.widgets.sap.internal,com.sap.jvm.profiling.ui.widgets,com.sap.jvm.profiling.ui.workbench,com.sap.jvm.se,com.sap.jvm.tools.core");
        System.setProperty("osgi.clean", "true");
        System.setProperty("osgi.bundles.defaultStartLevel", "4");
        System.setProperty("osgi.install.area", "file:" + javaHome + "/lib");
        System.setProperty("osgi.framework", "file:" + OSGIBundle.getAbsolutePath());
        System.setProperty("osgi.configuration.cascaded", "false");
        if (fileArgs.length() > 0) {
            System.setProperty("prf.startup.file", fileArgs.toString());
        }
    }

    private static void startProfiler() throws Exception {
        JvmProfiler.logInfo("Starting the SAP JVM Profiler RCP Application...");
        Runnable splashTearDown = SplashScreen.getTearDown();
        Object result = null;
        try {
            result = eclipseStarterRun.invoke(null, eclipseArgsList.toArray(new String[eclipseArgsList.size()]), splashTearDown);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            JvmProfiler.logError("Starting the SAP JVM Profiler failed.");
            JvmProfiler.logException(e);
            throw e;
        }
        finally {
            splashTearDown.run();
        }
        if (result == null) {
            JvmProfiler.logWarning("EclipseStarter.run(...) returned null.\n" + instanceLocation + "/.metadata/.log may contain additional information.");
        } else if (EXIT_RESTART.equals(result)) {
            ArrayList<String> commandLine = new ArrayList<String>(5);
            commandLine.add(javaHome + (theOS.isWindows() ? "/bin/javaw" : "/bin/java"));
            if (theOS.isMacOs()) {
                commandLine.add("-XstartOnFirstThread");
            }
            if (isJDKModularized) {
                commandLine.add("--add-modules=sapjvm.profiling.tools");
            } else {
                commandLine.add("-cp");
                commandLine.add(javaHome + "/lib/sapjvm-tools.jar");
            }
            commandLine.add("com.sap.jvm.profiling.startup.JvmProfiler");
            new ProcessBuilder(commandLine).start();
        }
        System.exit(0);
    }

    static void logError(String msg) {
        out.println(date.format(new Date()) + " ERROR     : " + msg);
    }

    static void logWarning(String msg) {
        out.println(date.format(new Date()) + " WARNING   : " + msg);
    }

    static void logInfo(String msg) {
        out.println(date.format(new Date()) + " INFO      : " + msg);
    }

    static void logException(Throwable th) {
        out.println(date.format(new Date()) + " EXCEPTION : " + th.getMessage());
        out.println();
        th.printStackTrace(out);
    }

    static {
        out = System.err;
        date = new SimpleDateFormat("[yyyy/MM/dd HH:mm:ss]");
        instanceLocation = null;
        eclipseArgsList = new ArrayList<String>();
        fileArgs = new StringBuilder();
    }

    public static enum OS {
        WINDOWS,
        MACOS,
        LINUX,
        UNSUPPORTED;


        public boolean isWindows() {
            return this == WINDOWS;
        }

        public boolean isMacOs() {
            return this == MACOS;
        }

        public boolean isLinux() {
            return this == LINUX;
        }
    }
}

