/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.startup;

import com.sap.jvm.profiling.startup.JvmProfiler;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JWindow;

public class SplashScreen {
    private static JWindow splash = null;
    private static Process splashProcess = null;

    private static void createSplash() {
        splash = new JWindow();
        splash.setAlwaysOnTop(false);
        final ImageIcon splashImage = new ImageIcon(JvmProfiler.class.getResource("splash.png"));
        Canvas cvn = new Canvas(){
            private static final long serialVersionUID = -1862679913443351647L;

            @Override
            public void paint(Graphics g) {
                g.setFont(new Font("SansSerif", 0, 11));
                g.drawImage(splashImage.getImage(), 0, 0, null);
                g.drawString("Version: 2.4.14", 27, 100);
                g.setFont(new Font("SansSerif", 0, 10));
                g.setColor(new Color(0x808080));
                g.drawString("\u00a9 Copyright SAP SE, 2005-2018.  All rights reserved.", 27, 310);
            }
        };
        splash.getContentPane().add(cvn);
        splash.setSize(splashImage.getIconWidth(), splashImage.getIconHeight());
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        splash.setLocation(screen.width / 2 - splashImage.getIconWidth() / 2, screen.height / 2 - splashImage.getIconHeight() / 2);
        splash.setVisible(true);
    }

    static void show() {
        if (!JvmProfiler.theOS.isMacOs()) {
            SplashScreen.createSplash();
        } else {
            try {
                ArrayList<String> commandLine = new ArrayList<String>(4);
                commandLine.add(JvmProfiler.javaHome + (JvmProfiler.theOS.isWindows() ? "/bin/javaw" : "/bin/java"));
                if (JvmProfiler.isJDKModularized) {
                    commandLine.add("--add-modules=sapjvm.profiling.tools");
                } else {
                    commandLine.add("-cp");
                    commandLine.add(JvmProfiler.javaHome + "/lib/jvmx_tools_impl.jar");
                }
                commandLine.add("com.sap.jvm.profiling.startup.SplashScreen");
                splashProcess = new ProcessBuilder(commandLine).start();
            }
            catch (IOException e) {
                JvmProfiler.logError("Caught IOException when forking a new process to display the splash screen.");
                JvmProfiler.logException(e);
            }
        }
    }

    public static void main(String[] args) {
        SplashScreen.createSplash();
    }

    static Runnable getTearDown() {
        return new Runnable(){

            @Override
            public void run() {
                if (splash != null) {
                    splash.dispose();
                    splash = null;
                }
                if (splashProcess != null) {
                    splashProcess.destroy();
                    splashProcess = null;
                }
            }

            public void updateSplash() {
            }
        };
    }
}

