/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.startup;

import com.sap.jvm.profiling.startup.JvmProfiler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class WorkspaceSelectDialog
extends JDialog {
    private static final long serialVersionUID = 4182444466246744580L;
    public static String selectedWSP = null;
    private JButton butOk;

    private static void runDialog(String proposal, List<String> history) {
        WorkspaceSelectDialog wsd = new WorkspaceSelectDialog(proposal, history);
        wsd.setVisible(true);
    }

    static String show(String proposal, List<String> history) {
        if (!JvmProfiler.theOS.isMacOs()) {
            WorkspaceSelectDialog.runDialog(proposal, history);
        } else {
            try {
                ArrayList<String> commandLine = new ArrayList<String>(4);
                commandLine.add(JvmProfiler.javaHome + (JvmProfiler.theOS.isWindows() ? "/bin/javaw" : "/bin/java"));
                if (JvmProfiler.isJDKModularized) {
                    commandLine.add("--add-modules=sapjvm.profiling.tools");
                } else {
                    commandLine.add("-cp");
                    commandLine.add(JvmProfiler.javaHome + "/lib/jvmx_tools_impl.jar");
                }
                commandLine.add("com.sap.jvm.profiling.startup.WorkspaceSelectDialog");
                Process p = new ProcessBuilder(commandLine).start();
                BufferedWriter w = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
                w.write(proposal);
                if (history != null) {
                    for (String line : history) {
                        w.write("\n" + line);
                    }
                }
                w.close();
                BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
                selectedWSP = r.readLine();
                while (p.isAlive()) {
                    try {
                        p.waitFor();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                JvmProfiler.logError("Caught IOException when forking a new process to display a workspace selector.");
                JvmProfiler.logException(e);
                selectedWSP = null;
            }
        }
        return selectedWSP == null ? proposal : selectedWSP;
    }

    public static void main(String[] args) {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(System.out));
        try {
            String proposal = in.readLine();
            ArrayList<String> history = null;
            String line = in.readLine();
            if (line != null) {
                history = new ArrayList<String>();
                while (line != null) {
                    history.add(line);
                    line = in.readLine();
                }
            }
            WorkspaceSelectDialog.runDialog(proposal, history);
            out.write(selectedWSP == null ? proposal : selectedWSP);
            out.close();
        }
        catch (IOException e) {
            System.err.println("Caught IOException in WorkspaceSelectDialog");
            e.printStackTrace(System.err);
        }
    }

    private WorkspaceSelectDialog(String proposal, List<String> history) {
        super((Frame)null, "Workspace?", true);
        this.setLayout(new BorderLayout());
        JPanel pnlHeader = new JPanel(new BorderLayout());
        this.add((Component)pnlHeader, "North");
        JTextField txtHeader = new JTextField("Select workspace location");
        txtHeader.setBorder(new EmptyBorder(10, 10, 1, 1));
        txtHeader.setFont(new Font(txtHeader.getFont().getName(), 1, txtHeader.getFont().getSize() + 1));
        txtHeader.setEditable(false);
        pnlHeader.add((Component)txtHeader, "North");
        JTextArea txtHeaderText = new JTextArea("The profiler workspace is used for persisting the session data and runtime configurations. Choose the folder for the workspace.");
        txtHeaderText.setLineWrap(true);
        txtHeaderText.setWrapStyleWord(true);
        txtHeaderText.setEditable(false);
        txtHeaderText.setBorder(new EmptyBorder(1, 21, 10, 1));
        txtHeaderText.setFont(new Font(txtHeaderText.getFont().getName(), 0, txtHeaderText.getFont().getSize() - 1));
        pnlHeader.add((Component)txtHeaderText, "Center");
        txtHeader.setBackground(txtHeaderText.getBackground());
        pnlHeader.add((Component)new JSeparator(), "South");
        JPanel pnlButtons = new JPanel();
        pnlButtons.setLayout(new FlowLayout(2));
        this.add((Component)pnlButtons, "South");
        JPanel pnlB = new JPanel();
        pnlB.setLayout(new GridLayout(1, 2, 5, 5));
        this.butOk = new JButton("Ok");
        JButton butCancel = new JButton("Cancel");
        pnlButtons.setBorder(new EmptyBorder(15, 1, 1, 1));
        pnlB.add(this.butOk);
        pnlB.add(butCancel);
        pnlButtons.add(pnlB);
        butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(1);
            }
        });
        JPanel pnlMain = new JPanel();
        this.add((Component)pnlMain, "Center");
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        pnlMain.setLayout(gridbag);
        JLabel lblWp = new JLabel("Workspace: ");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(10, 4, 2, 4);
        gridbag.setConstraints(lblWp, gbc);
        pnlMain.add(lblWp);
        final JComboBox txtWp = history == null ? new JComboBox() : new JComboBox<String>(history.toArray(new String[history.size()]));
        txtWp.setEditable(true);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        gridbag.setConstraints(txtWp, gbc);
        pnlMain.add(txtWp);
        JButton butBrowse = new JButton("Browse");
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gridbag.setConstraints(butBrowse, gbc);
        pnlMain.add(butBrowse);
        final JTextField txtInput = (JTextField)txtWp.getEditor().getEditorComponent();
        txtInput.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                WorkspaceSelectDialog.this.checkState(txtInput.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                WorkspaceSelectDialog.this.checkState(txtInput.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                WorkspaceSelectDialog.this.checkState(txtInput.getText());
            }
        });
        txtInput.setText(proposal);
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                selectedWSP = txtInput.getText();
                if (!new File(selectedWSP).exists()) {
                    if (JOptionPane.showConfirmDialog(WorkspaceSelectDialog.this, "The specified workspace location does not exist, would you like to create it?", "Create New Workspace Location?", 0) == 0) {
                        File dir = new File(txtInput.getText());
                        if (!dir.mkdirs()) {
                            JOptionPane.showMessageDialog(WorkspaceSelectDialog.this, "The directory (" + txtInput.getText() + ") could not be created! Supposedly you have wrong name specification or no permissions.", "Invalid Directory Specification!", 0);
                        } else {
                            WorkspaceSelectDialog.this.setVisible(false);
                            WorkspaceSelectDialog.this.dispose();
                        }
                    }
                } else {
                    WorkspaceSelectDialog.this.setVisible(false);
                    WorkspaceSelectDialog.this.dispose();
                }
            }
        });
        butBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser files;
                String path = ((JTextField)txtWp.getEditor().getEditorComponent()).getText();
                File folder = new File(path);
                if (folder.exists()) {
                    files = new JFileChooser();
                    files.setSelectedFile(folder);
                } else {
                    files = new JFileChooser(new File("."));
                }
                files.setFileSelectionMode(1);
                files.setSelectedFile(folder);
                if (0 == files.showOpenDialog(WorkspaceSelectDialog.this)) {
                    txtWp.insertItemAt(files.getSelectedFile().getAbsolutePath(), 0);
                    txtWp.setSelectedIndex(0);
                }
                WorkspaceSelectDialog.this.checkState(txtInput.getText());
            }
        });
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screen.width / 2 - this.getSize().width / 2, screen.height / 2 - this.getSize().height);
        this.pack();
        this.setSize(500, 200);
        this.setResizable(false);
    }

    private void checkState(String text) {
        if (text == null || text.trim().length() == 0) {
            this.butOk.setEnabled(false);
        } else {
            this.butOk.setEnabled(true);
        }
    }
}

