/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools;

import com.sap.jvm.internal.util.cmdline.CommandLineParser;
import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.memory.event.AllocationEvent;
import com.sap.jvm.profiling.tools.GenericPacketReader;
import com.sap.jvm.profiling.util.IdentityHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AllocationOverviewReport {
    public static void main(String[] args) throws Exception {
        CommandLineParser.OptionalEqualsOption nrOfMethodsOption = new CommandLineParser.OptionalEqualsOption("nr");
        CommandLineParser.Option[] options = new CommandLineParser.Option[]{nrOfMethodsOption};
        CommandLineParser parser = new CommandLineParser(args, options, false);
        String[] unparsedStrings = parser.getRemainingArguments();
        if (unparsedStrings.length == 0) {
            System.out.println("Creates the allocation overview report");
            System.out.println();
            System.out.println("Syntax: AllocationOverviewReport [<options> ...] <prf-file>");
            System.out.println();
            System.out.println("The following options are supported: ");
            System.out.println("--nr=<nr of methods>:");
            System.out.println("            The maximum number of methods to include.");
            System.exit(1);
        }
        int maxMethods = 6;
        if (parser.isOptionSet(nrOfMethodsOption)) {
            maxMethods = Integer.parseInt(parser.getValue(nrOfMethodsOption));
        }
        try (GenericPacketReader reader = new GenericPacketReader(unparsedStrings[0]);){
            AllocationOverviewReport.createReport(reader, maxMethods);
        }
    }

    private static void createReport(GenericPacketReader reader, int maxMethods) throws IOException {
        ProfilingPacket packet;
        ProfilingSession session = reader.getSession();
        HashMap<Integer, Long> stacks = new HashMap<Integer, Long>();
        long overallBytes = 0L;
        double minFraction = 0.8;
        while ((packet = reader.nextPacket()) != null) {
            if (!(packet instanceof AllocationEvent)) continue;
            AllocationEvent event = (AllocationEvent)packet;
            int stack = event.getStackTraceIndex();
            long size = event.getSize() * (long)event.getNrOfAllocations();
            overallBytes += size;
            Long newSize = (Long)stacks.get(stack);
            newSize = newSize == null ? Long.valueOf(size) : Long.valueOf(newSize + size);
            stacks.put(stack, newSize);
        }
        System.out.println(overallBytes);
        long minSize = overallBytes / (long)maxMethods / 5L;
        long[] sizes = new long[1024 + session.getMethodObjectManager().getNrOfMethods()];
        int[] mapping = new int[sizes.length];
        ArrayList<MethodObject> availableMethods = new ArrayList<MethodObject>();
        StackFrames frames = session.getStackTraceManager().getStackFramesObject(true);
        IdentityHashSet seenMethods = new IdentityHashSet();
        for (Map.Entry entry : stacks.entrySet()) {
            long size = (Long)entry.getValue();
            frames.fillIn(((Integer)entry.getKey()).intValue());
            seenMethods.clear();
            for (int i = frames.getNrOfFrames() - 1; i >= 0; --i) {
                long newSize;
                MethodObject method = frames.getMethod(i);
                if (seenMethods.contains((Object)method)) continue;
                int index = method.getIndex();
                long oldSize = sizes[index];
                sizes[index] = newSize = oldSize + size;
                if (oldSize < minSize && newSize >= minSize) {
                    assert (!availableMethods.contains(method));
                    availableMethods.add(method);
                }
                seenMethods.add((Object)method);
            }
        }
        System.out.println(availableMethods.size() + " methods have size >= " + minSize);
        IdentityHashSet includedMethods = new IdentityHashSet();
        long defSize = (long)((double)overallBytes * minFraction / (double)maxMethods);
        block3: while (true) {
            int i;
            MethodInfo[] infos = AllocationOverviewReport.getMethodInfos(availableMethods, stacks, frames, mapping);
            System.out.println("Reduced to " + infos.length + " methods");
            infos = AllocationOverviewReport.getSortedByDomination(infos, 10.0);
            Map<ReducedStack, Long> reducedMapping = AllocationOverviewReport.getReducedStacks(availableMethods, stacks, frames, mapping);
            System.out.println("Using " + reducedMapping.size() + " reduced stack traces");
            int[][] reducedStacks = new int[reducedMapping.size()][];
            long[] reducedSizes = new long[reducedMapping.size()];
            int ri = 0;
            for (Map.Entry<ReducedStack, Long> entry : reducedMapping.entrySet()) {
                reducedStacks[ri] = entry.getKey().stack;
                reducedSizes[ri] = entry.getValue();
                ++ri;
            }
            double mdg = -1.7976931348623157E308;
            double mindg = (double)maxMethods / ((double)maxMethods + 2.0);
            for (int i2 = 0; i2 < 100000000; ++i2) {
                boolean[] methods = new boolean[infos.length];
                int j = 0;
                while (j < maxMethods) {
                    int index = (int)(Math.random() * (double)infos.length);
                    if (methods[index]) continue;
                    methods[index] = true;
                    ++j;
                }
                Info info = AllocationOverviewReport.getReducedInfo(reducedStacks, reducedSizes, methods);
                double dg = 1.0 * (double)info.dominating / (double)overallBytes;
                double dd = 1.0 * (double)info.dominated / (double)overallBytes;
                double nd = 2.0 + info.dist / (double)maxMethods / Math.log(maxMethods);
                if (!(dg >= mindg) || !(nd - dd > mdg)) continue;
                mdg = nd - dd;
                System.out.println(i2 + " " + mdg + " " + dd + " " + dg);
                block7: for (int j2 = 0; j2 < methods.length; ++j2) {
                    if (!methods[j2]) continue;
                    for (MethodObject m : availableMethods) {
                        if (mapping[m.getIndex()] != j2) continue;
                        System.out.println(m);
                        continue block7;
                    }
                }
            }
            System.exit(0);
            long top = 0L;
            for (i = 0; i < maxMethods; ++i) {
                top += infos[i].dominating;
                if (infos[i].dominating - infos[i].dominated < defSize) continue;
                includedMethods.add((Object)infos[i].method);
            }
            for (i = 0; i < maxMethods; ++i) {
                MethodInfo info = infos[i];
                System.out.println(info.dominating + " (" + info.dominated + ") " + info.method);
            }
            System.out.println(infos.length);
            if ((double)top > (double)overallBytes * minFraction || availableMethods.size() <= maxMethods) break;
            Arrays.sort(infos, new Comparator<MethodInfo>(){

                @Override
                public int compare(MethodInfo m1, MethodInfo m2) {
                    Long l1 = m1.principally_dominating + m1.dominating + m1.dominated - m1.principally_dominated;
                    Long l2 = m2.principally_dominating + m2.dominating + m2.dominated - m2.principally_dominated;
                    return l1.compareTo(l2);
                }
            });
            i = 0;
            while (true) {
                if (i > infos.length / 10) continue block3;
                availableMethods.remove(infos[i].method);
                ++i;
            }
            break;
        }
    }

    private static Info getReducedInfo(int[][] reducedStacks, long[] reducedSizes, boolean[] methods) {
        int i;
        Info info = new Info();
        long[] cs = new long[methods.length];
        for (i = 0; i < reducedStacks.length; ++i) {
            boolean hasFirst = false;
            boolean hasSecond = false;
            for (int mi : reducedStacks[i]) {
                if (!methods[mi]) continue;
                if (!hasFirst) {
                    hasFirst = true;
                    int n = mi;
                    cs[n] = cs[n] + reducedSizes[i];
                    continue;
                }
                if (hasSecond) break;
                hasSecond = true;
            }
            if (!hasFirst) continue;
            info.dominating += reducedSizes[i];
            if (!hasSecond) continue;
            info.dominated += reducedSizes[i];
        }
        for (i = 0; i < cs.length; ++i) {
            if (!methods[i]) continue;
            info.dist += Math.log((double)cs[i] * 1.0 / (double)info.dominating);
        }
        return info;
    }

    private static MethodInfo[] getSortedByDomination(MethodInfo[] infos, double maxDominated) {
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        for (MethodInfo info : infos) {
            double d = 1.0 * (double)info.dominating / (double)(info.dominating + info.dominated);
            if (!(d <= maxDominated)) continue;
            result.add(info);
        }
        Collections.sort(result, new Comparator<MethodInfo>(){

            @Override
            public int compare(MethodInfo m1, MethodInfo m2) {
                Long l1 = m1.dominating;
                Long l2 = m2.dominating;
                return -l1.compareTo(l2);
            }
        });
        return result.toArray(new MethodInfo[result.size()]);
    }

    private static Map<ReducedStack, Long> getReducedStacks(List<MethodObject> methods, Map<Integer, Long> stacks, StackFrames frames, int[] mapping) {
        HashMap<ReducedStack, Long> reducedStacks = new HashMap<ReducedStack, Long>();
        for (int i = 0; i < methods.size(); ++i) {
            mapping[methods.get((int)i).getIndex()] = i;
        }
        int[] stack = new int[8192];
        IdentityHashSet seenMethods = new IdentityHashSet(2 * methods.size());
        for (Map.Entry<Integer, Long> entry : stacks.entrySet()) {
            long size = entry.getValue();
            frames.fillIn(entry.getKey().intValue());
            seenMethods.clear();
            int stackIndex = 0;
            for (int i = frames.getNrOfFrames() - 1; i >= 0; --i) {
                MethodObject m = frames.getMethod(i);
                if (!methods.contains(m) || seenMethods.contains((Object)m)) continue;
                seenMethods.add((Object)m);
                stack[stackIndex] = mapping[m.getIndex()];
                ++stackIndex;
            }
            if (stackIndex <= 0) continue;
            ReducedStack reducedStack = new ReducedStack();
            reducedStack.stack = new int[stackIndex];
            System.arraycopy(stack, 0, reducedStack.stack, 0, stackIndex);
            Long old = (Long)reducedStacks.get(reducedStack);
            if (old != null) {
                reducedStacks.put(reducedStack, old + size);
                continue;
            }
            reducedStacks.put(reducedStack, size);
        }
        return reducedStacks;
    }

    private static MethodInfo[] getMethodInfos(List<MethodObject> methods, Map<Integer, Long> stacks, StackFrames frames, int[] mapping) {
        MethodInfo[] infos = new MethodInfo[methods.size()];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new MethodInfo();
            infos[i].method = methods.get(i);
            mapping[methods.get((int)i).getIndex()] = i;
        }
        int[] stack = new int[8192];
        long[][] matrix = new long[methods.size()][];
        for (int i = methods.size() - 1; i >= 0; --i) {
            matrix[i] = new long[methods.size()];
        }
        IdentityHashSet seenMethods = new IdentityHashSet(2 * methods.size());
        for (Map.Entry<Integer, Long> entry : stacks.entrySet()) {
            int i;
            long size = entry.getValue();
            frames.fillIn(entry.getKey().intValue());
            seenMethods.clear();
            int stackIndex = 0;
            for (i = frames.getNrOfFrames() - 1; i >= 0; --i) {
                MethodObject m = frames.getMethod(i);
                if (!methods.contains(m) || seenMethods.contains((Object)m)) continue;
                seenMethods.add((Object)m);
                stack[stackIndex] = mapping[m.getIndex()];
                ++stackIndex;
            }
            for (i = 0; i < stackIndex; ++i) {
                int m1 = stack[i];
                long[] row = matrix[m1];
                if (i == 0) {
                    infos[m1].dominating += size;
                } else {
                    infos[m1].dominated += size;
                }
                for (int j = i; j < stackIndex; ++j) {
                    int n = stack[j];
                    row[n] = row[n] + size;
                }
            }
        }
        for (MethodObject method : methods) {
            int mi = mapping[method.getIndex()];
            long max1 = 0L;
            long max2 = 0L;
            for (int i = 0; i < matrix.length; ++i) {
                if (i == mi) continue;
                max1 = Math.max(max1, matrix[i][mi]);
                max2 = Math.max(max2, matrix[mi][i]);
            }
            infos[mi].principally_dominated = max1;
            infos[mi].principally_dominating = max2;
        }
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        for (MethodInfo info : infos) {
            if ((double)info.principally_dominated < 0.95 * (double)(info.dominating + info.dominated)) {
                result.add(info);
                continue;
            }
            methods.remove(info.method);
        }
        return result.toArray(new MethodInfo[result.size()]);
    }

    private static class ReducedStack {
        public int[] stack;

        private ReducedStack() {
        }

        public boolean equals(Object other) {
            if (other instanceof ReducedStack) {
                ReducedStack otherStack = (ReducedStack)other;
                return Arrays.equals(this.stack, otherStack.stack);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.stack);
        }
    }

    private static class MethodInfo
    extends Info {
        public MethodObject method;

        private MethodInfo() {
        }
    }

    private static class Info {
        public long dominating;
        public long dominated;
        public long principally_dominating;
        public long principally_dominated;
        public double dist;

        private Info() {
        }
    }
}

