/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.DetailedProfilingPrintStream;
import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.sync.event.ReentrantLockEnterEvent;
import com.sap.jvm.profiling.sync.event.ReentrantLockEnteredEvent;
import com.sap.jvm.profiling.tools.GenericPacketReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class FindBlockingReentrantLocks {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("FindBlockingRecursiveLocks <prf-file>");
            return;
        }
        try (GenericPacketReader reader = new GenericPacketReader(args[0]);){
            FindBlockingReentrantLocks.dumpPackets(reader);
        }
    }

    private static void dumpPackets(GenericPacketReader reader) throws IOException {
        ProfilingPacket packet;
        ProfilingSession session = reader.getSession();
        LinkedList<ReentrantLockEnterEvent> blockEvents = new LinkedList<ReentrantLockEnterEvent>();
        while ((packet = reader.nextPacket()) != null) {
            if (packet instanceof ReentrantLockEnterEvent) {
                blockEvents.add((ReentrantLockEnterEvent)packet);
                continue;
            }
            if (!(packet instanceof ReentrantLockEnteredEvent)) continue;
            ReentrantLockEnteredEvent e = (ReentrantLockEnteredEvent)packet;
            Iterator it = blockEvents.iterator();
            while (it.hasNext()) {
                ReentrantLockEnterEvent e2 = (ReentrantLockEnterEvent)it.next();
                if (e2.getThreadIndex() != e.getThreadIndex()) continue;
                it.remove();
            }
        }
        DetailedProfilingPrintStream stream = new DetailedProfilingPrintStream(System.out, 4, 10000, session);
        for (ReentrantLockEnterEvent e : blockEvents) {
            e.print((ProfilingPrintStream)stream);
        }
    }
}

