/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools;

import com.sap.jvm.internal.util.cmdline.CommandLineParser;
import com.sap.jvm.monitor.vm.VmInfo;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.ControllerFactory;
import com.sap.jvm.profiling.controller.FileController;
import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.tools.FirstNPacketsMatcher;
import com.sap.jvm.profiling.tools.FromToPacketMatcher;
import com.sap.jvm.profiling.tools.LastNPacketsMatcher;
import com.sap.jvm.profiling.tools.OrPacketMatcher;
import com.sap.jvm.profiling.tools.PacketMatcher;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public final class GenericPacketReader
implements AutoCloseable {
    private ProfilingReader reader;
    private final String file;
    private volatile File tmpDir;
    private ProfilingSession session;
    private FileController controller;
    private long nrOfPackets;
    private PacketMatcher[] matchers;
    private long packetNr;

    public GenericPacketReader(String file) throws IOException {
        this(file, null, new PacketMatcher[0]);
    }

    public GenericPacketReader(String file, CommandLineParser parser, PacketMatcher ... matchers) throws IOException {
        this.file = file;
        this.matchers = matchers;
        if (parser != null) {
            this.parseOptions(parser);
        }
        try {
            this.session = ProfilingFactory.createSession((String)file);
            this.reader = this.session.getReader();
        }
        catch (Exception e) {
            this.tmpDir = new File(System.getProperty("java.io.tmpdir", "."));
            this.tmpDir = new File(this.tmpDir, "sapjvm_tmp_profiling-" + VmInfo.getStateInfo().getPid());
            GenericPacketReader.delete(this.tmpDir);
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        GenericPacketReader.this.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }));
            this.tmpDir.mkdir();
            this.controller = ControllerFactory.create(file, this.tmpDir.toString(), this.tmpDir);
            ProgressReporter reporter = new ProgressReporter();
            this.controller.process(reporter);
            reporter.finish();
            this.session = this.controller.getProfilingSession();
            this.reader = this.session.getResourceManager().getEventReader();
        }
        while (this.reader.nextPacket() != null) {
            ++this.nrOfPackets;
        }
        this.reset();
    }

    public ProfilingSession getSession() {
        return this.session;
    }

    public ProfilingPacket nextPacket() throws IOException {
        ProfilingPacket packet;
        boolean isMatch;
        block0: do {
            packet = this.reader.nextPacket();
            isMatch = true;
            if (packet == null) {
                return null;
            }
            ++this.packetNr;
            for (PacketMatcher matcher : this.matchers) {
                if (matcher.isMatch(packet, this.packetNr, this.nrOfPackets)) continue;
                isMatch = false;
                continue block0;
            }
        } while (!isMatch);
        return packet;
    }

    public long getPacketNr() {
        return this.packetNr;
    }

    public ProfilingReader getReader() {
        return this.reader;
    }

    public ProfilingSession reset() throws IOException {
        if (this.controller == null) {
            this.session = ProfilingFactory.createSession((String)this.file);
            this.reader = this.session.getReader();
        } else {
            this.reader = this.controller.getProfilingSession().getResourceManager().getEventReader();
        }
        this.packetNr = 0L;
        return this.session;
    }

    @Override
    public void close() throws IOException {
        if (this.controller != null) {
            this.controller.close(true);
            this.controller = null;
            GenericPacketReader.delete(this.tmpDir);
        }
    }

    public static void delete(File fileOrDir) throws IOException {
        if (fileOrDir.isDirectory()) {
            for (File child : fileOrDir.listFiles()) {
                GenericPacketReader.delete(child);
            }
        }
        fileOrDir.delete();
    }

    public static void printReaderOptionHelp() {
        System.out.println("-f, --first=<nr of packets>:");
        System.out.println("            Prints only the first <nr of packets> packets.");
        System.out.println("-l, --last=<nr of packets>:");
        System.out.println("            Prints only the last <nr of packets> packets.");
        System.out.println("-r, --range=<start packet nr>-<end packet nr>:");
        System.out.println("            Prints the packets in the range.");
    }

    public static CommandLineParser.Option[] addOptions(CommandLineParser.Option[] options) {
        CommandLineParser.Option[] result = new CommandLineParser.Option[options.length + 3];
        System.arraycopy(options, 0, result, 0, options.length);
        result[options.length] = new CommandLineParser.OptionalEqualsOption("f", "first");
        result[options.length + 1] = new CommandLineParser.OptionalEqualsOption("l", "last");
        result[options.length + 2] = new CommandLineParser.OptionalEqualsOption("r", "range");
        return result;
    }

    private void parseOptions(CommandLineParser parser) {
        ArrayList<PacketMatcher> toAdd = new ArrayList<PacketMatcher>();
        if (parser.isOptionSet("first")) {
            toAdd.add(new FirstNPacketsMatcher(Integer.parseInt(parser.getValue("first"))));
        }
        if (parser.isOptionSet("last")) {
            toAdd.add(new LastNPacketsMatcher(Integer.parseInt(parser.getValue("last"))));
        }
        if (parser.isOptionSet("range")) {
            long to;
            long from;
            String range = parser.getValue("range");
            if (range.startsWith("-")) {
                from = 1L;
                to = Integer.parseInt(range.substring(1));
            } else if (range.endsWith("-")) {
                from = Integer.parseInt(range.substring(0, range.length() - 1));
                to = Long.MAX_VALUE;
            } else {
                String[] parts = range.split("-");
                from = Integer.parseInt(parts[0]);
                to = Integer.parseInt(parts[1]);
            }
            toAdd.add(new FromToPacketMatcher(from, to));
        }
        if (toAdd.size() > 1) {
            this.addPacketMatcher(new OrPacketMatcher(toAdd.toArray(new PacketMatcher[toAdd.size()])));
        } else if (toAdd.size() > 0) {
            this.addPacketMatcher((PacketMatcher)toAdd.get(0));
        }
    }

    public void addPacketMatcher(PacketMatcher matcher) {
        PacketMatcher[] newMatchers = new PacketMatcher[this.matchers.length + 1];
        System.arraycopy(this.matchers, 0, newMatchers, 0, this.matchers.length);
        newMatchers[this.matchers.length] = matcher;
        this.matchers = newMatchers;
    }
}

