/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools;

import com.sap.jvm.internal.util.cmdline.CommandLineParser;
import com.sap.jvm.monitor.vm.VmInfo;
import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.ControllerFactory;
import com.sap.jvm.profiling.controller.FileController;
import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.event.SystemInfo;
import com.sap.jvm.profiling.impl.method.event.MethodParameterDefinitionEventImpl;
import com.sap.jvm.profiling.io.event.FileCloseEvent;
import com.sap.jvm.profiling.io.event.FileNotFoundEvent;
import com.sap.jvm.profiling.io.event.FileOpenEvent;
import com.sap.jvm.profiling.io.event.FileReadEvent;
import com.sap.jvm.profiling.io.event.FileWriteEvent;
import com.sap.jvm.profiling.io.response.DisableIOTraceResponse;
import com.sap.jvm.profiling.io.response.EnableIOTraceResponse;
import com.sap.jvm.profiling.jit.event.JitEvent;
import com.sap.jvm.profiling.jit.response.DisableJitEventsResponse;
import com.sap.jvm.profiling.jit.response.EnableJitEventsResponse;
import com.sap.jvm.profiling.memory.event.AllocationEvent;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.memory.response.DisableAllocationMptTraceResponse;
import com.sap.jvm.profiling.memory.response.DisableAllocationTraceResponse;
import com.sap.jvm.profiling.memory.response.DisableGcStatisticResponse;
import com.sap.jvm.profiling.memory.response.EnableAdaptiveAllocationMptTraceResponse;
import com.sap.jvm.profiling.memory.response.EnableAdaptiveAllocationTraceResponse;
import com.sap.jvm.profiling.memory.response.EnableAllocationMptTraceResponse;
import com.sap.jvm.profiling.memory.response.EnableAllocationTraceResponse;
import com.sap.jvm.profiling.memory.response.EnableGcStatisticResponse;
import com.sap.jvm.profiling.method.event.MethodParameterApplyErrorEvent;
import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.method.event.MethodParameterExitEvent;
import com.sap.jvm.profiling.method.event.MethodParameterMethodToTraceEvent;
import com.sap.jvm.profiling.method.event.MethodParameterNearMissEvent;
import com.sap.jvm.profiling.method.event.TimeBasedSamplingEvent;
import com.sap.jvm.profiling.method.event.TimeBasedSamplingInitialCpuTimesEvent;
import com.sap.jvm.profiling.method.response.DisableMethodParameterTraceResponse;
import com.sap.jvm.profiling.method.response.DisableTimeBasedSamplingMptResponse;
import com.sap.jvm.profiling.method.response.DisableTimeBasedSamplingResponse;
import com.sap.jvm.profiling.method.response.EnableMethodParameterTraceResponse;
import com.sap.jvm.profiling.method.response.EnableTimeBasedSamplingMptResponse;
import com.sap.jvm.profiling.method.response.EnableTimeBasedSamplingResponse;
import com.sap.jvm.profiling.monitoring.event.MonitoringBoardDiffEvent;
import com.sap.jvm.profiling.monitoring.event.MonitoringBoardEvent;
import com.sap.jvm.profiling.monitoring.event.MonitoringEventHandler;
import com.sap.jvm.profiling.monitoring.response.DisableMonitoringBoardTraceResponse;
import com.sap.jvm.profiling.monitoring.response.EnableMonitoringBoardTraceResponse;
import com.sap.jvm.profiling.net.event.SocketBindEvent;
import com.sap.jvm.profiling.net.event.SocketCloseEvent;
import com.sap.jvm.profiling.net.event.SocketConnectEvent;
import com.sap.jvm.profiling.net.event.SocketOpenEvent;
import com.sap.jvm.profiling.net.event.SocketTransferEvent;
import com.sap.jvm.profiling.net.response.DisableNetworkTraceResponse;
import com.sap.jvm.profiling.net.response.EnableNetworkTraceResponse;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.sync.event.MonitorNotifyAllEvent;
import com.sap.jvm.profiling.sync.event.MonitorNotifyEvent;
import com.sap.jvm.profiling.sync.event.MonitorSlowEnterEvent;
import com.sap.jvm.profiling.sync.event.MonitorWaitEnterEvent;
import com.sap.jvm.profiling.sync.event.MonitorWaitExitEvent;
import com.sap.jvm.profiling.sync.event.SyncEnterEvent;
import com.sap.jvm.profiling.sync.event.SyncEnteredEvent;
import com.sap.jvm.profiling.sync.event.SyncExitEvent;
import com.sap.jvm.profiling.sync.response.DisableMonitorSlowEnterTraceResponse;
import com.sap.jvm.profiling.sync.response.DisableSynchronizationTraceResponse;
import com.sap.jvm.profiling.sync.response.EnableMonitorSlowEnterTraceResponse;
import com.sap.jvm.profiling.sync.response.EnableSynchronizationTraceResponse;
import com.sap.jvm.profiling.thread.event.ThreadDumpsEvent;
import com.sap.jvm.profiling.thread.event.ThreadDumpsLastEvent;
import com.sap.jvm.profiling.thread.response.DisableThreadDumpsResponse;
import com.sap.jvm.profiling.thread.response.EnableThreadDumpsResponse;
import com.sap.jvm.profiling.tools.GenericPacketReader;
import com.sap.jvm.profiling.tools.PacketMatcher;
import com.sap.jvm.profiling.tools.ToolsProfilingPrintStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PacketDumper {
    private static FileController controller;
    private static File tmpDir;
    private static byte[] lastBoard;
    private static byte[] secondLastBoard;
    private static boolean printFullThreadDumpContent;

    public static void main(String[] args) throws Exception {
        CommandLineParser.OptionalEqualsOption packetGroupOption = new CommandLineParser.OptionalEqualsOption("g", "groups");
        CommandLineParser.OptionalSwitch showPacketGroupsOption = new CommandLineParser.OptionalSwitch(null, "show-groups");
        CommandLineParser.OptionalEqualsOption stackTraceOption = new CommandLineParser.OptionalEqualsOption("s", "stack");
        CommandLineParser.OptionalSwitch systemInfoOption = new CommandLineParser.OptionalSwitch("i", "system-info");
        CommandLineParser.OptionalSwitch jrubyOption = new CommandLineParser.OptionalSwitch("r", "jruby");
        CommandLineParser.OptionalSwitch hostnameInfoOption = new CommandLineParser.OptionalSwitch("h", "host-names");
        CommandLineParser.OptionalSwitch serviceNameInfoOption = new CommandLineParser.OptionalSwitch("v", "service-names");
        CommandLineParser.OptionalEqualsOption writeSnapshotOption = new CommandLineParser.OptionalEqualsOption("w", "write-snapshot");
        CommandLineParser.OptionalSwitch writePacketNrOption = new CommandLineParser.OptionalSwitch("n", "write-packet-nr");
        CommandLineParser.OptionalEqualsOption filterPacketbyContent = new CommandLineParser.OptionalEqualsOption("c", "filter-by-packet-content");
        CommandLineParser.OptionalSwitch methodsLikePrintCompilation = new CommandLineParser.OptionalSwitch(null, "use-print-compilation-format");
        CommandLineParser.OptionalSwitch fullMonitoringBoardInfo = new CommandLineParser.OptionalSwitch("m", "monitoring-board");
        CommandLineParser.OptionalSwitch fullThreadDumps = new CommandLineParser.OptionalSwitch("t", "thread-dumps");
        CommandLineParser.OptionalSwitch displayHelp = new CommandLineParser.OptionalSwitch("?", "help");
        CommandLineParser.Option[] options = new CommandLineParser.Option[]{packetGroupOption, showPacketGroupsOption, stackTraceOption, systemInfoOption, hostnameInfoOption, serviceNameInfoOption, writeSnapshotOption, jrubyOption, writePacketNrOption, filterPacketbyContent, methodsLikePrintCompilation, fullMonitoringBoardInfo, fullThreadDumps, displayHelp};
        options = GenericPacketReader.addOptions(options);
        CommandLineParser parser = new CommandLineParser(args, options, false);
        String[] unparsedStrings = parser.getRemainingArguments();
        if (parser.isOptionSet(showPacketGroupsOption)) {
            PacketDumper.printSupportedPacketGroups();
        }
        if (unparsedStrings.length == 0 || parser.isOptionSet(displayHelp)) {
            System.out.println("Dumps all event packets in the given profiling file.");
            System.out.println();
            System.out.println("Syntax: dumppackets [<options> ...] <prf-file>");
            System.out.println();
            System.out.println("The following options are supported: ");
            System.out.println("-g, --groups=<packet group>[,<packet group>]... :");
            System.out.print("            If given we only dump packets which match one");
            System.out.println(" of the packet groups. Multiple groups can be specified, ");
            System.out.println("            separated by commas.");
            System.out.println("--show-groups:");
            System.out.println("            Prints a list of all supported groups and exits");
            System.out.println("-s, --stack=<full|none|nr of frames>:");
            System.out.print("            If 'full' is given, we print full stack traces for ");
            System.out.println("packets containing stacks. If 'none' is given, we print only");
            System.out.print("            the stack trace id. If a number is given, we print ");
            System.out.println("at most that number of frames.");
            System.out.println("-i, --system-info:");
            System.out.println("            Dumps the system info packet, too.");
            System.out.println("-m, --monitoring-board:");
            System.out.println("            Dumps monitoring board events with full content");
            System.out.println("-t, --thread-dumps:");
            System.out.println("            Dumps thread dumps with full content");
            System.out.println("-r, --jruby:");
            System.out.println("            Include JRuby information");
            System.out.println("-h, --host-names:");
            System.out.println("            Dumps the IP address to host name registry, too.");
            System.out.println("-v, --service-names:");
            System.out.print("            Dumps the network service names and their ports/");
            System.out.println("protocols, too.");
            System.out.println("-w, --write-snapshot=<filename>:");
            System.out.println("            Writes the file as a snapshot file.");
            System.out.println("-n, --write-packet-nr:");
            System.out.println("            Writes the packet number in front of every packet.");
            System.out.println("-c, --filter-by-packet-content:");
            System.out.println("            Only displays packets which content contain the given regexp.");
            System.out.println("--use-print-compilation-format:");
            System.out.println("            Displays methods in the same format as -XX:+PrintCompilation");
            GenericPacketReader.printReaderOptionHelp();
            System.out.println("-?, --help:");
            System.out.println("            Print this help message and exit.");
            System.exit(0);
        }
        PacketGroup[] packetGroups = null;
        if (parser.isOptionSet(packetGroupOption)) {
            String[] selected = parser.getValue(packetGroupOption).split(",");
            packetGroups = new PacketGroup[selected.length];
            if (selected.length == 0) {
                System.out.println("You must specify at least one group");
                System.exit(1);
            }
            int index = 0;
            for (PacketGroup packetGroup : PacketDumper.getPacketGroups()) {
                for (int i = 0; i < selected.length; ++i) {
                    if (!packetGroup.getFlag().equals(selected[i])) continue;
                    packetGroups[index] = packetGroup;
                    ++index;
                    selected[i] = null;
                }
            }
            if (index != packetGroups.length) {
                System.out.println("The following packet groups are not known:");
                for (String string : selected) {
                    if (string == null) continue;
                    System.out.println(string);
                }
                PacketDumper.printSupportedPacketGroups();
            }
        }
        if (unparsedStrings.length > 1) {
            System.err.println("Too many arguments");
            System.exit(1);
        }
        int maxFrames = 0;
        if (parser.isOptionSet(stackTraceOption)) {
            String value = parser.getValue(stackTraceOption);
            if ("full".equals(value)) {
                maxFrames = 0x7FFFFFFE;
            } else if (!"none".equals(value)) {
                maxFrames = Integer.parseInt(value);
            }
        }
        boolean dumpSystemInfo = parser.isOptionSet(systemInfoOption);
        boolean dumpHostnames = parser.isOptionSet(hostnameInfoOption);
        boolean dumpServiceNames = parser.isOptionSet(serviceNameInfoOption);
        boolean supportJRuby = parser.isOptionSet(jrubyOption);
        boolean bl = parser.isOptionSet(writePacketNrOption);
        Matcher contentMatcher = null;
        if (parser.isOptionSet(filterPacketbyContent)) {
            contentMatcher = Pattern.compile(parser.getValue(filterPacketbyContent)).matcher("");
        }
        try (GenericPacketReader reader = new GenericPacketReader(unparsedStrings[0], parser, new PacketMatcher[0]);){
            PacketDumper.dumpPackets(reader, packetGroups, maxFrames, dumpSystemInfo, supportJRuby, dumpHostnames, dumpServiceNames, bl, contentMatcher, parser.isOptionSet(methodsLikePrintCompilation), parser.isOptionSet(fullMonitoringBoardInfo), parser.isOptionSet(fullThreadDumps));
            String snapshotFileName = parser.getValue(writeSnapshotOption);
            if (snapshotFileName != null) {
                System.out.println("Writing snapshot file " + snapshotFileName);
                tmpDir = new File(System.getProperty("java.io.tmpdir", "."));
                tmpDir = new File(tmpDir, "sapjvm_tmp_profiling-" + VmInfo.getStateInfo().getPid());
                GenericPacketReader.delete(tmpDir);
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (controller != null) {
                                controller.close(true);
                                controller = null;
                                GenericPacketReader.delete(tmpDir);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }));
                tmpDir.mkdir();
                controller = ControllerFactory.create(unparsedStrings[0], tmpDir.toString(), tmpDir);
                ProgressReporter reporter = new ProgressReporter();
                controller.process(reporter);
                controller.getModelController().write(snapshotFileName, reporter);
                reporter.finish();
                controller.close(true);
            }
        }
    }

    private static void printSupportedPacketGroups() {
        System.out.println("The following groups are available: ");
        for (PacketGroup group : PacketDumper.getPacketGroups()) {
            System.out.println(group.getFlag() + ": " + group.getDescription());
        }
        System.exit(0);
    }

    private static void print(ProfilingPacket packet, ToolsProfilingPrintStream stream) {
        if (packet instanceof MonitoringBoardEvent) {
            MonitoringBoardEvent event = (MonitoringBoardEvent)packet;
            event.print((ProfilingPrintStream)stream, lastBoard != null);
        } else if (packet instanceof MonitoringBoardDiffEvent) {
            MonitoringBoardDiffEvent event = (MonitoringBoardDiffEvent)packet;
            if (secondLastBoard != null) {
                event.print((ProfilingPrintStream)stream, secondLastBoard);
            } else {
                event.print((ProfilingPrintStream)stream);
            }
        } else if (packet instanceof ThreadDumpsEvent) {
            ThreadDumpsEvent event = (ThreadDumpsEvent)packet;
            event.print((ProfilingPrintStream)stream, printFullThreadDumpContent);
        } else {
            packet.print((ProfilingPrintStream)stream);
        }
    }

    private static void dumpPackets(GenericPacketReader reader, PacketGroup[] groups, int maxFrames, boolean dumpSystemInfo, boolean supportJRuby, boolean dumpHostnameInfo, boolean dumpServiceNameInfo, boolean writePacketNr, Matcher contentMatcher, boolean methodsInPrintCompilationFormat, boolean monitoringBoardInfo, boolean fullThreadDumps) throws IOException {
        ProfilingPacket packet;
        SystemInfo info;
        ProfilingSession session = reader.getSession();
        if (monitoringBoardInfo) {
            reader.getReader().registerMonitoringEventHandler(new MonitoringEventHandler(){

                public void handle(MonitoringBoardDiffEvent event, byte[] board) {
                    PacketDumper.access$202(lastBoard);
                    PacketDumper.access$302((byte[])board.clone());
                }

                public void handle(MonitoringBoardEvent event) {
                    PacketDumper.access$202(lastBoard);
                    PacketDumper.access$302((byte[])event.getContent().clone());
                }

                public void handle(DisableMonitoringBoardTraceResponse response) {
                }

                public void handle(EnableMonitoringBoardTraceResponse response) {
                }
            });
        }
        printFullThreadDumpContent = fullThreadDumps;
        IdentityHashMap matchCache = new IdentityHashMap();
        if (dumpSystemInfo && (info = session.getSystemInfo()) != null) {
            info.print(System.out);
        }
        ToolsProfilingPrintStream stream = new ToolsProfilingPrintStream(System.out, 4, maxFrames, session, supportJRuby);
        if (methodsInPrintCompilationFormat) {
            stream.usePrintCompilationFormatForMethods();
        }
        while ((packet = reader.nextPacket()) != null) {
            if (!PacketDumper.isMatch(packet, groups, matchCache)) continue;
            if (contentMatcher != null) {
                BufferedWriter oldWriter = stream.getWriter();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                BufferedWriter tmpWriter = new BufferedWriter(new OutputStreamWriter(bos));
                stream.setWriter(tmpWriter);
                PacketDumper.print(packet, stream);
                stream.setWriter(oldWriter);
                tmpWriter.close();
                contentMatcher.reset(bos.toString());
                if (!contentMatcher.find()) continue;
            }
            if (writePacketNr) {
                stream.resetIndent();
                stream.println("Packet Nr. " + reader.getPacketNr());
            }
            PacketDumper.print(packet, stream);
        }
        stream.close();
        if (dumpHostnameInfo) {
            session.getHostNameManager().print(System.out);
        }
        if (dumpServiceNameInfo) {
            session.getNetworkServiceNameManager().print(System.out);
        }
    }

    private static boolean isMatch(ProfilingPacket packet, PacketGroup[] groups, Map<Class<?>, Boolean> matchCache) {
        if (groups == null) {
            return true;
        }
        Boolean isMatch = matchCache.get(packet.getClass());
        if (isMatch == null) {
            PacketGroup group;
            PacketGroup[] packetGroupArray = groups;
            int n = packetGroupArray.length;
            for (int i = 0; i < n && !(isMatch = Boolean.valueOf((group = packetGroupArray[i]).shouldTrace(packet))).booleanValue(); ++i) {
            }
            matchCache.put(packet.getClass(), isMatch);
        }
        return isMatch;
    }

    private static PacketGroup[] getPacketGroups() {
        return new PacketGroup[]{new PacketGroup("mpt-basic", "The basic MPT events (entry, exit, enable, disabled and definition)"){

            @Override
            public boolean shouldTrace(Object o) {
                return o instanceof MethodParameterEntryEvent || o instanceof MethodParameterExitEvent || o instanceof EnableMethodParameterTraceResponse || o instanceof EnableAllocationMptTraceResponse || o instanceof EnableTimeBasedSamplingMptResponse || o instanceof DisableMethodParameterTraceResponse || o instanceof DisableAllocationMptTraceResponse || o instanceof DisableTimeBasedSamplingMptResponse || o instanceof MethodParameterDefinitionEventImpl;
            }
        }, new PacketGroup("mpt-enabling", "The MPT enabling and disabling commands"){

            @Override
            public boolean shouldTrace(Object o) {
                return o instanceof EnableMethodParameterTraceResponse || o instanceof EnableAllocationMptTraceResponse || o instanceof EnableTimeBasedSamplingMptResponse || o instanceof DisableMethodParameterTraceResponse || o instanceof DisableAllocationMptTraceResponse || o instanceof DisableTimeBasedSamplingMptResponse || o instanceof MethodParameterDefinitionEventImpl;
            }
        }, new PacketGroup("mpt-errors", "The MPT errors"){

            @Override
            public boolean shouldTrace(Object o) {
                return o instanceof MethodParameterApplyErrorEvent;
            }
        }, new PacketGroup("mpt-misses", "The MPT near misses"){

            @Override
            public boolean shouldTrace(Object o) {
                return o instanceof MethodParameterNearMissEvent;
            }
        }, new PacketGroup("mpt-methods", "The MPT methods to trace"){

            @Override
            public boolean shouldTrace(Object o) {
                return o instanceof MethodParameterMethodToTraceEvent;
            }
        }, new PacketGroup("network", "The network i/o trace related events"){

            @Override
            public boolean shouldTrace(Object o) {
                return o instanceof EnableNetworkTraceResponse || o instanceof DisableNetworkTraceResponse || o instanceof SocketOpenEvent || o instanceof SocketBindEvent || o instanceof SocketConnectEvent || o instanceof SocketTransferEvent || o instanceof SocketCloseEvent;
            }
        }, new PacketGroup("file", "The file i/o trace related events"){

            @Override
            public boolean shouldTrace(Object o) {
                return o instanceof EnableIOTraceResponse || o instanceof DisableIOTraceResponse || o instanceof FileOpenEvent || o instanceof FileNotFoundEvent || o instanceof FileReadEvent || o instanceof FileWriteEvent || o instanceof FileCloseEvent;
            }
        }, new PacketGroup("sync", "The synchronization trace related events"){

            @Override
            public boolean shouldTrace(Object o) {
                return o instanceof EnableSynchronizationTraceResponse || o instanceof EnableMonitorSlowEnterTraceResponse || o instanceof DisableSynchronizationTraceResponse || o instanceof DisableMonitorSlowEnterTraceResponse || o instanceof SyncEnterEvent || o instanceof SyncEnteredEvent || o instanceof SyncExitEvent || o instanceof MonitorNotifyEvent || o instanceof MonitorNotifyAllEvent || o instanceof MonitorWaitEnterEvent || o instanceof MonitorWaitExitEvent || o instanceof MonitorSlowEnterEvent;
            }
        }, new PacketGroup("alloc", "The allocation trace related events"){

            @Override
            public boolean shouldTrace(Object o) {
                return o instanceof EnableAllocationTraceResponse || o instanceof EnableAllocationMptTraceResponse || o instanceof EnableAdaptiveAllocationTraceResponse || o instanceof EnableAdaptiveAllocationMptTraceResponse || o instanceof DisableAllocationTraceResponse || o instanceof DisableAllocationMptTraceResponse || o instanceof AllocationEvent;
            }
        }, new PacketGroup("perf", "The performance hotspot trace related events"){

            @Override
            public boolean shouldTrace(Object o) {
                return o instanceof EnableTimeBasedSamplingResponse || o instanceof EnableTimeBasedSamplingMptResponse || o instanceof DisableTimeBasedSamplingResponse || o instanceof DisableTimeBasedSamplingMptResponse || o instanceof TimeBasedSamplingEvent || o instanceof TimeBasedSamplingInitialCpuTimesEvent;
            }
        }, new PacketGroup("gc", "The GC trace related events"){

            @Override
            public boolean shouldTrace(Object o) {
                return o instanceof EnableGcStatisticResponse || o instanceof DisableGcStatisticResponse || o instanceof GcStatistic;
            }
        }, new PacketGroup("jit", "The JIT events"){

            @Override
            public boolean shouldTrace(Object o) {
                return o instanceof EnableJitEventsResponse || o instanceof DisableJitEventsResponse || o instanceof JitEvent;
            }
        }, new PacketGroup("threaddump", "The thread dump trace related events"){

            @Override
            public boolean shouldTrace(Object o) {
                return o instanceof EnableThreadDumpsResponse || o instanceof DisableThreadDumpsResponse || o instanceof ThreadDumpsLastEvent || o instanceof ThreadDumpsEvent;
            }
        }};
    }

    static /* synthetic */ byte[] access$202(byte[] x0) {
        secondLastBoard = x0;
        return x0;
    }

    static /* synthetic */ byte[] access$302(byte[] x0) {
        lastBoard = x0;
        return x0;
    }

    private static abstract class PacketGroup {
        private final String flag;
        private final String description;

        protected PacketGroup(String flag, String description) {
            this.flag = flag;
            this.description = description;
        }

        public final String getFlag() {
            return this.flag;
        }

        public final String getDescription() {
            return this.description;
        }

        public abstract boolean shouldTrace(Object var1);
    }
}

