/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.DetailedProfilingPrintStream;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.util.StackJRubyfier;
import java.io.PrintStream;

public class ToolsProfilingPrintStream
extends DetailedProfilingPrintStream {
    private final boolean supportJRuby;
    private final StackFrames frames;
    private final StackFrames rubyFrames;
    private final StackJRubyfier rubyfier;

    public ToolsProfilingPrintStream(PrintStream stream, int indent, int maxFrames, ProfilingSession session, boolean supportJRuby) {
        super(stream, indent, maxFrames, session);
        this.supportJRuby = supportJRuby;
        this.frames = session.getStackTraceManager().getStackFramesObject(true);
        this.rubyFrames = session.getStackTraceManager().getStackFramesObject(true);
        this.rubyfier = new StackJRubyfier(this.frames, this.rubyFrames, session);
    }

    public void resetIndent() {
        this.setIndent(0);
    }

    protected void printStackTrace(int stackTraceIndex, int pos) {
        super.printStackTrace(stackTraceIndex, pos);
        if (!this.supportJRuby) {
            return;
        }
        this.frames.fillIn(stackTraceIndex);
        this.rubyfier.rubify(0, false, false);
        this.println();
        this.println("JRuby:");
        this.println();
        if (this.rubyFrames.getNrOfFrames() > 0) {
            int oldIndent = this.getIndent();
            int nrOfFrames = this.rubyFrames.getNrOfFrames();
            this.setIndent(pos);
            for (int i = 0; i < nrOfFrames; ++i) {
                this.println();
                this.print(this.rubyFrames.getMethodLocation(nrOfFrames - i - 1).toString());
            }
            this.setIndent(oldIndent);
        }
    }
}

