/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.gchistory;

import com.sap.jvm.internal.util.cmdline.CommandLineParser;
import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.SimpleProfilingPrintStream;
import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.memory.event.GcStatisticTraceLevel;
import com.sap.jvm.profiling.tools.GenericPacketReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class GCHistoryDumper {
    private static final CommandLineParser.Option helpOption = new CommandLineParser.OptionalSwitch("h", "help");
    private static final CommandLineParser.Option questionOption = new CommandLineParser.OptionalSwitch("?", "?");
    private static final CommandLineParser.Option firstOption = new CommandLineParser.OptionalEqualsOption("f", "first");
    private static final CommandLineParser.Option lastOption = new CommandLineParser.OptionalEqualsOption("l", "last");
    private static final CommandLineParser.Option sinceOption = new CommandLineParser.OptionalEqualsOption("s", "since");
    private static final CommandLineParser.Option traceOption = new CommandLineParser.OptionalEqualsOption("t", "trace");
    private static final CommandLineParser.Option untilOption = new CommandLineParser.OptionalEqualsOption("u", "until");
    private static final CommandLineParser.Option[] options = new CommandLineParser.Option[]{helpOption, questionOption, firstOption, lastOption, sinceOption, traceOption, untilOption};
    private static GCPrintStream stream;

    public static void main(String[] args) throws Exception {
        try {
            CommandLineParser parser = new CommandLineParser(args, options, false);
            String[] unparsedStrings = parser.getRemainingArguments();
            if (parser.isOptionSet(helpOption) || parser.isOptionSet(questionOption)) {
                GCHistoryDumper.printUsage();
                return;
            }
            GCHistoryDumper.checkRemainingArguments(unparsedStrings);
            GCHistoryDumper.checkValidOptionsCombinations(parser);
            long first = Math.max(0L, GCHistoryDumper.parseLongOption(parser, firstOption));
            long last = Math.max(0L, GCHistoryDumper.parseLongOption(parser, lastOption));
            long since = Math.max(0L, GCHistoryDumper.parseDateOption(parser, sinceOption));
            long until = Math.max(0L, GCHistoryDumper.parseDateOption(parser, untilOption));
            if (parser.isOptionSet(traceOption)) {
                int level = (int)GCHistoryDumper.parseLongOption(parser, traceOption);
                GcStatisticTraceLevel.setCurrentLevel((GcStatisticTraceLevel)GcStatisticTraceLevel.get((int)level));
            } else {
                GcStatisticTraceLevel.setCurrentLevel((GcStatisticTraceLevel)GcStatisticTraceLevel.SHORT);
            }
            GCHistoryDumper.checkOptions(parser, first, last, since, until);
            try {
                GCHistoryDumper.dumpPackets(unparsedStrings[0], first, last, since, until);
            }
            catch (IOException e) {
                System.err.println("Error while reading file: " + e.getMessage());
            }
        }
        catch (CommandLineParser.UnknownOptionException e) {
            System.err.println("Unknown option '" + e.getMessage() + "'.");
            GCHistoryDumper.printUsage();
            System.exit(1);
        }
        catch (CommandLineParser.IllegalOptionFormatException e) {
            System.err.println("Format of option '" + e.getMessage() + "' illegal.");
            GCHistoryDumper.printUsage();
            System.exit(1);
        }
        catch (CommandLineParser.MissingOptionValueException e) {
            System.err.println("Value of option '" + e.getMessage() + "' missing.");
            GCHistoryDumper.printUsage();
            System.exit(1);
        }
    }

    private static void printUsage() {
        System.out.println("Dumps all event packets of the given GC history file.");
        System.out.println();
        System.out.println("Syntax: displaygchistory [<options> ...] <GC-history-file>");
        System.out.println();
        System.out.println("The following options are supported: ");
        System.out.println("-?, --?");
        System.out.println("            Print usage information (this message).");
        System.out.println("-f, --first=<number of GCs>");
        System.out.println("            Prints only the first <number of GCs> garbage collections.");
        System.out.println("-h, --help");
        System.out.println("            Print usage information (this message).");
        System.out.println("-l, --last=<number of GCs>");
        System.out.println("            Prints only the last <number of GCs> garbage collections.");
        System.out.println("-s, --since=YYYY/MM/DD[-hh:mm:ss]");
        System.out.println("            Prints only the garbage collections that occurred after the given date.");
        System.out.println("            The time is optional. Example: '2009/10/14' or '2009/10/14-10:11:12'");
        System.out.println("            (YYYY year, MM month, DD day, hh hour, mm minutes, ss seconds)");
        System.out.println("-t, --trace=<GC detail level>");
        System.out.println("            Specifies the level of detail used for output of garbage collections.");
        System.out.println("            Available levels are 0-2 (with increasing level of detail).");
        System.out.println("-u, --until=YYYY/MM/DD[-hh:mm:ss]");
        System.out.println("            Prints only the garbage collections that occurred before the given date.");
        System.out.println("            The time is optional. Example: '2009/10/14' or '2009/10/14-10:11:12'");
        System.out.println("            (YYYY year, MM month, DD day, hh hour, mm minutes, ss seconds)");
    }

    private static void checkRemainingArguments(String[] args) {
        if (args.length == 0 || args.length > 1) {
            if (args.length > 1) {
                System.err.println("Too many arguments");
            }
            GCHistoryDumper.printUsage();
            System.exit(1);
        }
        assert (args.length == 1);
        File file = new File(args[0]);
        if (!file.exists() || file.isDirectory()) {
            System.err.println("File not found: " + args[0]);
            GCHistoryDumper.printUsage();
            System.exit(1);
        }
    }

    private static void checkValidOptionsCombinations(CommandLineParser parser) {
        boolean conflict = false;
        if (parser.isOptionSet(firstOption) && parser.isOptionSet(lastOption)) {
            System.err.println("Conflicting options: --first=<number of GCs> and --last=<number of GCs>");
            conflict = true;
        } else if (parser.isOptionSet(firstOption) && parser.isOptionSet(sinceOption)) {
            System.err.println("Conflicting options: --first=<number of GCs> and --since=YYYY/MM/DD[-hh:mm:ss]");
            conflict = true;
        } else if (parser.isOptionSet(firstOption) && parser.isOptionSet(untilOption)) {
            System.err.println("Conflicting options: --first=<number of GCs> and --until=YYYY/MM/DD[-hh:mm:ss]");
            conflict = true;
        } else if (parser.isOptionSet(lastOption) && parser.isOptionSet(sinceOption)) {
            System.err.println("Conflicting options: --last=<number of GCs> and --since=YYYY/MM/DD[-hh:mm:ss]");
            conflict = true;
        } else if (parser.isOptionSet(lastOption) && parser.isOptionSet(untilOption)) {
            System.err.println("Conflicting options: --last=<number of GCs> and --until=YYYY/MM/DD[-hh:mm:ss]");
            conflict = true;
        }
        if (conflict) {
            GCHistoryDumper.printUsage();
            System.exit(1);
        }
    }

    private static void checkOptions(CommandLineParser parser, long first, long last, long since, long until) {
        if (since != 0L && until != 0L && since > until) {
            System.err.println("Date specified for --since (" + parser.getValue(sinceOption) + ") must be smaller than the date specified for --until (" + parser.getValue(untilOption) + ").");
            GCHistoryDumper.printUsage();
            System.exit(1);
        }
    }

    private static long parseLongOption(CommandLineParser parser, CommandLineParser.Option option) throws CommandLineParser.IllegalOptionFormatException {
        if (parser.isOptionSet(option)) {
            try {
                return Long.parseLong(parser.getValue(option));
            }
            catch (NumberFormatException e) {
                throw new CommandLineParser.IllegalOptionFormatException(option.getLongName());
            }
        }
        return 0L;
    }

    private static long parseDateOption(CommandLineParser parser, CommandLineParser.Option option) throws CommandLineParser.IllegalOptionFormatException {
        if (parser.isOptionSet(option)) {
            SimpleDateFormat longFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
            try {
                return longFormat.parse(parser.getValue(option)).getTime();
            }
            catch (ParseException e) {
                SimpleDateFormat shortFormat = new SimpleDateFormat("yyyy/MM/dd");
                try {
                    return shortFormat.parse(parser.getValue(option)).getTime();
                }
                catch (ParseException e1) {
                    throw new CommandLineParser.IllegalOptionFormatException(option.getLongName());
                }
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpPackets(String fileName, long first, long last, long since, long until) throws IOException {
        GenericPacketReader reader = new GenericPacketReader(fileName);
        stream = new GCPrintStream(System.out);
        Matcher m = GCHistoryDumper.createMatcher(0L, first, last, since, until);
        try {
            if (first == 0L && last == 0L) {
                ProfilingPacket packet;
                assert (!(m instanceof TimeBasedMatcher));
                while ((packet = reader.nextPacket()) != null) {
                    if (!m.isMatch(packet)) continue;
                    packet.print((ProfilingPrintStream)stream);
                }
            } else {
                ProfilingPacket packet;
                long nrOfPackets = 0L;
                while ((packet = reader.nextPacket()) != null) {
                    if (!m.isMatch(packet)) continue;
                    ++nrOfPackets;
                }
                reader.reset();
                m = GCHistoryDumper.createMatcher(nrOfPackets, first, last, since, until);
                while ((packet = reader.nextPacket()) != null) {
                    if (!m.isMatch(packet)) continue;
                    packet.print((ProfilingPrintStream)stream);
                }
            }
        }
        finally {
            stream.close();
            reader.close();
        }
    }

    private static Matcher createMatcher(long nrOfPackets, long first, long last, long since, long until) {
        if (since != 0L || until != 0L) {
            return new TimeBasedMatcher(since, until);
        }
        if (nrOfPackets == 0L) {
            return new Matcher();
        }
        if (first != 0L) {
            return new FirstNMatcher(nrOfPackets, first);
        }
        if (last != 0L) {
            return new LastNMatcher(nrOfPackets, last);
        }
        throw new IllegalArgumentException();
    }

    private static class GCPrintStream
    extends SimpleProfilingPrintStream {
        public GCPrintStream(PrintStream stream) {
            super((OutputStream)stream);
        }

        protected void printBytes(long nrOfBytes) {
            this.print(DataFormatter.getNrOfBytesText((long)nrOfBytes));
            this.format(" (%,d bytes)", new Object[]{nrOfBytes});
        }

        public void printlnPacketHeader(ProfilingPacket packet) {
        }
    }

    private static class LastNMatcher
    extends Matcher {
        private long skipping;

        public LastNMatcher(long nrOfPackets, long count) {
            assert (nrOfPackets > 0L);
            this.skipping = nrOfPackets - count;
            if (count < nrOfPackets) {
                stream.println("Skipping the first " + this.skipping + " garbage collections.");
            }
        }

        @Override
        public boolean isMatch(ProfilingPacket packet) {
            boolean result = super.isMatch(packet) && this.skipping-- <= 0L;
            return result;
        }
    }

    private static class FirstNMatcher
    extends Matcher {
        private final long skipping;
        private long counter;

        public FirstNMatcher(long nrOfPackets, long count) {
            assert (nrOfPackets > 0L);
            this.skipping = nrOfPackets - count;
            this.counter = count;
        }

        @Override
        public boolean isMatch(ProfilingPacket packet) {
            boolean result;
            long beforeCounter = this.counter;
            boolean bl = result = super.isMatch(packet) && this.counter-- > 0L;
            if (beforeCounter != this.counter && this.counter == -1L) {
                stream.println("Skipping the last " + this.skipping + " garbage collections.");
            }
            return result;
        }
    }

    private static class TimeBasedMatcher
    extends Matcher {
        private final long startTime;
        private final long endTime;

        public TimeBasedMatcher(long startTime, long endTime) {
            this.startTime = startTime;
            this.endTime = endTime == 0L ? Long.MAX_VALUE : endTime;
        }

        @Override
        public boolean isMatch(ProfilingPacket packet) {
            return super.isMatch(packet) && ((GcStatistic)packet).getTimestamp() >= this.startTime && ((GcStatistic)packet).getTimestamp() <= this.endTime;
        }
    }

    private static class Matcher {
        private Matcher() {
        }

        public boolean isMatch(ProfilingPacket packet) {
            return packet instanceof GcStatistic;
        }
    }
}

