/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.gchistory;

import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.memory.event.GcEventBase;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.memory.event.GcStatisticBase;
import com.sap.jvm.profiling.tools.GenericPacketReader;
import com.sap.jvm.profiling.ui.graph.LineGraphChart;
import com.sap.jvm.profiling.ui.graph.LineGraphSelectionToolTipProvider;
import com.sap.jvm.profiling.ui.graph.LineGraphValueBarToolTipProvider;
import com.sap.jvm.profiling.ui.graph.awt.controls.GraphContainerControl;
import com.sap.jvm.profiling.ui.graph.axes.AxisCaptionProviderBase;
import com.sap.jvm.profiling.ui.graph.dataset.LineGraphDataSet;
import com.sap.jvm.profiling.ui.graph.geometry.Value2D;
import com.sap.jvm.profiling.ui.graph.renderer.Color;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class GCHistoryVisualizer {
    private static Color[] colors = new Color[]{Color.LIGHT_GRAY, Color.GRAY, Color.DARK_GRAY, Color.BLACK, Color.RED, Color.LIGHT_RED, Color.PINK, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.MAGENTA, Color.CYAN, Color.BLUE};
    private static int colorIndex = 0;
    private static Extractor extractor = new ReflectionExtractor("getBytesInNonPermAfterGc");
    private static LineGraphChart chart = null;
    private static String[] files = null;

    public static void main(String[] args) {
        files = args;
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setJMenuBar(GCHistoryVisualizer.createMenu());
        GraphContainerControl container = new GraphContainerControl(1);
        chart = new LineGraphChart(container.getChartContainer(), true, true);
        container.getChartContainer().addChart(chart);
        container.getChartContainer().setChartTitle("GC History");
        GCHistoryVisualizer.configureGraph();
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)container, "Center");
        frame.setTitle("GC History Visualizer");
        frame.setSize(500, 500);
        frame.setVisible(true);
    }

    private static void setData() {
        chart.removeAllGraphs();
        int values = 1;
        for (String filename : files) {
            LineGraphDataSet dataSet = GCHistoryVisualizer.retrieveData(filename);
            dataSet.setGraphColor(colors[colorIndex++ % colors.length]);
            dataSet.setValueColor(colors[colorIndex++ % colors.length]);
            values = Math.max(values, (int)dataSet.getSize());
            chart.addGraph(dataSet);
        }
        chart.adjustXAxis(0.0, values, false);
        chart.adjustYAxis(extractor.getMin(), extractor.getMax(), false);
        chart.refresh();
    }

    private static JMenuBar createMenu() {
        JMenuBar bar = new JMenuBar();
        JMenu memory = new JMenu("Memory");
        bar.add(memory);
        JMenu time = new JMenu("Time");
        bar.add(time);
        JMenu refs = new JMenu("Soft References");
        bar.add(refs);
        JMenu classes = new JMenu("Classes");
        bar.add(classes);
        JMenu pageFaults = new JMenu("Page Fault");
        bar.add(pageFaults);
        JMenu misc = new JMenu("Misc");
        bar.add(misc);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                extractor = new ReflectionExtractor(e.getActionCommand());
                GCHistoryVisualizer.setData();
            }
        };
        ActionListener eventsListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                extractor = new ReflectionEventExtractor(e.getActionCommand());
                GCHistoryVisualizer.setData();
            }
        };
        for (Method m : GcStatisticBase.class.getMethods()) {
            if (!m.getName().startsWith("get") || m.getReturnType() != Long.TYPE && m.getReturnType() != Integer.TYPE) continue;
            JMenuItem menuItem = new JMenuItem(m.getName().substring(3));
            menuItem.setActionCommand(m.getName());
            menuItem.addActionListener(listener);
            if (m.getName().contains("Bytes") || m.getName().contains("Size") || m.getName().contains("Allocation")) {
                memory.add(menuItem);
                continue;
            }
            if (m.getName().contains("CpuTime") || m.getName().contains("Duration")) {
                time.add(menuItem);
                continue;
            }
            if (m.getName().contains("Refs")) {
                refs.add(menuItem);
                continue;
            }
            if (m.getName().contains("Classes")) {
                classes.add(menuItem);
                continue;
            }
            if (m.getName().contains("PageFault")) {
                pageFaults.add(menuItem);
                continue;
            }
            misc.add(menuItem);
        }
        JMenu events = new JMenu("Events");
        bar.add(events);
        JMenuItem menuItem = new JMenuItem("LargestContiguousBlockInOld");
        menuItem.setActionCommand("getLargestContiguousBlockInOld");
        menuItem.addActionListener(eventsListener);
        events.add(menuItem);
        return bar;
    }

    private static LineGraphDataSet retrieveData(String filename) {
        LineGraphDataSet data = LineGraphChart.createDataSet(filename);
        try (GenericPacketReader reader = new GenericPacketReader(filename);){
            ProfilingPacket packet;
            while ((packet = reader.nextPacket()) != null) {
                if (!(packet instanceof GcStatistic)) continue;
                extractor.extract((GcStatistic)packet, data);
            }
        }
        catch (IOException e) {
            System.err.println("Error while processing file '" + filename + "', data may be incomplete.");
        }
        return data;
    }

    private static void configureGraph() {
        chart.enableValueSelection(true);
        chart.enableRectangleSelection(true);
        chart.enableHorizontalSelection(true);
        chart.enableMouseMove(true);
        chart.setAdjustOnDoubleClick(true);
        chart.enableQuickView(true);
        chart.enableHorizontalMouseMove(true);
        chart.setHorizontalQuickViewSelection(true);
        chart.setValueBarToolTipProvider(new LineGraphValueBarToolTipProvider(){

            @Override
            public String getXAxisValueText(double value) {
                return "X-" + value;
            }

            @Override
            public String getYAxisValueText(LineGraphDataSet graph1, double value) {
                return graph1.getName();
            }

            @Override
            public boolean isBarValueTooltipAvailable() {
                return true;
            }

            @Override
            public boolean isGraphValueToltipAvailable(LineGraphDataSet graph1) {
                return true;
            }
        });
        chart.addLineGraphSelectionToolTipProvider(new LineGraphSelectionToolTipProvider(){

            @Override
            public String provideHorizontalSelectionText(double min, double max) {
                return "" + Math.round(min) + '/' + Math.round(max);
            }

            @Override
            public String provideSelectedValueToolTip(LineGraphDataSet graph, List<Value2D> values) {
                return "A    \nB    \nC    y";
            }
        });
        chart.setXAxisCaptionProvider(new AxisCaptionProviderBase());
        chart.setYAxisCaptionProvider(new AxisCaptionProviderBase(){

            @Override
            public String provideScaleUnitCaption(double value, double range, double min, double max) {
                return String.valueOf(Math.round(value));
            }
        });
        chart.setInitializer(new Runnable(){

            @Override
            public void run() {
                GCHistoryVisualizer.setData();
            }
        });
    }

    private static class ReflectionEventExtractor
    implements Extractor {
        private final String getter;
        private double min = Double.MAX_VALUE;
        private double max = Double.MIN_VALUE;
        private static Map<Class<?>, Method> methods = new HashMap();

        public ReflectionEventExtractor(String method) {
            this.getter = method;
        }

        @Override
        public void extract(GcStatistic gc, LineGraphDataSet data) {
            GcEventBase[] events = gc.getEvents();
            for (int i = 0; i < events.length; ++i) {
                Method m = null;
                if (methods.containsKey(events[i].getClass())) {
                    m = methods.get(events[i].getClass());
                } else {
                    try {
                        m = events[i].getClass().getMethod(this.getter, new Class[0]);
                    }
                    catch (NoSuchMethodException | SecurityException exception) {
                        // empty catch block
                    }
                    methods.put(events[i].getClass(), m);
                }
                if (m == null) continue;
                try {
                    Object result = m.invoke((Object)events[i], new Object[0]);
                    if (!(result instanceof Number)) continue;
                    Number number = (Number)result;
                    this.min = Math.min(this.min, number.doubleValue());
                    this.max = Math.max(this.max, number.doubleValue());
                    data.addValue((double)gc.getGcNr() + 0.1 * (double)i, number.doubleValue(), true);
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public double getMin() {
            return this.min;
        }

        @Override
        public double getMax() {
            return this.max;
        }
    }

    private static class ReflectionExtractor
    implements Extractor {
        private final Method getter;
        private double min = Double.MAX_VALUE;
        private double max = Double.MIN_VALUE;

        public ReflectionExtractor(String method) {
            try {
                this.getter = GcStatisticBase.class.getMethod(method, new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void extract(GcStatistic gc, LineGraphDataSet data) {
            try {
                Object result = this.getter.invoke((Object)gc, new Object[0]);
                if (result instanceof Number) {
                    Number number = (Number)result;
                    this.min = Math.min(this.min, number.doubleValue());
                    this.max = Math.max(this.max, number.doubleValue());
                    data.addValue((double)gc.getGcNr(), number.doubleValue(), true);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }

        @Override
        public double getMin() {
            return this.min;
        }

        @Override
        public double getMax() {
            return this.max;
        }
    }

    private static interface Extractor {
        public void extract(GcStatistic var1, LineGraphDataSet var2);

        public double getMin();

        public double getMax();
    }
}

