/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.hprof;

import com.sap.jvm.internal.util.cmdline.CommandLineParser;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;

public class CheckHprof {
    private static final byte HPROF_UTF8 = 1;
    private static final byte HPROF_LOAD_CLASS = 2;
    private static final byte HPROF_FRAME = 4;
    private static final byte HPROF_TRACE = 5;
    private static final byte HPROF_HEAP_DUMP = 12;
    private static final CommandLineParser.Option helpOption = new CommandLineParser.OptionalSwitch("h", "help");
    private static final CommandLineParser.Option questionOption = new CommandLineParser.OptionalSwitch("?", "?");
    private static final CommandLineParser.Option[] options = new CommandLineParser.Option[]{helpOption, questionOption};

    public static void main(String[] args) throws Exception {
        try {
            CommandLineParser parser = new CommandLineParser(args, options, false);
            String[] unparsedStrings = parser.getRemainingArguments();
            if (parser.isOptionSet(helpOption) || parser.isOptionSet(questionOption)) {
                CheckHprof.printUsage();
                return;
            }
            CheckHprof.checkRemainingArguments(unparsedStrings);
            try {
                for (String file : unparsedStrings) {
                    CheckHprof.checkHprofFile(file);
                }
            }
            catch (IOException e) {
                System.err.println("Error while reading file: " + e.getMessage());
            }
        }
        catch (CommandLineParser.UnknownOptionException e) {
            System.err.println("Unknown option '" + e.getMessage() + "'.");
            CheckHprof.printUsage();
            System.exit(1);
        }
        catch (CommandLineParser.IllegalOptionFormatException e) {
            System.err.println("Format of option '" + e.getMessage() + "' illegal.");
            CheckHprof.printUsage();
            System.exit(1);
        }
        catch (CommandLineParser.MissingOptionValueException e) {
            System.err.println("Value of option '" + e.getMessage() + "' missing.");
            CheckHprof.printUsage();
            System.exit(1);
        }
    }

    private static void printUsage() {
        System.out.println("Checks a hprof heap dump.");
        System.out.println();
        System.out.println("Syntax: checkhprof [<options> ...] <hprof-file> [<hprof-file> ...]");
        System.out.println();
        System.out.println("The following options are supported: ");
        System.out.println("-?, --?");
        System.out.println("            Print usage information (this message).");
        System.out.println("-h, --help");
        System.out.println("            Print usage information (this message).");
    }

    private static void checkRemainingArguments(String[] args) {
        if (args.length == 0) {
            CheckHprof.printUsage();
            System.exit(1);
        }
        assert (args.length == 1);
        File file = new File(args[0]);
        if (!file.exists() || file.isDirectory()) {
            System.err.println("File not found: " + args[0]);
            CheckHprof.printUsage();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkHprofFile(String fileName) throws IOException {
        try (RandomAccessFile file = new RandomAccessFile(fileName, "r");){
            System.out.println("Hprof File: " + fileName);
            byte[] tag1 = "JAVA PROFILE 1.0.1".getBytes("UTF-8");
            byte[] checkTag1 = new byte[tag1.length + 1];
            file.readFully(checkTag1);
            for (int i = 0; i < tag1.length; ++i) {
                if (checkTag1[i] == tag1[i]) continue;
                System.out.println("Invalid header '" + (char)checkTag1[i] + "' vs. '" + (char)tag1[i] + "'");
                return;
            }
            int oopSize = file.readInt();
            System.out.println("Oop size: " + oopSize);
            long timestamp = file.readLong();
            System.out.println("Timestamp: " + new Date(timestamp));
            long nrOfStrings = 0L;
            long nrOfLoadedClasses = 0L;
            long nrOfTraces = 0L;
            long nrOfFrames = 0L;
            long nrOfHeapDumps = 0L;
            long heapDumpSize = 0L;
            try {
                while (true) {
                    byte tag = file.readByte();
                    file.readInt();
                    int length = file.readInt();
                    switch (tag) {
                        case 1: {
                            ++nrOfStrings;
                            break;
                        }
                        case 2: {
                            ++nrOfLoadedClasses;
                            break;
                        }
                        case 4: {
                            ++nrOfFrames;
                            break;
                        }
                        case 5: {
                            ++nrOfTraces;
                            break;
                        }
                        case 12: {
                            ++nrOfHeapDumps;
                            heapDumpSize += (long)length;
                            break;
                        }
                        default: {
                            System.out.println("Unknown tag " + tag + " at offset " + file.getFilePointer());
                        }
                    }
                    file.skipBytes(length);
                }
            }
            catch (EOFException eOFException) {
                System.out.println("Number of strings: " + nrOfStrings);
                System.out.println("Number of loaded classes: " + nrOfLoadedClasses);
                System.out.println("Number of traces: " + nrOfTraces);
                System.out.println("Number of frames: " + nrOfFrames);
                System.out.println("Number of heap dumps: " + nrOfHeapDumps);
                System.out.println("Size of heap dumps: " + heapDumpSize);
                file.close();
            }
        }
    }
}

