/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.hprof;

import com.sap.jvm.internal.util.cmdline.CommandLineParser;
import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.impl.memory.event.HprofDumpEndImpl;
import com.sap.jvm.profiling.impl.memory.event.HprofDumpStartImpl;
import com.sap.jvm.profiling.memory.event.HprofDumpSeek;
import com.sap.jvm.profiling.memory.event.HprofDumpWrite;
import com.sap.jvm.profiling.tools.GenericPacketReader;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class HprofDumpWriter {
    private static final String DEFAULT_PREFIX = "sapjvm-hprof";
    private static final CommandLineParser.Option helpOption = new CommandLineParser.OptionalSwitch("h", "help");
    private static final CommandLineParser.Option questionOption = new CommandLineParser.OptionalSwitch("?", "?");
    private static final CommandLineParser.Option firstOption = new CommandLineParser.OptionalEqualsOption("f", "first");
    private static final CommandLineParser.Option lastOption = new CommandLineParser.OptionalEqualsOption("l", "last");
    private static final CommandLineParser.Option prefixOption = new CommandLineParser.OptionalEqualsOption("p", "prefix");
    private static final CommandLineParser.Option displayOption = new CommandLineParser.OptionalSwitch("d", "display");
    private static final CommandLineParser.Option[] options = new CommandLineParser.Option[]{helpOption, questionOption, firstOption, lastOption, prefixOption, displayOption};

    public static void main(String[] args) throws Exception {
        try {
            CommandLineParser parser = new CommandLineParser(args, options, false);
            String[] unparsedStrings = parser.getRemainingArguments();
            if (parser.isOptionSet(helpOption) || parser.isOptionSet(questionOption)) {
                HprofDumpWriter.printUsage();
                return;
            }
            HprofDumpWriter.checkRemainingArguments(unparsedStrings);
            long first = HprofDumpWriter.parseLongOption(parser, firstOption);
            long last = Math.max(Long.MAX_VALUE, HprofDumpWriter.parseLongOption(parser, lastOption));
            boolean displayOnly = parser.isOptionSet(displayOption);
            String prefix = DEFAULT_PREFIX;
            if (parser.isOptionSet(prefixOption)) {
                prefix = parser.getValue(prefixOption);
            }
            try {
                HprofDumpWriter.dumpPackets(unparsedStrings[0], first, last, prefix, displayOnly);
            }
            catch (IOException e) {
                System.err.println("Error while reading file: " + e.getMessage());
            }
        }
        catch (CommandLineParser.UnknownOptionException e) {
            System.err.println("Unknown option '" + e.getMessage() + "'.");
            HprofDumpWriter.printUsage();
            System.exit(1);
        }
        catch (CommandLineParser.IllegalOptionFormatException e) {
            System.err.println("Format of option '" + e.getMessage() + "' illegal.");
            HprofDumpWriter.printUsage();
            System.exit(1);
        }
        catch (CommandLineParser.MissingOptionValueException e) {
            System.err.println("Value of option '" + e.getMessage() + "' missing.");
            HprofDumpWriter.printUsage();
            System.exit(1);
        }
    }

    private static void printUsage() {
        System.out.println("Extracts hprof heap dumps from a profiling file.");
        System.out.println();
        System.out.println("Syntax: extracthprof [<options> ...] <profiling-file>");
        System.out.println();
        System.out.println("The following options are supported: ");
        System.out.println("-?, --?");
        System.out.println("            Print usage information (this message).");
        System.out.println("-f, --first=<number of dumps>");
        System.out.println("            Extract only the first <number of dumps> heap dumps.");
        System.out.println("-h, --help");
        System.out.println("            Print usage information (this message).");
        System.out.println("-l, --last=<number of dumps>");
        System.out.println("            Extract only the last <number of dumps> heap dumps.");
        System.out.println("-p, --prefix=<prefix>");
        System.out.println("            The prefix for all dump filenames. The default is 'sapjvm-hprof'");
        System.out.println("-d, --display");
        System.out.println("            Only displays the dumps it would write.");
    }

    private static void checkRemainingArguments(String[] args) {
        if (args.length == 0 || args.length > 1) {
            if (args.length > 1) {
                System.err.println("Too many arguments");
            }
            HprofDumpWriter.printUsage();
            System.exit(1);
        }
        assert (args.length == 1);
        File file = new File(args[0]);
        if (!file.exists() || file.isDirectory()) {
            System.err.println("File not found: " + args[0]);
            HprofDumpWriter.printUsage();
            System.exit(1);
        }
    }

    private static long parseLongOption(CommandLineParser parser, CommandLineParser.Option option) throws CommandLineParser.IllegalOptionFormatException {
        if (parser.isOptionSet(option)) {
            try {
                return Long.parseLong(parser.getValue(option));
            }
            catch (NumberFormatException e) {
                throw new CommandLineParser.IllegalOptionFormatException(option.getLongName());
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpPackets(String fileName, long first, long last, String prefix, boolean displayOnly) throws IOException {
        long startTime = 0L;
        try (GenericPacketReader reader = new GenericPacketReader(fileName);){
            ProfilingPacket packet;
            RandomAccessFile file = null;
            while ((packet = reader.nextPacket()) != null) {
                HprofDumpWrite event;
                if (packet instanceof HprofDumpWrite) {
                    event = (HprofDumpWrite)packet;
                    if (displayOnly) continue;
                    file.write(event.getData());
                    continue;
                }
                if (packet instanceof HprofDumpSeek) {
                    event = (HprofDumpSeek)packet;
                    if (displayOnly) continue;
                    file.seek(event.getSeekOffset());
                    continue;
                }
                if (packet instanceof HprofDumpStartImpl) {
                    event = (HprofDumpStartImpl)packet;
                    startTime = event.getStartTime();
                    String dumpName = prefix + "-" + event.getDumpIndex() + ".hprof";
                    if (displayOnly) {
                        System.out.print("Found heap dump '" + dumpName + "' ... ");
                    } else {
                        System.out.print("Creating heap dump '" + dumpName + "' ... ");
                    }
                    if (displayOnly) continue;
                    file = new RandomAccessFile(dumpName, "rw");
                    continue;
                }
                if (!(packet instanceof HprofDumpEndImpl)) continue;
                event = (HprofDumpEndImpl)packet;
                double t = (double)((event.getEndTime() - startTime) / 100L) * 0.1;
                System.out.print("size " + event.getSize() + " took " + t + " s");
                System.out.println(", contains " + event.getNumberOfObjects() + " objects");
                if (displayOnly) continue;
                file.close();
                file = null;
            }
        }
    }
}

