/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.internal;

import com.sap.jvm.internal.util.cmdline.CommandLineParser;
import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.DetailedProfilingPrintStream;
import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.event.ThreadStarted;
import com.sap.jvm.profiling.core.event.ThreadStopped;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.memory.event.AllocationEvent;
import com.sap.jvm.profiling.memory.event.GcStatisticBase;
import com.sap.jvm.profiling.memory.event.ObjectDeathEvent;
import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.method.parameters.LongParameter;
import com.sap.jvm.profiling.method.parameters.MethodParameters;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.parameters.ParameterType;
import com.sap.jvm.profiling.sync.event.MonitorSlowEnterEvent;
import com.sap.jvm.profiling.tools.GenericPacketReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class BiasedLockingChecker {
    private final Result totalResult = new Result();
    private final HashMap<Integer, Result> resultsPerClass = new HashMap();
    private final HashMap<AllocationSite, Result> resultsPerSite = new HashMap();

    public static void main(String[] args) throws Exception {
        CommandLineParser.OptionalSwitch showClassDetails = new CommandLineParser.OptionalSwitch("c", "show-class-details");
        CommandLineParser.OptionalSwitch showSiteDetails = new CommandLineParser.OptionalSwitch("s", "show-site-details");
        CommandLineParser.OptionalSwitch allocAsBiased = new CommandLineParser.OptionalSwitch("a", "alloc-as-biased");
        CommandLineParser.OptionalSwitch hashCodeRevokes = new CommandLineParser.OptionalSwitch("h", "hash-code-revokes");
        CommandLineParser.OptionalSwitch debiasAtFullGc = new CommandLineParser.OptionalSwitch("g", "debias-at-full-gc");
        CommandLineParser.OptionalSwitch useLocationAsSite = new CommandLineParser.OptionalSwitch("l", "use-location-as-site");
        CommandLineParser.OptionalSwitch allocNonBiasedInInterpreter = new CommandLineParser.OptionalSwitch("I", "alloc-non-biased-in-interpreter");
        CommandLineParser.OptionalSwitch blackListPerClassDoesBulkRevokes = new CommandLineParser.OptionalSwitch("C", "black-list-per-class-does-bulk-revokes");
        CommandLineParser.OptionalSwitch blackListPerSiteDoesBulkRevokes = new CommandLineParser.OptionalSwitch("S", "black-list-per-site-does-bulk-revokes");
        CommandLineParser.OptionalEqualsOption blackListPerClassThreashold = new CommandLineParser.OptionalEqualsOption("black-list-per-class-threashold", 100, "Specifies the number of revokes per class until the objects are black listed");
        CommandLineParser.OptionalEqualsOption blackListPerSiteThreashold = new CommandLineParser.OptionalEqualsOption("black-list-per-site-threashold", 20, "Specifies the number of revokes per site until the objects areblack listed");
        CommandLineParser.OptionalEqualsOption bulkRebiasPerClassThreashold = new CommandLineParser.OptionalEqualsOption("bulk-rebias-per-class-threashold", 20, "Specifies the number of revokes per class until the objects are bulk rebiased");
        CommandLineParser.OptionalEqualsOption bulkRebiasPerSiteThreshold = new CommandLineParser.OptionalEqualsOption("bulk-rebias-per-site-threashold", 5, "Specifies the number of revokes per site until the objects are bulk rebiased");
        CommandLineParser.OptionalEqualsOption blackListPerClassResetLockCount = new CommandLineParser.OptionalEqualsOption("black-list-per-class-reset-lock-count", 0, "Specifies the number of non-biased lock operations per class until the class is tried to be made biasable again");
        CommandLineParser.OptionalEqualsOption blackListPerSiteResetLockCount = new CommandLineParser.OptionalEqualsOption("black-list-per-site-reset-lock-count", 0, "Specifies the number of non-biased lock operations per site until the class is tried to be made biasable again");
        CommandLineParser.OptionalEqualsOption classResetRevokeCount = new CommandLineParser.OptionalEqualsOption("class-reset-revoke-count", 0, "Specifies the number of lock operations per site until the revoke count of that site is reset.");
        CommandLineParser.OptionalEqualsOption siteResetRevokeCount = new CommandLineParser.OptionalEqualsOption("class-reset-revoke-count", 0, "Specifies the number of lock operations per site until the revoke count of that site is reset.");
        CommandLineParser.Option[] options = new CommandLineParser.Option[]{showClassDetails, showSiteDetails, allocAsBiased, hashCodeRevokes, debiasAtFullGc, useLocationAsSite, blackListPerClassDoesBulkRevokes, blackListPerSiteDoesBulkRevokes, allocNonBiasedInInterpreter, blackListPerClassThreashold, blackListPerSiteThreashold, bulkRebiasPerClassThreashold, bulkRebiasPerSiteThreshold, blackListPerClassResetLockCount, blackListPerSiteResetLockCount, classResetRevokeCount, siteResetRevokeCount};
        CommandLineParser parser = new CommandLineParser(args, options, true);
        if (args.length == 0) {
            System.out.println("Missing prf filename.");
            System.out.println();
            System.out.println("We take one or more profiling runs and determine which ");
            System.out.println("allocations would have profited from biased locking.");
            System.out.println();
            parser.printOptionHelp(System.out);
            return;
        }
        Config cfg = new Config();
        cfg.allocAsBiased = parser.isOptionSet(allocAsBiased);
        cfg.hashCodeRevokes = parser.isOptionSet(hashCodeRevokes);
        cfg.debiasAtFullGc = parser.isOptionSet(debiasAtFullGc);
        cfg.useLocationAsSite = parser.isOptionSet(useLocationAsSite);
        cfg.blackListPerClassDoesBulkRevokes = parser.isOptionSet(blackListPerClassDoesBulkRevokes);
        cfg.blackListPerSiteDoesBulkRevokes = parser.isOptionSet(blackListPerSiteDoesBulkRevokes);
        cfg.allocNonBiasedInInterpreter = parser.isOptionSet(allocNonBiasedInInterpreter);
        cfg.blackListPerClassThreashold = parser.getNumericValue(blackListPerClassThreashold).intValue();
        cfg.blackListPerSiteThreshold = parser.getNumericValue(blackListPerSiteThreashold).intValue();
        cfg.bulkRebiasPerClassThreashold = parser.getNumericValue(bulkRebiasPerClassThreashold).intValue();
        cfg.bulkRebiasPerSiteThreshold = parser.getNumericValue(bulkRebiasPerSiteThreshold).intValue();
        cfg.blackListerClassResetLockCount = parser.getNumericValue(blackListPerClassResetLockCount).intValue();
        cfg.blackListSiteResetLockCount = parser.getNumericValue(blackListPerSiteResetLockCount).intValue();
        cfg.classResetRevokeCount = parser.getNumericValue(classResetRevokeCount).intValue();
        cfg.siteResetRevokeCount = parser.getNumericValue(siteResetRevokeCount).intValue();
        for (String prf : parser.getRemainingArguments()) {
            if (!new File(prf).exists()) continue;
            BiasedLockingChecker sim = new BiasedLockingChecker();
            sim.runSim(prf, cfg, parser.isOptionSet(showClassDetails), parser.isOptionSet(showSiteDetails));
        }
    }

    private void runSim(String fileName, Config cfg, boolean includeClassDetails, boolean includeSiteDetails) throws IOException {
        State state = new State(cfg);
        String[] threadNames = new String[65536];
        GenericPacketReader reader = new GenericPacketReader(fileName);
        ProfilingPacket packet = null;
        while ((packet = reader.nextPacket()) != null) {
            ThreadStarted event;
            if (packet instanceof ThreadStarted) {
                event = (ThreadStarted)packet;
                threadNames[event.getThreadIndex()] = event.getName().toString();
                continue;
            }
            if (packet instanceof ThreadStopped) {
                event = (ThreadStopped)packet;
                threadNames[event.getThreadIndex()] = null;
                continue;
            }
            if (packet instanceof AllocationEvent) {
                state.allocated((AllocationEvent)packet, reader.getSession());
                continue;
            }
            if (packet instanceof ObjectDeathEvent) {
                event = (ObjectDeathEvent)packet;
                long id = event.getObjectId();
                this.addResult(state.objs.get(id));
                state.remove(id);
                continue;
            }
            if (packet instanceof MethodParameterEntryEvent) {
                LongParameter value;
                long id;
                event = (MethodParameterEntryEvent)packet;
                MethodParameters parameters = event.getParameters();
                String method = parameters.getMethod().getFullName();
                if (!"java.lang.Object.hashCode()int".equals(method) && !"java.lang.System.identityHashCode(java.lang.Object)int".equals(method)) continue;
                assert (parameters.getNrOfParameters() == 1);
                Parameter param = parameters.getParameter(0);
                if (param.getType() != ParameterType.LONG || (id = (value = (LongParameter)param).asLong()) == 0L) continue;
                state.hashCodeCalled(id);
                continue;
            }
            if (packet instanceof MonitorSlowEnterEvent) {
                state.lock((MonitorSlowEnterEvent)packet);
                continue;
            }
            if (!(packet instanceof GcStatisticBase) || !(event = (GcStatisticBase)packet).isFullGc()) continue;
            state.fullGcPerformed(this.totalResult);
        }
        for (ObjectInfo info : state.objs.values()) {
            this.addResult(info);
        }
        DetailedProfilingPrintStream pps = new DetailedProfilingPrintStream(System.out, 0, 10, reader.getSession());
        pps.println("Result for file '" + fileName + "'");
        this.totalResult.print(System.out);
        if (includeClassDetails) {
            pps.println();
            pps.println("    === Details by class ===");
            pps.println();
            state.printClassStatistic(reader.getSession(), (ProfilingPrintStream)pps);
            pps.println();
            pps.println("Number of different allocated classes " + this.resultsPerClass.size());
            pps.println();
            pps.println("    === Sorted by total lock count ===");
            this.dumpClassInfo(this.sortByLockCount(this.resultsPerClass), (ProfilingPrintStream)pps);
            pps.println("    === Sorted by revocation count ===");
            this.dumpClassInfo(this.sortByRevocationCount(this.resultsPerClass), (ProfilingPrintStream)pps);
            pps.println("    === Sorted by biased locks count ===");
            this.dumpClassInfo(this.sortByBiasedLockCount(this.resultsPerClass), (ProfilingPrintStream)pps);
            pps.println("    === Sorted by fully biasable objects count ===");
            this.dumpClassInfo(this.sortByFullyBiasableObjectsCount(this.resultsPerClass), (ProfilingPrintStream)pps);
        }
        if (includeSiteDetails) {
            pps.println();
            pps.println("    === Details by site ===");
            pps.println();
            state.printSiteStatistic((ProfilingPrintStream)pps, cfg);
            pps.println();
            pps.println("Number of different allocation sites: " + this.resultsPerSite.size());
            pps.println();
            pps.println("    === Sorted by total lock count ===");
            this.dumpAllocationSiteInfo(this.sortByLockCount(this.resultsPerSite), (ProfilingPrintStream)pps, cfg);
            pps.println("    === Sorted by revocation count ===");
            this.dumpAllocationSiteInfo(this.sortByRevocationCount(this.resultsPerSite), (ProfilingPrintStream)pps, cfg);
            pps.println("    === Sorted by biased locks count ===");
            this.dumpAllocationSiteInfo(this.sortByBiasedLockCount(this.resultsPerSite), (ProfilingPrintStream)pps, cfg);
            pps.println("    === Sorted by fully biasable objects count ===");
            this.dumpAllocationSiteInfo(this.sortByFullyBiasableObjectsCount(this.resultsPerSite), (ProfilingPrintStream)pps, cfg);
        }
        pps.println();
        pps.println();
        pps.println();
        reader.close();
    }

    private void dumpClassInfo(ArrayList<Map.Entry<?, Result>> sites, ProfilingPrintStream pps) {
        for (Map.Entry<?, Result> val : sites) {
            pps.println();
            Integer classIndex = (Integer)val.getKey();
            pps.formatln("Allocated class: %*c", new Object[]{classIndex});
            this.resultsPerClass.get(classIndex).print(System.out);
        }
        pps.println();
    }

    private void dumpAllocationSiteInfo(ArrayList<Map.Entry<?, Result>> sites, ProfilingPrintStream pps, Config cfg) {
        for (Map.Entry<?, Result> val : sites) {
            pps.println();
            AllocationSite site = (AllocationSite)val.getKey();
            pps.formatln("Allocated class: %*c", new Object[]{site.classIndex});
            if (cfg.useLocationAsSite) {
                pps.formatln("Location %*l", new Object[]{site.stackIndex});
            } else {
                pps.formatln("Stack %*S", new Object[]{site.stackIndex});
            }
            this.resultsPerSite.get(site).print(System.out);
        }
        pps.println();
    }

    private void addResult(ObjectInfo info) {
        if (info == null) {
            return;
        }
        this.totalResult.addObjectInfo(info);
        Result classResult = this.resultsPerClass.get(info.classIndex);
        if (classResult == null) {
            classResult = new Result();
            this.resultsPerClass.put(info.classIndex, classResult);
        }
        classResult.addObjectInfo(info);
        Result siteResult = this.resultsPerSite.get(info);
        if (siteResult == null) {
            siteResult = new Result();
            this.resultsPerSite.put(info, siteResult);
        }
        siteResult.addObjectInfo(info);
    }

    private ArrayList<Map.Entry<?, Result>> sortByLockCount(HashMap<?, Result> results) {
        ArrayList entries = new ArrayList(results.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<?, Result>>(){

            @Override
            public int compare(Map.Entry<?, Result> o1, Map.Entry<?, Result> o2) {
                return -Long.valueOf(o1.getValue().nrOfEnters).compareTo(o2.getValue().nrOfEnters);
            }
        });
        return entries;
    }

    private ArrayList<Map.Entry<?, Result>> sortByRevocationCount(HashMap<?, Result> results) {
        ArrayList entries = new ArrayList(results.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<?, Result>>(){

            @Override
            public int compare(Map.Entry<?, Result> o1, Map.Entry<?, Result> o2) {
                return -Long.valueOf(o1.getValue().nrOfRevokes).compareTo(o2.getValue().nrOfRevokes);
            }
        });
        return entries;
    }

    private ArrayList<Map.Entry<?, Result>> sortByBiasedLockCount(HashMap<?, Result> results) {
        ArrayList entries = new ArrayList(results.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<?, Result>>(){

            @Override
            public int compare(Map.Entry<?, Result> o1, Map.Entry<?, Result> o2) {
                return -Long.valueOf(o1.getValue().nrOfBiasLockOperations).compareTo(o2.getValue().nrOfBiasLockOperations);
            }
        });
        return entries;
    }

    private ArrayList<Map.Entry<?, Result>> sortByFullyBiasableObjectsCount(HashMap<?, Result> results) {
        ArrayList entries = new ArrayList(results.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<?, Result>>(){

            @Override
            public int compare(Map.Entry<?, Result> o1, Map.Entry<?, Result> o2) {
                return -Long.valueOf(o1.getValue().nrOfFullyBiasableObjects).compareTo(o2.getValue().nrOfFullyBiasableObjects);
            }
        });
        return entries;
    }

    public static class Stat {
        public long nrOfObjects;
        public long nrOfEvents;
    }

    public static class ObjectInfo
    extends AllocationSite {
        public int threadIndex = -1;
        public boolean biasable;
        public boolean locked;
        public boolean anonymously;
        public int nrOfRevokes;
        public int nrOfBulkRevokes;
        public int nrOfBulkRebiases;
        public int nrOfBiasedLockOps;
        public int nrOfNonBiasedLockOps;
        public int nrOfSameThreadLockOps;
        public int nrOfUnbiasedAtFullGc;
        public int nrOfInitialBiasingLocks;

        public ObjectInfo(boolean isCompiled, int classIndex, int stackIndex) {
            super(isCompiled, classIndex, stackIndex);
        }
    }

    public static class AllocationSite {
        public final int classIndex;
        public final int stackIndex;
        public final boolean isCompiled;

        public AllocationSite(boolean isCompiled, int classIndex, int stackIndex) {
            this.classIndex = classIndex;
            this.stackIndex = stackIndex;
            this.isCompiled = isCompiled;
        }

        public boolean equals(Object o) {
            if (o instanceof AllocationSite) {
                AllocationSite other = (AllocationSite)o;
                return this.classIndex == other.classIndex && this.stackIndex == other.stackIndex && this.isCompiled == other.isCompiled;
            }
            return false;
        }

        public int hashCode() {
            return this.classIndex ^ this.stackIndex;
        }
    }

    public static class State {
        public final HashMap<Long, ObjectInfo> objs = new HashMap();
        public final HashMap<Integer, Integer> revokesPerClass = new HashMap();
        public final HashMap<Integer, Integer> revokesPerSite = new HashMap();
        public final HashMap<Integer, Integer> unbiasedLocksPerClass = new HashMap();
        public final HashMap<Integer, Integer> unbiasedLocksPerSite = new HashMap();
        public final HashSet<Integer> classBlackList = new HashSet();
        public final HashMap<Integer, Integer> siteBlackList = new HashMap();
        public final Config cfg;

        public State(Config cfg) {
            this.cfg = cfg;
        }

        public void allocated(AllocationEvent event, ProfilingSession session) {
            int stackIndex = event.getStackTraceIndex();
            if (this.cfg.useLocationAsSite) {
                StackFrames sf = session.getStackTraceManager().getStackFramesObject(false);
                sf.fillIn(stackIndex);
                stackIndex = sf.getNrOfFrames() > 0 ? sf.getMethodLocationIndex(sf.getNrOfFrames() - 1) : 0;
            }
            boolean isCompiled = event.getNrOfInlinedTopFrames() > 0;
            ObjectInfo info = new ObjectInfo(event.getNrOfInlinedTopFrames() > 0, event.getClassObject().getIndex(), stackIndex);
            if (!(this.classBlackList.contains(info.classIndex) || this.siteBlackList.containsKey(info.stackIndex) || this.cfg.allocNonBiasedInInterpreter && !isCompiled)) {
                info.biasable = true;
                info.anonymously = true;
                if (this.cfg.allocAsBiased) {
                    info.threadIndex = event.getThreadIndex();
                    info.anonymously = false;
                }
            } else {
                info.anonymously = true;
            }
            this.objs.put(event.getObjectId(), info);
        }

        public void lock(MonitorSlowEnterEvent event) {
            long id = event.getObjectId();
            char threadIndex = event.getThreadIndex();
            ObjectInfo info = this.objs.get(id);
            if (info == null) {
                return;
            }
            if (info.threadIndex == threadIndex) {
                ++info.nrOfSameThreadLockOps;
            }
            boolean unbiasedLock = false;
            if (info.biasable) {
                if (info.anonymously) {
                    info.threadIndex = threadIndex;
                    ++info.nrOfBiasedLockOps;
                    ++info.nrOfInitialBiasingLocks;
                    info.anonymously = false;
                } else if (info.threadIndex == threadIndex) {
                    ++info.nrOfBiasedLockOps;
                    unbiasedLock = true;
                } else {
                    this.revoke(id, RevokeCause.LOCK);
                }
            } else {
                ++info.nrOfNonBiasedLockOps;
                unbiasedLock = true;
            }
            info.threadIndex = threadIndex;
            if (unbiasedLock) {
                if (this.unbiasedLocksPerSite.containsKey(info.stackIndex)) {
                    this.unbiasedLocksPerSite.put(info.stackIndex, this.unbiasedLocksPerSite.get(info.stackIndex) + 1);
                } else {
                    this.unbiasedLocksPerSite.put(info.stackIndex, 1);
                }
                if (this.unbiasedLocksPerClass.containsKey(info.classIndex)) {
                    this.unbiasedLocksPerClass.put(info.classIndex, this.unbiasedLocksPerClass.get(info.classIndex) + 1);
                } else {
                    this.unbiasedLocksPerClass.put(info.classIndex, 1);
                }
                if (this.cfg.blackListerClassResetLockCount > 0 && this.unbiasedLocksPerClass.get(info.classIndex) >= this.cfg.blackListerClassResetLockCount) {
                    this.unbiasedLocksPerClass.remove(info.classIndex);
                    this.classBlackList.remove(info.classIndex);
                }
                if (this.cfg.classResetRevokeCount > 0 && this.unbiasedLocksPerClass.get(info.classIndex) >= this.cfg.classResetRevokeCount) {
                    this.unbiasedLocksPerClass.put(info.classIndex, 0);
                    this.revokesPerClass.remove(info.classIndex);
                    this.classBlackList.remove(info.classIndex);
                }
                if (this.cfg.blackListSiteResetLockCount > 0 && this.unbiasedLocksPerSite.get(info.stackIndex) >= this.cfg.blackListSiteResetLockCount) {
                    this.unbiasedLocksPerSite.remove(info.stackIndex);
                    this.siteBlackList.remove(info.stackIndex);
                }
                if (this.cfg.siteResetRevokeCount > 0 && this.unbiasedLocksPerSite.get(info.stackIndex) >= this.cfg.siteResetRevokeCount) {
                    this.unbiasedLocksPerSite.put(info.stackIndex, 0);
                    this.revokesPerSite.remove(info.stackIndex);
                    this.siteBlackList.remove(info.stackIndex);
                }
            }
        }

        public void hashCodeCalled(long id) {
            if (this.cfg.hashCodeRevokes) {
                this.revoke(id, RevokeCause.HASH_CODE);
            }
        }

        public void fullGcPerformed(Result result) {
            int biasable = 0;
            for (ObjectInfo info : this.objs.values()) {
                if (!info.biasable || !this.cfg.debiasAtFullGc) continue;
                info.biasable = false;
                info.anonymously = false;
                ++biasable;
                if (info.threadIndex == 0) continue;
                ++info.nrOfUnbiasedAtFullGc;
            }
            result.maxBiasableAtFullGc = Math.max(result.maxBiasableAtFullGc, (long)biasable);
        }

        public void remove(long id) {
            this.objs.remove(id);
        }

        private void revoke(long id, RevokeCause cause) {
            ObjectInfo info = this.objs.get(id);
            if (cause == RevokeCause.LOCK) {
                info.biasable = false;
                info.anonymously = false;
                ++info.nrOfRevokes;
                ++info.nrOfNonBiasedLockOps;
            } else if (cause == RevokeCause.HASH_CODE && info.biasable) {
                info.biasable = false;
                ++info.nrOfRevokes;
            }
            if (this.revokesPerClass.containsKey(info.classIndex)) {
                this.revokesPerClass.put(info.classIndex, this.revokesPerClass.get(info.classIndex) + 1);
            } else {
                this.revokesPerClass.put(info.classIndex, 1);
            }
            if (this.revokesPerSite.containsKey(info.stackIndex)) {
                this.revokesPerSite.put(info.stackIndex, this.revokesPerSite.get(info.stackIndex) + 1);
            } else {
                this.revokesPerSite.put(info.stackIndex, 1);
            }
            if (this.cfg.bulkRebiasPerClassThreashold > 0 && this.revokesPerClass.get(info.classIndex) % this.cfg.bulkRebiasPerClassThreashold == 0) {
                for (Long i : this.objs.keySet()) {
                    ObjectInfo obj = this.objs.get(i);
                    if (obj.classIndex != info.classIndex) continue;
                    obj.biasable = true;
                    obj.anonymously = true;
                    ++obj.nrOfBulkRebiases;
                }
                return;
            }
            if (this.cfg.bulkRebiasPerSiteThreshold > 0 && this.revokesPerSite.get(info.stackIndex) % this.cfg.bulkRebiasPerSiteThreshold == 0) {
                for (Long i : this.objs.keySet()) {
                    ObjectInfo obj = this.objs.get(i);
                    if (obj.stackIndex != info.stackIndex) continue;
                    obj.biasable = true;
                    obj.anonymously = true;
                    ++obj.nrOfBulkRebiases;
                }
                return;
            }
            if (this.cfg.blackListPerClassThreashold > 0 && this.revokesPerClass.get(info.classIndex) == this.cfg.blackListPerClassThreashold) {
                this.classBlackList.add(info.classIndex);
                if (this.cfg.blackListPerClassDoesBulkRevokes) {
                    for (Long i : this.objs.keySet()) {
                        ObjectInfo obj = this.objs.get(i);
                        if (obj.classIndex != info.classIndex || !obj.biasable) continue;
                        obj.biasable = false;
                        obj.anonymously = false;
                        ++obj.nrOfBulkRevokes;
                    }
                }
                return;
            }
            if (this.cfg.blackListPerSiteThreshold > 0 && this.revokesPerSite.get(info.stackIndex) == this.cfg.blackListPerSiteThreshold) {
                this.siteBlackList.put(info.stackIndex, info.classIndex);
                if (this.cfg.blackListPerSiteDoesBulkRevokes) {
                    for (Long i : this.objs.keySet()) {
                        ObjectInfo obj = this.objs.get(i);
                        if (obj.stackIndex != info.stackIndex || !obj.biasable) continue;
                        obj.biasable = false;
                        obj.anonymously = false;
                        ++obj.nrOfBulkRevokes;
                    }
                }
                return;
            }
        }

        public void printClassStatistic(ProfilingSession session, ProfilingPrintStream st) {
            System.out.println("Number of black listed classes: " + this.classBlackList.size());
            ArrayList<String> blacklistedNames = new ArrayList<String>();
            for (int classIndex : this.classBlackList) {
                blacklistedNames.add(session.getClassObjectManager().getClassObject(classIndex).toString());
            }
            Collections.sort(blacklistedNames);
            for (String name : blacklistedNames) {
                st.println(name);
            }
        }

        public void printSiteStatistic(ProfilingPrintStream st, Config config) {
            st.println("Number of black listed sites: " + this.siteBlackList.size());
            for (int siteIndex : this.siteBlackList.keySet()) {
                st.formatln("Allocated Class: %*c", new Object[]{this.siteBlackList.get(siteIndex)});
                if (config.useLocationAsSite) {
                    st.formatln("Location %*l", new Object[]{siteIndex});
                    continue;
                }
                st.formatln("Stack %*S", new Object[]{siteIndex});
            }
        }
    }

    public static class Result {
        public long nrOfAllocs;
        public long nrOfEnters;
        public long nrOfBiasLockOperations;
        public long nrOfSameThreadLocks;
        public long nrOfNeverObjects;
        public long nrOfFullyBiasableObjects;
        public long nrOfNonBiasedLockOps;
        public long nrOfRevokes;
        public long maxBiasableAtFullGc;
        public long nrOfGcUnbiased;
        public long nrOfInitialBiasingLockOps;
        public long nrOfNotFullyBiasableObjects;
        public long nrOfBulkRebiases;
        public long nrOfBulkRevokes;
        public long nrOfInitialLocks;

        public void addObjectInfo(ObjectInfo info) {
            int nrOfLocks = info.nrOfBiasedLockOps + info.nrOfNonBiasedLockOps;
            boolean fullyBiased = nrOfLocks > 0 && info.nrOfNonBiasedLockOps == 0;
            ++this.nrOfAllocs;
            this.nrOfEnters += (long)nrOfLocks;
            this.nrOfBiasLockOperations += (long)info.nrOfBiasedLockOps;
            this.nrOfInitialBiasingLockOps += (long)info.nrOfInitialBiasingLocks;
            this.nrOfSameThreadLocks += (long)info.nrOfSameThreadLockOps;
            this.nrOfNeverObjects += nrOfLocks == 0 ? 1L : 0L;
            this.nrOfFullyBiasableObjects += fullyBiased ? 1L : 0L;
            this.nrOfNonBiasedLockOps += (long)info.nrOfNonBiasedLockOps;
            this.nrOfRevokes += (long)info.nrOfRevokes;
            this.nrOfGcUnbiased += (long)info.nrOfUnbiasedAtFullGc;
            this.nrOfNotFullyBiasableObjects += info.nrOfNonBiasedLockOps > 0 ? 1L : 0L;
            this.nrOfBulkRebiases += (long)info.nrOfBulkRebiases;
            this.nrOfBulkRevokes += (long)info.nrOfBulkRevokes;
            this.nrOfInitialLocks += nrOfLocks > 0 ? 1L : 0L;
        }

        public void print(PrintStream st) {
            st.println("Number of allocations: " + this.nrOfAllocs);
            st.println("Number of lock operations: " + this.nrOfEnters);
            st.format("Number of same thread lock operations: %d (%.2f%% of lock ops)", this.nrOfSameThreadLocks, (double)this.nrOfSameThreadLocks * 100.0 / (double)this.nrOfEnters);
            st.println();
            st.format("Number of initial lock operations: %d (%.2f%% of lock ops)", this.nrOfInitialLocks, (double)this.nrOfInitialLocks * 100.0 / (double)this.nrOfEnters);
            st.println();
            st.format("Number of biased lock operations: %d (%.2f%% of lock ops)", this.nrOfBiasLockOperations, (double)this.nrOfBiasLockOperations * 100.0 / (double)this.nrOfEnters);
            st.println();
            st.format("Number of initial biasing lock operations: %d (%.2f%% of lock ops)", this.nrOfInitialBiasingLockOps, (double)this.nrOfInitialBiasingLockOps * 100.0 / (double)this.nrOfEnters);
            st.println();
            st.format("Number of non biased lock operations: %d (%.2f%% of lock ops)", this.nrOfNonBiasedLockOps, (double)this.nrOfNonBiasedLockOps * 100.0 / (double)this.nrOfEnters);
            st.println();
            st.format("Number of objects bulk rebiased: %d", this.nrOfBulkRebiases);
            st.println();
            st.format("Number of never locked objects: %d (%.2f%% of objs)", this.nrOfNeverObjects, (double)this.nrOfNeverObjects * 100.0 / (double)this.nrOfAllocs);
            st.println();
            st.format("Number of fully biasable objects: %d (%.2f%% of objs)", this.nrOfFullyBiasableObjects, (double)this.nrOfFullyBiasableObjects * 100.0 / (double)this.nrOfAllocs);
            st.println();
            st.format("Number of not fully biasable objects: %d (%.2f%% of obj)", this.nrOfNotFullyBiasableObjects, (double)this.nrOfNotFullyBiasableObjects * 100.0 / (double)this.nrOfAllocs);
            st.println();
            st.println("Number of revokes: " + this.nrOfRevokes);
            st.println("Number of objects bulk revoked: " + this.nrOfBulkRevokes);
            st.println("Number of objects bulk rebiased: " + this.nrOfBulkRebiases);
            st.println("Max biasable objects at full GC: " + this.maxBiasableAtFullGc);
            st.println("Number of objects unbiased at full GC: " + this.nrOfGcUnbiased);
        }
    }

    public static class Config {
        public boolean allocAsBiased;
        public boolean hashCodeRevokes;
        public boolean debiasAtFullGc;
        public boolean useLocationAsSite;
        public boolean blackListPerClassDoesBulkRevokes;
        public boolean blackListPerSiteDoesBulkRevokes;
        public boolean allocNonBiasedInInterpreter;
        public int blackListPerClassThreashold;
        public int blackListPerSiteThreshold;
        public int bulkRebiasPerClassThreashold;
        public int bulkRebiasPerSiteThreshold;
        public int blackListerClassResetLockCount;
        public int blackListSiteResetLockCount;
        public int classResetRevokeCount;
        public int siteResetRevokeCount;
    }

    public static enum RevokeCause {
        LOCK,
        HASH_CODE;

    }
}

