/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.internal;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.event.ThreadStarted;
import com.sap.jvm.profiling.core.event.ThreadStopped;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.ClassObjectManager;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.core.type.StackTraceManager;
import com.sap.jvm.profiling.memory.event.AllocationEvent;
import com.sap.jvm.profiling.memory.event.ObjectDeathEvent;
import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.method.parameters.LongParameter;
import com.sap.jvm.profiling.method.parameters.MethodParameters;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.parameters.ParameterType;
import com.sap.jvm.profiling.sync.event.MonitorSlowEnterEvent;
import com.sap.jvm.profiling.tools.GenericPacketReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;

public class BiasedLockingStatsPerAllocationSite {
    private static HashMap<Integer, AllocationSite> allocationSites = new HashMap();
    private static boolean ignorehash;
    private static boolean sortbyid;
    private static String prfFile;
    private static final boolean printlnDebugging = false;

    private static boolean processArgs(String[] args) {
        if (args.length == 0) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-ignorehash")) {
                ignorehash = true;
                continue;
            }
            if (args[i].equals("-sortbyid")) {
                sortbyid = true;
                continue;
            }
            if (args[i].endsWith(".prf")) {
                prfFile = args[i];
                if (new File(prfFile).exists()) continue;
                System.out.println("");
                System.out.println("ERROR: \"" + args[i] + "\" does not exist.");
                System.out.println("");
                return false;
            }
            System.out.println("");
            System.out.println("ERROR: unknown option \"" + args[i] + "\"");
            System.out.println("");
            return false;
        }
        return prfFile != null;
    }

    public static void main(String[] args) throws IOException {
        if (!BiasedLockingStatsPerAllocationSite.processArgs(args)) {
            System.out.println("command line parameters: [-ignorehash] [-sortbyid] <prf file>");
            System.out.println();
            System.out.println("This tool can be used to analyze which allocation sites potentially");
            System.out.println("benefit from biased locking.");
            System.out.println("");
            System.out.println("It interprets a profiling trace with allocation and lock events and");
            System.out.println("accounts the different types of lock aquires at the site where the");
            System.out.println("object that holds the lock was allocated.");
            System.out.println("");
            System.out.println("Depending on the number of revokes and the count of biased and non");
            System.out.println("biased lock acquires each allocation site is given a score.");
            System.out.println("A report with all allocation sites ordered by their scores is");
            System.out.println("printed.");
            System.out.println("");
            System.out.println("Generation of identity hash codes (ID hash) and biased locking");
            System.out.println("interfere. An object that holds an ID hash is excluded from biased");
            System.out.println("locking. To analyze the effect of ID hashes, generate one report");
            System.out.println("with the options -ignorehash -sortbyid and another without");
            System.out.println("-ignorehash. Then diff the reports.");
            System.out.println("");
            System.out.println("https://wiki.wdf.sap.corp/wiki/display/SAPJVM/Biased+Locking");
            System.out.println("describes how to generate the prf file.");
            return;
        }
        long tsStart = System.currentTimeMillis();
        HashMap<Long, ThreadStarted> anonBiased = new HashMap<Long, ThreadStarted>();
        HashMap<Long, BiasInfo> biased = new HashMap<Long, BiasInfo>();
        HashMap<Long, AllocationEvent> neutral = new HashMap<Long, AllocationEvent>();
        HashSet<Long> hashed = new HashSet<Long>();
        long nrOfAllocs = 0L;
        long nrOfObjsWithHash = 0L;
        long nrOfSuccessfulBiasedAcquires = 0L;
        long nrOfRevokes = 0L;
        long nrOfEnters = 0L;
        long nrOfHashEnters = 0L;
        long nrOfHashCodeCalls = 0L;
        long nrOfUnknownMptCalls = 0L;
        long nrOfNullMptCalls = 0L;
        String[] threadNames = new String[65536];
        GenericPacketReader reader = new GenericPacketReader(prfFile);
        ProfilingPacket packet = null;
        while ((packet = reader.nextPacket()) != null) {
            Long id;
            ThreadStarted event;
            if (packet instanceof ThreadStarted) {
                event = (ThreadStarted)packet;
                threadNames[event.getThreadIndex()] = event.getName().toString();
                continue;
            }
            if (packet instanceof ThreadStopped) {
                event = (ThreadStopped)packet;
                threadNames[event.getThreadIndex()] = null;
                continue;
            }
            if (packet instanceof AllocationEvent) {
                event = (AllocationEvent)packet;
                assert (!anonBiased.containsKey(event.getObjectId()));
                anonBiased.put(event.getObjectId(), event);
                BiasedLockingStatsPerAllocationSite.getAllocSite((AllocationEvent)event).incAllocations();
                ++nrOfAllocs;
                continue;
            }
            if (packet instanceof ObjectDeathEvent) {
                event = (ObjectDeathEvent)packet;
                id = event.getObjectId();
                assert (id != 0L);
                if (anonBiased.remove(id) == null) {
                    if (biased.remove(id) != null) {
                        assert (neutral.remove(id) == null);
                        continue;
                    }
                    neutral.remove(id);
                    hashed.remove(id);
                    continue;
                }
                assert (neutral.remove(id) == null);
                assert (biased.remove(id) == null);
                assert (!hashed.contains(id));
                continue;
            }
            if (packet instanceof MonitorSlowEnterEvent) {
                event = (MonitorSlowEnterEvent)packet;
                id = event.getObjectId();
                ++nrOfEnters;
                assert (id != 0L);
                AllocationEvent lockee = (AllocationEvent)anonBiased.remove(id);
                if (lockee != null) {
                    assert (!biased.containsKey(id));
                    assert (!hashed.contains(id));
                    biased.put(id, new BiasInfo(lockee, event.getThreadIndex()));
                    BiasedLockingStatsPerAllocationSite.getAllocSite(lockee).incNotBiasedAcquireCount();
                    continue;
                }
                BiasInfo biasInfo = (BiasInfo)biased.remove(id);
                if (biasInfo != null) {
                    lockee = biasInfo.getBiasedObject();
                    assert (!hashed.contains(id));
                    if (biasInfo.getThreadIndex() == event.getThreadIndex()) {
                        biased.put(id, biasInfo);
                        ++nrOfSuccessfulBiasedAcquires;
                        BiasedLockingStatsPerAllocationSite.getAllocSite(lockee).incBiasedAcquireCount();
                        continue;
                    }
                    assert (!neutral.containsKey(id));
                    neutral.put(id, lockee);
                    ++nrOfRevokes;
                    BiasedLockingStatsPerAllocationSite.getAllocSite(lockee).incNotBiasedAcquireCount();
                    BiasedLockingStatsPerAllocationSite.getAllocSite(lockee).incRevokes();
                    continue;
                }
                lockee = (AllocationEvent)neutral.get(id);
                if (lockee != null) {
                    BiasedLockingStatsPerAllocationSite.getAllocSite(lockee).incNotBiasedAcquireCount();
                    if (!hashed.contains(id)) continue;
                    ++nrOfHashEnters;
                    continue;
                }
                --nrOfEnters;
                continue;
            }
            if (ignorehash || !(packet instanceof MethodParameterEntryEvent)) continue;
            event = (MethodParameterEntryEvent)packet;
            MethodParameters parameters = event.getParameters();
            String method = parameters.getMethod().getFullName();
            if ("java.lang.Object.hashCode()int".equals(method) || "java.lang.System.identityHashCode(java.lang.Object)int".equals(method)) {
                assert (parameters.getNrOfParameters() == 1);
                Parameter param = parameters.getParameter(0);
                if (param.getType() == ParameterType.LONG) {
                    LongParameter value = (LongParameter)param;
                    Long id2 = value.asLong();
                    ++nrOfHashCodeCalls;
                    if (hashed.contains(id2)) continue;
                    hashed.add(id2);
                    AllocationEvent obj = (AllocationEvent)anonBiased.remove(id2);
                    if (obj != null) {
                        assert (!neutral.containsKey(id2));
                        neutral.put(id2, obj);
                    } else {
                        BiasInfo biasInfo = (BiasInfo)biased.remove(id2);
                        if (biasInfo != null) {
                            obj = biasInfo.getBiasedObject();
                            assert (!neutral.containsKey(id2));
                            neutral.put(id2, obj);
                            ++nrOfRevokes;
                            BiasedLockingStatsPerAllocationSite.getAllocSite(obj).incRevokes();
                        } else if (neutral.containsKey(id2)) {
                            obj = (AllocationEvent)neutral.get(id2);
                        }
                    }
                    if (null == obj) continue;
                    BiasedLockingStatsPerAllocationSite.getAllocSite(obj).incObjsWithHash();
                    ++nrOfObjsWithHash;
                    continue;
                }
                assert (param.getType() == ParameterType.NULL_INVOCATION_DURING_CALL);
                ++nrOfNullMptCalls;
                continue;
            }
            ++nrOfUnknownMptCalls;
        }
        assert (BiasedLockingStatsPerAllocationSite.consistencyCheck(nrOfAllocs, nrOfObjsWithHash, nrOfEnters, nrOfSuccessfulBiasedAcquires, nrOfRevokes));
        System.out.println();
        System.out.println("Nr. of allocations                : " + nrOfAllocs);
        System.out.println("Nr. of successful biased acquires : " + nrOfSuccessfulBiasedAcquires);
        System.out.println("Nr. of bias revokes               : " + nrOfRevokes);
        System.out.println("Nr. of enter events               : " + nrOfEnters);
        System.out.println("Nr. of objects with hash code     : " + nrOfObjsWithHash);
        System.out.println("Nr. of hash code calls            : " + nrOfHashCodeCalls);
        System.out.println("Nr. of hashed enters              : " + nrOfHashEnters);
        System.out.println("Nr. of MPT calls with null param  : " + nrOfNullMptCalls);
        System.out.println("Nr. of unknown MPT calls          : " + nrOfUnknownMptCalls);
        System.out.println();
        System.out.println();
        BiasedLockingStatsPerAllocationSite.dumpSites(allocationSites, reader.getSession());
        long tsEnd = System.currentTimeMillis();
        System.out.println();
        System.out.println();
        System.out.println("This took " + (tsEnd - tsStart) + "ms");
    }

    private static boolean consistencyCheck(long nrOfAllocs, long nrOfObjsWithHash, long nrOfEnters, long nrOfSuccessfulBiasedAcquires, long nrOfRevokes) {
        long totalAcquires = 0L;
        long totalBiasedAcquires = 0L;
        long totalRevokes = 0L;
        long totalAllocs = 0L;
        long totalObjsWithHash = 0L;
        for (AllocationSite site : new ArrayList<AllocationSite>(allocationSites.values())) {
            totalAcquires += site.sumOfAcquires();
            totalBiasedAcquires += site.biasedLockAcquires;
            totalRevokes += site.revokes;
            totalAllocs += site.allocations;
            totalObjsWithHash += site.objsWithHash;
        }
        assert (totalAcquires == nrOfEnters);
        assert (totalBiasedAcquires == nrOfSuccessfulBiasedAcquires);
        assert (totalRevokes == nrOfRevokes);
        assert (totalAllocs == nrOfAllocs);
        assert (totalObjsWithHash == nrOfObjsWithHash);
        return true;
    }

    private static void dumpSites(HashMap<Integer, AllocationSite> map, ProfilingSession session) {
        ArrayList<AllocationSite> sites = new ArrayList<AllocationSite>(map.values());
        Collections.sort(sites, new Comparator<AllocationSite>(){

            @Override
            public int compare(AllocationSite o1, AllocationSite o2) {
                return sortbyid ? o2.stackIndex - o1.stackIndex : o2.getScore() - o1.getScore();
            }
        });
        ClassObjectManager classManager = session.getClassObjectManager();
        StackTraceManager stackManager = session.getStackTraceManager();
        StackFrames frames = stackManager.getStackFramesObject(true);
        System.out.println("Allocation sites (with at least 1 lock operation):");
        System.out.println("B=Biased Lock Acquires (i.e. CAS free), N=Non Biased Lock Acquires, R=Revokes, A=Allocations, H=Objects w/ hash");
        System.out.println();
        for (AllocationSite site : sites) {
            if (site.sumOfAcquires() == 0L) continue;
            frames.fillIn(site.stackIndex);
            ClassObject clazz = classManager.getClassObject(site.classIndex);
            if (frames.getNrOfFrames() < 1) continue;
            System.out.printf("%8d B %8d N %5d R %6d A %8d H score %8d : ", site.biasedLockAcquires, site.nonBiasedLockAcquires, site.revokes, site.allocations, site.objsWithHash, site.getScore());
            System.out.println(frames.getMethodLocation(0));
            System.out.println("                                                                   Class " + clazz);
        }
    }

    private static AllocationSite getAllocSite(AllocationEvent alloc) {
        int stackTraceIdx = alloc.getStackTraceIndex();
        AllocationSite site = allocationSites.get(stackTraceIdx);
        if (null == site) {
            site = new AllocationSite(alloc.getClassObject().getIndex(), stackTraceIdx);
            allocationSites.put(stackTraceIdx, site);
        }
        return site;
    }

    public static class BiasInfo {
        private AllocationEvent alloc;
        private char threadIndex;

        public BiasInfo(AllocationEvent alloc, char threadIndex) {
            this.alloc = alloc;
            this.threadIndex = threadIndex;
        }

        public AllocationEvent getBiasedObject() {
            return this.alloc;
        }

        public char getThreadIndex() {
            return this.threadIndex;
        }
    }

    public static class AllocationSite {
        public final int classIndex;
        public final int stackIndex;
        public long biasedLockAcquires;
        public long nonBiasedLockAcquires;
        public long revokes;
        public long allocations;
        public long objsWithHash;

        public AllocationSite(int classIndex, int stackIndex) {
            this.classIndex = classIndex;
            this.stackIndex = stackIndex;
        }

        public void incBiasedAcquireCount() {
            ++this.biasedLockAcquires;
        }

        public void incNotBiasedAcquireCount() {
            ++this.nonBiasedLockAcquires;
        }

        public void incRevokes() {
            ++this.revokes;
        }

        public void incAllocations() {
            ++this.allocations;
        }

        public void incObjsWithHash() {
            ++this.objsWithHash;
        }

        public int getScore() {
            return (int)(this.biasedLockAcquires / (this.revokes + 1L));
        }

        public long sumOfAcquires() {
            return this.biasedLockAcquires + this.nonBiasedLockAcquires;
        }
    }
}

