/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.internal;

import com.sap.jvm.util.persistence.ProfilingInputStream;
import com.sap.jvm.util.persistence.ProfilingPacketTags;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;

public class BinaryPacketDumper {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Dumps all packets in the given profiling file in binary format.");
            System.out.println("Can be used to filter out specific kinds of packets.");
            System.out.println();
            System.out.println("Syntax: PacketDumper <input> <output> [<packet index> ...]");
            System.out.println();
            System.out.println("<packet index>: If at least one is given we dump only packets");
            System.out.println("              : which matches one index.");
            System.exit(1);
        }
        if (args.length > 2) {
            boolean[] indicesToDump = new boolean[32768];
            for (int i = 2; i < args.length; ++i) {
                indicesToDump[Integer.parseInt((String)args[i])] = true;
            }
            BinaryPacketDumper.dumpPackets(args[0], args[1], indicesToDump);
        } else {
            boolean[] indicesToDump = new boolean[32768];
            for (int i = 0; i < indicesToDump.length; ++i) {
                indicesToDump[i] = true;
            }
            BinaryPacketDumper.dumpPackets(args[0], args[1], indicesToDump);
        }
    }

    private static void dumpPackets(String input, String output, boolean[] indicesToDump) throws IOException {
        int i;
        FileInputStream fis = new FileInputStream(input);
        BufferedInputStream bis = new BufferedInputStream(fis);
        ProfilingInputStream pis = new ProfilingInputStream((InputStream)bis);
        FileOutputStream fos = new FileOutputStream(output);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        byte[] header = new byte[4];
        byte[] data = new byte[65536];
        if (!BinaryPacketDumper.readFully(bis, header, 1)) {
            pis.close();
            bos.close();
            return;
        }
        bos.write(header, 0, 1);
        if (!BinaryPacketDumper.readFully(bis, header, 4)) {
            pis.close();
            bos.close();
            return;
        }
        bos.write(header, 0, 4);
        if (!BinaryPacketDumper.readFully(bis, header, 2)) {
            pis.close();
            bos.close();
            return;
        }
        bos.write(header, 0, 2);
        int toSkip = ((header[0] & 0xFF) << 8) + (header[1] & 0xFF) - 7;
        if (!BinaryPacketDumper.readFully(bis, data, toSkip)) {
            pis.close();
            bos.close();
            return;
        }
        bos.write(data, 0, toSkip);
        long[] nrFound = new long[32768];
        while (BinaryPacketDumper.readFully((InputStream)pis, header, header.length)) {
            int type = ((header[0] & 0xFF) << 8) + (header[1] & 0xFF);
            int size = ((header[2] & 0xFF) << 8) + (header[3] & 0xFF);
            if (!BinaryPacketDumper.readFully((InputStream)pis, data, size - 4)) break;
            if (type < 32768) {
                int n = type;
                nrFound[n] = nrFound[n] + 1L;
            }
            if (!indicesToDump[type & Short.MAX_VALUE]) continue;
            bos.write(header);
            bos.write(data, 0, size - 4);
        }
        for (i = 0; i < 32768; ++i) {
            if (nrFound[i] <= 0L || !indicesToDump[i]) continue;
            System.out.println("Found and dumped " + nrFound[i] + " packets of type " + i + BinaryPacketDumper.getTagName(i));
        }
        for (i = 0; i < 32768; ++i) {
            if (nrFound[i] <= 0L || indicesToDump[i]) continue;
            System.out.println("Found but ignored " + nrFound[i] + " packets of type " + i + BinaryPacketDumper.getTagName(i));
        }
        pis.close();
        bos.close();
    }

    private static boolean readFully(InputStream is, byte[] buffer, int len) throws IOException {
        int offset = 0;
        int toRead = len;
        while (toRead > 0) {
            int read = is.read(buffer, offset, toRead);
            if (read > 0) {
                toRead -= read;
                offset += read;
                continue;
            }
            return false;
        }
        return true;
    }

    private static String getTagName(int tag) {
        try {
            Field[] fields;
            for (Field field : fields = ProfilingPacketTags.class.getDeclaredFields()) {
                if (field.getInt(null) != tag) continue;
                return " (" + field.getName() + ")";
            }
            return "";
        }
        catch (IllegalAccessException e) {
            return "";
        }
    }
}

