/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.Arrays;
import java.util.HashSet;

class CloneClassLoader
extends SecureClassLoader {
    public static final int CHUNK_SIZE = 0x100000;
    private final ClassLoader toClone;
    private final HashSet<String> notLoadable;

    private static byte[] readStreamIntoBuffer(InputStream is, int chunkSize) throws IOException {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize <= 0");
        }
        if (is == null) {
            throw new NullPointerException("is is null");
        }
        byte[] tempBuffer = new byte[chunkSize];
        byte[] buffer = new byte[]{};
        int bytesRead = 0;
        int oldSize = 0;
        while ((bytesRead = is.read(tempBuffer)) > 0) {
            byte[] oldBuffer = buffer;
            buffer = new byte[oldSize + bytesRead];
            System.arraycopy(oldBuffer, 0, buffer, 0, oldBuffer.length);
            System.arraycopy(tempBuffer, 0, buffer, oldSize, bytesRead);
            oldSize += bytesRead;
        }
        return buffer;
    }

    private static byte[] readStreamIntoBuffer(InputStream is) throws IOException {
        return CloneClassLoader.readStreamIntoBuffer(is, 0x100000);
    }

    public CloneClassLoader(ClassLoader toClone, String ... notLoadable) {
        this(null, toClone, notLoadable);
    }

    public CloneClassLoader(ClassLoader parent, ClassLoader toClone, String ... notLoadable) {
        super(parent);
        this.toClone = toClone;
        this.notLoadable = new HashSet<String>(Arrays.asList(notLoadable));
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.notLoadable.contains(name)) {
            throw new ClassNotFoundException("The clone class loader explicitely didn't found the class");
        }
        URL res = this.toClone.getResource(name.replace('.', '/') + ".class");
        if (res == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            byte[] code = CloneClassLoader.readStreamIntoBuffer(res.openStream());
            return this.defineClass(name, code, 0, code.length);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }
}

