/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.internal;

import com.sap.jvm.profiling.OfflineProfilingSession;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.DetailedProfilingPrintStream;
import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.method.event.MethodParameterExitEvent;
import com.sap.jvm.profiling.method.parameters.MethodParameters;
import java.io.IOException;

public class DebugEventsAndModelChanges {
    public static void main(String[] args) throws IOException {
        ProfilingPacket packet;
        OfflineProfilingSession session = ProfilingFactory.createSession((String)args[0]);
        ProfilingReader reader = session.getReader();
        DetailedProfilingPrintStream stream = new DetailedProfilingPrintStream(System.out, 4, 1000, (ProfilingSession)session);
        boolean start = true;
        boolean doStack = true;
        while ((packet = reader.nextPacket()) != null) {
            MethodParameterExitEvent event;
            MethodParameters params;
            if (packet instanceof MethodParameterEntryEvent) {
                MethodParameterEntryEvent entry = (MethodParameterEntryEvent)packet;
                params = entry.getParameters();
                if ("handleDebugEvents".equals(params.getMethod().getName())) {
                    String val = params.getParameter(0).toString();
                    if (!start && val.contains("SapJvmDebugTarget")) {
                        start = true;
                    }
                    if (start) {
                        System.out.println(val);
                        if (doStack) {
                            stream.formatln("%*S", new Object[]{entry.getStackTraceIndex()});
                            stream.flush();
                        }
                    }
                } else if ("fireDelta".equals(params.getMethod().getName()) && start) {
                    System.out.println(params.getParameter(0));
                    if (doStack) {
                        stream.formatln("%*S", new Object[]{entry.getStackTraceIndex()});
                        stream.flush();
                    }
                }
            }
            if (!(packet instanceof MethodParameterExitEvent) || !"getSelection".equals((params = (event = (MethodParameterExitEvent)packet).getParameters()).getMethod().getName())) continue;
            System.out.println(params.getParameter(0));
            if (!doStack) continue;
            stream.formatln("%*S", new Object[]{event.getStackTraceIndex()});
            stream.flush();
        }
    }
}

