/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.internal;

import com.sap.jvm.internal.util.cmdline.CommandLineParser;
import com.sap.jvm.profiling.OfflineProfilingSession;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.NonArrayClassObject;
import com.sap.jvm.profiling.method.event.MethodCoverageEvent;
import java.io.FileNotFoundException;
import java.io.IOException;

public class MethodCoverageConverter {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Converts the method coverage trace stored in a profiling file into a");
            System.out.println("human readable text format.");
            System.out.println();
            System.out.println("Syntax: MethodCoverageConverter [-i] [-n] <profiling-file>");
            System.out.println();
            System.out.println("Options:");
            System.out.println("-i: Print class loader id for each method's class");
            System.out.println("-n: Print class loader name for each method's class");
            System.exit(1);
        }
        CommandLineParser.OptionalSwitch idOption = new CommandLineParser.OptionalSwitch("i", "with-class-loader-id");
        CommandLineParser.OptionalSwitch nameOption = new CommandLineParser.OptionalSwitch("n", "with-class-loader-name");
        CommandLineParser.Option[] options = new CommandLineParser.Option[]{idOption, nameOption};
        CommandLineParser parser = new CommandLineParser(args, options, false);
        String[] unparsedStrings = parser.getRemainingArguments();
        if (unparsedStrings.length == 0) {
            System.err.println("Profiling file missing");
            System.exit(1);
        }
        if (unparsedStrings.length > 1) {
            System.err.println("Only one profiling file allowed");
            System.exit(1);
        }
        MethodCoverageConverter.convertToText(unparsedStrings[0], parser.isOptionSet("i"), parser.isOptionSet("n"));
    }

    private static void convertToText(String fileName, boolean printClassLoaderId, boolean printClassLoaderName) throws FileNotFoundException, IOException {
        ProfilingPacket packet;
        OfflineProfilingSession session = ProfilingFactory.createSession((String)fileName);
        ProfilingReader reader = session.getReader();
        while ((packet = reader.nextPacket()) != null) {
            if (packet.getType() != ProfilingPacketType.METHOD_COVERAGE_EVENT) continue;
            MethodCoverageEvent event = (MethodCoverageEvent)packet;
            MethodObject method = event.getMethodObject();
            NonArrayClassObject clazz = method.getMethodClass();
            ClassLoaderObject loader = clazz.getClassLoader();
            System.out.print(clazz.getFullName());
            System.out.print(':');
            System.out.print(method.getName());
            System.out.print('(');
            System.out.print(method.getSignature());
            System.out.print(')');
            if (printClassLoaderId) {
                System.out.print(':');
                System.out.print(loader.getId());
            }
            if (printClassLoaderName) {
                System.out.print(':');
                System.out.print(loader.toString());
            }
            System.out.println();
        }
    }
}

