/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.internal;

import com.sap.jvm.profiling.CommandHandler;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.api.VmProfiling;
import com.sap.jvm.profiling.control.command.ControlCommandFactory;
import com.sap.jvm.profiling.control.command.StopProfilingCommand;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.memory.command.AllocationTraceConfiguration;
import com.sap.jvm.profiling.memory.command.AllocationTraceType;
import com.sap.jvm.profiling.memory.command.MemoryCommandFactory;
import com.sap.jvm.profiling.tools.internal.CloneClassLoader;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;

public class StackTraceCreator {
    private static Class<?> classToAllocate;

    public static void main(String[] args) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (args.length < 2) {
            System.out.println("StackStressTest <prf-file> <type> [stop-explicitely] [args]");
            System.out.println();
            System.out.println("\"few-methods\" <min-frames> <max-frames> <nr-of-stacks>");
            System.out.println("\"few-methods-many-classes\" <min-frames> <max-frames> <nr-of-stacks> <nr-of-classes>");
            System.exit(1);
        }
        String fileName = args[0];
        OutputStream stream = VmProfiling.startProfiling((String)fileName);
        CommandHandler handler = ProfilingFactory.createCommandHandler((OutputStream)stream);
        ControlCommandFactory ctrlCmd = ProfilingFactory.createControlCommandFactory();
        MemoryCommandFactory memCmd = ProfilingFactory.createMemoryCommandFactory();
        StopProfilingCommand stopCommand = ctrlCmd.createStopProfilingCommand();
        int index = 3;
        if (args.length > 2 && !args[2].equals("stop-explicitely")) {
            stopCommand = null;
            --index;
        }
        if (args[1].equals("few-methods")) {
            AllocationTraceConfiguration config = new AllocationTraceConfiguration(AllocationTraceType.NO_OBJECT_IDS);
            config.setAllocatedObjectClassFilter(StackTraceCreator.class.getName());
            handler.sendCommand((Command)memCmd.createEnableAllocationTraceCommand(config));
            int minFrames = Integer.parseInt(args[index + 0]);
            int maxFrames = Integer.parseInt(args[index + 1]);
            int nrOfStacks = Integer.parseInt(args[index + 2]);
            StackTraceCreator.createFewMethodStackTraces(minFrames, maxFrames, nrOfStacks);
        } else if (args[1].equals("few-methods-many-classes")) {
            AllocationTraceConfiguration config = new AllocationTraceConfiguration(AllocationTraceType.NO_OBJECT_IDS);
            config.setAllocatedObjectClassFilter(StackTraceCreator.class.getName());
            handler.sendCommand((Command)memCmd.createEnableAllocationTraceCommand(config));
            int minFrames = Integer.parseInt(args[index + 0]);
            int maxFrames = Integer.parseInt(args[index + 1]);
            int nrOfStacks = Integer.parseInt(args[index + 2]);
            int nrOfClasses = Integer.parseInt(args[index + 3]);
            StackTraceCreator.createFewMethodManyClassesStackTraces(minFrames, maxFrames, nrOfStacks, nrOfClasses);
        }
        if (stopCommand != null) {
            handler.sendCommand((Command)stopCommand);
        }
        stream.close();
    }

    private static void createFewMethodManyClassesStackTraces(int minFrames, int maxFrames, int nrOfStacks, int nrOfClasses) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        double leftForThisClass = 0.0;
        for (int i = 0; i < nrOfStacks; ++i) {
            if (leftForThisClass <= 0.0) {
                CloneClassLoader cl = new CloneClassLoader(StackTraceCreator.class.getClassLoader(), new String[0]);
                classToAllocate = cl.loadClass(StackTraceCreator.class.getName());
                leftForThisClass += (double)nrOfStacks / (double)nrOfClasses;
            }
            leftForThisClass -= 1.0;
            int len = (int)(Math.random() * (double)(maxFrames - minFrames + 1)) + minFrames;
            int[] stack = new int[len];
            for (int j = 0; j < len; ++j) {
                stack[j] = (int)(Math.random() * 10.0);
            }
            StackTraceCreator.f0(0, stack);
        }
    }

    private static void createFewMethodStackTraces(int minFrames, int maxFrames, int nrOfStacks) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        classToAllocate = StackTraceCreator.class;
        for (int i = 0; i < nrOfStacks; ++i) {
            int len = (int)(Math.random() * (double)(maxFrames - minFrames + 1)) + minFrames;
            int[] stack = new int[len];
            for (int j = 0; j < len; ++j) {
                stack[j] = (int)(Math.random() * 10.0);
            }
            StackTraceCreator.f0(0, stack);
        }
    }

    private static Object f0(int i, int[] stack) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (i == stack.length) {
            if (classToAllocate != null) {
                return classToAllocate.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return new StackTraceCreator();
        }
        switch (stack[i]) {
            case 0: {
                return StackTraceCreator.f0(i + 1, stack);
            }
            case 1: {
                return StackTraceCreator.f1(i + 1, stack);
            }
            case 2: {
                return StackTraceCreator.f2(i + 1, stack);
            }
            case 3: {
                return StackTraceCreator.f3(i + 1, stack);
            }
            case 4: {
                return StackTraceCreator.f4(i + 1, stack);
            }
            case 5: {
                return StackTraceCreator.f5(i + 1, stack);
            }
            case 6: {
                return StackTraceCreator.f6(i + 1, stack);
            }
            case 7: {
                return StackTraceCreator.f7(i + 1, stack);
            }
            case 8: {
                return StackTraceCreator.f8(i + 1, stack);
            }
        }
        return StackTraceCreator.f9(i + 1, stack);
    }

    private static Object f1(int i, int[] stack) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (i == stack.length) {
            if (classToAllocate != null) {
                return classToAllocate.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return new StackTraceCreator();
        }
        switch (stack[i]) {
            case 0: {
                return StackTraceCreator.f0(i + 1, stack);
            }
            case 1: {
                return StackTraceCreator.f1(i + 1, stack);
            }
            case 2: {
                return StackTraceCreator.f2(i + 1, stack);
            }
            case 3: {
                return StackTraceCreator.f3(i + 1, stack);
            }
            case 4: {
                return StackTraceCreator.f4(i + 1, stack);
            }
            case 5: {
                return StackTraceCreator.f5(i + 1, stack);
            }
            case 6: {
                return StackTraceCreator.f6(i + 1, stack);
            }
            case 7: {
                return StackTraceCreator.f7(i + 1, stack);
            }
            case 8: {
                return StackTraceCreator.f8(i + 1, stack);
            }
        }
        return StackTraceCreator.f9(i + 1, stack);
    }

    private static Object f2(int i, int[] stack) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (i == stack.length) {
            if (classToAllocate != null) {
                return classToAllocate.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return new StackTraceCreator();
        }
        switch (stack[i]) {
            case 0: {
                return StackTraceCreator.f0(i + 1, stack);
            }
            case 1: {
                return StackTraceCreator.f1(i + 1, stack);
            }
            case 2: {
                return StackTraceCreator.f2(i + 1, stack);
            }
            case 3: {
                return StackTraceCreator.f3(i + 1, stack);
            }
            case 4: {
                return StackTraceCreator.f4(i + 1, stack);
            }
            case 5: {
                return StackTraceCreator.f5(i + 1, stack);
            }
            case 6: {
                return StackTraceCreator.f6(i + 1, stack);
            }
            case 7: {
                return StackTraceCreator.f7(i + 1, stack);
            }
            case 8: {
                return StackTraceCreator.f8(i + 1, stack);
            }
        }
        return StackTraceCreator.f9(i + 1, stack);
    }

    private static Object f3(int i, int[] stack) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (i == stack.length) {
            if (classToAllocate != null) {
                return classToAllocate.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return new StackTraceCreator();
        }
        switch (stack[i]) {
            case 0: {
                return StackTraceCreator.f0(i + 1, stack);
            }
            case 1: {
                return StackTraceCreator.f1(i + 1, stack);
            }
            case 2: {
                return StackTraceCreator.f2(i + 1, stack);
            }
            case 3: {
                return StackTraceCreator.f3(i + 1, stack);
            }
            case 4: {
                return StackTraceCreator.f4(i + 1, stack);
            }
            case 5: {
                return StackTraceCreator.f5(i + 1, stack);
            }
            case 6: {
                return StackTraceCreator.f6(i + 1, stack);
            }
            case 7: {
                return StackTraceCreator.f7(i + 1, stack);
            }
            case 8: {
                return StackTraceCreator.f8(i + 1, stack);
            }
        }
        return StackTraceCreator.f9(i + 1, stack);
    }

    private static Object f4(int i, int[] stack) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (i == stack.length) {
            if (classToAllocate != null) {
                return classToAllocate.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return new StackTraceCreator();
        }
        switch (stack[i]) {
            case 0: {
                return StackTraceCreator.f0(i + 1, stack);
            }
            case 1: {
                return StackTraceCreator.f1(i + 1, stack);
            }
            case 2: {
                return StackTraceCreator.f2(i + 1, stack);
            }
            case 3: {
                return StackTraceCreator.f3(i + 1, stack);
            }
            case 4: {
                return StackTraceCreator.f4(i + 1, stack);
            }
            case 5: {
                return StackTraceCreator.f5(i + 1, stack);
            }
            case 6: {
                return StackTraceCreator.f6(i + 1, stack);
            }
            case 7: {
                return StackTraceCreator.f7(i + 1, stack);
            }
            case 8: {
                return StackTraceCreator.f8(i + 1, stack);
            }
        }
        return StackTraceCreator.f9(i + 1, stack);
    }

    private static Object f5(int i, int[] stack) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (i == stack.length) {
            if (classToAllocate != null) {
                return classToAllocate.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return new StackTraceCreator();
        }
        switch (stack[i]) {
            case 0: {
                return StackTraceCreator.f0(i + 1, stack);
            }
            case 1: {
                return StackTraceCreator.f1(i + 1, stack);
            }
            case 2: {
                return StackTraceCreator.f2(i + 1, stack);
            }
            case 3: {
                return StackTraceCreator.f3(i + 1, stack);
            }
            case 4: {
                return StackTraceCreator.f4(i + 1, stack);
            }
            case 5: {
                return StackTraceCreator.f5(i + 1, stack);
            }
            case 6: {
                return StackTraceCreator.f6(i + 1, stack);
            }
            case 7: {
                return StackTraceCreator.f7(i + 1, stack);
            }
            case 8: {
                return StackTraceCreator.f8(i + 1, stack);
            }
        }
        return StackTraceCreator.f9(i + 1, stack);
    }

    private static Object f6(int i, int[] stack) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (i == stack.length) {
            if (classToAllocate != null) {
                return classToAllocate.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return new StackTraceCreator();
        }
        switch (stack[i]) {
            case 0: {
                return StackTraceCreator.f0(i + 1, stack);
            }
            case 1: {
                return StackTraceCreator.f1(i + 1, stack);
            }
            case 2: {
                return StackTraceCreator.f2(i + 1, stack);
            }
            case 3: {
                return StackTraceCreator.f3(i + 1, stack);
            }
            case 4: {
                return StackTraceCreator.f4(i + 1, stack);
            }
            case 5: {
                return StackTraceCreator.f5(i + 1, stack);
            }
            case 6: {
                return StackTraceCreator.f6(i + 1, stack);
            }
            case 7: {
                return StackTraceCreator.f7(i + 1, stack);
            }
            case 8: {
                return StackTraceCreator.f8(i + 1, stack);
            }
        }
        return StackTraceCreator.f9(i + 1, stack);
    }

    private static Object f7(int i, int[] stack) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (i == stack.length) {
            if (classToAllocate != null) {
                return classToAllocate.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return new StackTraceCreator();
        }
        switch (stack[i]) {
            case 0: {
                return StackTraceCreator.f0(i + 1, stack);
            }
            case 1: {
                return StackTraceCreator.f1(i + 1, stack);
            }
            case 2: {
                return StackTraceCreator.f2(i + 1, stack);
            }
            case 3: {
                return StackTraceCreator.f3(i + 1, stack);
            }
            case 4: {
                return StackTraceCreator.f4(i + 1, stack);
            }
            case 5: {
                return StackTraceCreator.f5(i + 1, stack);
            }
            case 6: {
                return StackTraceCreator.f6(i + 1, stack);
            }
            case 7: {
                return StackTraceCreator.f7(i + 1, stack);
            }
            case 8: {
                return StackTraceCreator.f8(i + 1, stack);
            }
        }
        return StackTraceCreator.f9(i + 1, stack);
    }

    private static Object f8(int i, int[] stack) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (i == stack.length) {
            if (classToAllocate != null) {
                return classToAllocate.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return new StackTraceCreator();
        }
        switch (stack[i]) {
            case 0: {
                return StackTraceCreator.f0(i + 1, stack);
            }
            case 1: {
                return StackTraceCreator.f1(i + 1, stack);
            }
            case 2: {
                return StackTraceCreator.f2(i + 1, stack);
            }
            case 3: {
                return StackTraceCreator.f3(i + 1, stack);
            }
            case 4: {
                return StackTraceCreator.f4(i + 1, stack);
            }
            case 5: {
                return StackTraceCreator.f5(i + 1, stack);
            }
            case 6: {
                return StackTraceCreator.f6(i + 1, stack);
            }
            case 7: {
                return StackTraceCreator.f7(i + 1, stack);
            }
            case 8: {
                return StackTraceCreator.f8(i + 1, stack);
            }
        }
        return StackTraceCreator.f9(i + 1, stack);
    }

    private static Object f9(int i, int[] stack) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (i == stack.length) {
            if (classToAllocate != null) {
                return classToAllocate.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return new StackTraceCreator();
        }
        switch (stack[i]) {
            case 0: {
                return StackTraceCreator.f0(i + 1, stack);
            }
            case 1: {
                return StackTraceCreator.f1(i + 1, stack);
            }
            case 2: {
                return StackTraceCreator.f2(i + 1, stack);
            }
            case 3: {
                return StackTraceCreator.f3(i + 1, stack);
            }
            case 4: {
                return StackTraceCreator.f4(i + 1, stack);
            }
            case 5: {
                return StackTraceCreator.f5(i + 1, stack);
            }
            case 6: {
                return StackTraceCreator.f6(i + 1, stack);
            }
            case 7: {
                return StackTraceCreator.f7(i + 1, stack);
            }
            case 8: {
                return StackTraceCreator.f8(i + 1, stack);
            }
        }
        return StackTraceCreator.f9(i + 1, stack);
    }
}

