/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.internal;

import com.sap.jvm.profiling.impl.util.ProfilingFileInputStream;
import com.sap.jvm.profiling.impl.util.ProfilingInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class UnpackPrf {
    public static void main(String[] args) throws Exception {
        int read;
        if (args.length != 2) {
            System.out.println("Unpacks the fiven prf file. The result file is not a valid profiling file.");
            System.out.println("Syntax: UnpackPrf <input> <output> ");
            System.exit(1);
        }
        ProfilingInputStream pis = new ProfilingInputStream((InputStream)new ProfilingFileInputStream(args[0]));
        FileOutputStream fos = new FileOutputStream(args[1]);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        byte[] data = new byte[65536];
        bos.write(2);
        while ((read = UnpackPrf.readFully((InputStream)pis, data, data.length)) > 0) {
            bos.write(data, 0, read);
        }
        bos.close();
    }

    private static int readFully(InputStream is, byte[] buffer, int len) throws IOException {
        int offset = 0;
        int toRead = len;
        while (toRead > 0) {
            int read = is.read(buffer, offset, toRead);
            if (read > 0) {
                toRead -= read;
                offset += read;
                continue;
            }
            return offset;
        }
        return offset;
    }
}

