/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.internal.alloctrace;

import com.sap.jvm.internal.util.cmdline.CommandLineParser;
import com.sap.jvm.monitor.vm.VmTrace;
import com.sap.jvm.monitor.vm.VmTraceFlag;
import com.sap.jvm.profiling.OfflineProfilingSession;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.memory.event.AllocationEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class AllocationTraceSummary {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Provides a summary of the allocation trace store in the given profiling file.");
            System.out.println();
            System.out.println("Syntax: AllocationTraceSummary [options] <profiling-file>");
            System.out.println();
            System.out.println("Options:");
            System.out.println("-a: Count the number of different allocation sites");
            System.out.println("-c: Print a class histogram of the allocated objects");
            System.out.println("-h: Print class histogram");
            System.out.println("-s: Count the number of different stack traces");
            System.out.println("-S: Print each stack trace");
            System.exit(1);
        }
        CommandLineParser.OptionalSwitch histoOption = new CommandLineParser.OptionalSwitch("c", "with-class-histogram");
        CommandLineParser.OptionalSwitch siteCountOption = new CommandLineParser.OptionalSwitch("a", "with-allocation-site-count");
        CommandLineParser.OptionalSwitch stackTraceCountOption = new CommandLineParser.OptionalSwitch("s", "with-stack-trace-count");
        CommandLineParser.OptionalSwitch stackTracePrintOption = new CommandLineParser.OptionalSwitch("S", "print-stack-trace");
        CommandLineParser.OptionalSwitch printClassHistogram = new CommandLineParser.OptionalSwitch("h", "print-class-histogram");
        CommandLineParser.Option[] options = new CommandLineParser.Option[]{histoOption, siteCountOption, stackTraceCountOption, stackTracePrintOption, printClassHistogram};
        CommandLineParser parser = new CommandLineParser(args, options, false);
        String[] unparsedStrings = parser.getRemainingArguments();
        if (unparsedStrings.length == 0) {
            System.err.println("Profiling file missing");
            System.exit(1);
        }
        if (unparsedStrings.length > 1) {
            System.err.println("Only one profiling file allowed");
            System.exit(1);
        }
        AllocationTraceSummary.convertToText(unparsedStrings[0], parser.isOptionSet("c"), parser.isOptionSet("s"), parser.isOptionSet("S"), parser.isOptionSet("a"), parser.isOptionSet("h"));
    }

    private static void convertToText(String fileName, boolean doHistogram, boolean countStackTraces, boolean printStackTraces, boolean countAllocationSites, boolean printClassHistogram) throws IOException {
        ProfilingPacket packet;
        OfflineProfilingSession session = ProfilingFactory.createSession((String)fileName);
        ProfilingReader reader = session.getReader();
        long nrOfNonArrays = 0L;
        long sizeOfNonArrays = 0L;
        long nrOfArrays = 0L;
        long sizeOfArrays = 0L;
        long stackTraceSize = 0L;
        int maxStackSize = 0;
        HashMap<ClassObject, Long> classesBySize = new HashMap<ClassObject, Long>();
        HashMap<ClassObject, Long> classesByNr = new HashMap<ClassObject, Long>();
        HashSet<AllocationSite> allocationSites = new HashSet<AllocationSite>();
        HashSet<Integer> stackTraces = new HashSet<Integer>();
        HashSet<MethodLocationPair> pairs = new HashSet<MethodLocationPair>();
        HashSet<MethodLocationTriple> triples = new HashSet<MethodLocationTriple>();
        HashSet<MethodLocationQuadrupel> quadrupels = new HashSet<MethodLocationQuadrupel>();
        long startTime = System.currentTimeMillis();
        StackFrames frames = session.getStackTraceManager().getStackFramesObject(true);
        while ((packet = reader.nextPacket()) != null) {
            if (!(packet instanceof AllocationEvent)) continue;
            AllocationEvent event = (AllocationEvent)packet;
            frames.fillIn(event.getStackTraceIndex());
            int stackSize = frames.getNrOfFrames();
            stackTraceSize += (long)(stackSize * event.getNrOfAllocations());
            maxStackSize = Math.max(maxStackSize, stackSize);
            if (event.getClassObject().getArrayDimension() == 0) {
                nrOfNonArrays += (long)event.getNrOfAllocations();
                sizeOfNonArrays += event.getSize() * (long)event.getNrOfAllocations();
            } else {
                nrOfArrays += (long)event.getNrOfAllocations();
                sizeOfArrays += event.getSize() * (long)event.getNrOfAllocations();
            }
            if (doHistogram) {
                ClassObject classObject = event.getClassObject();
                if (classesBySize.containsKey(classObject)) {
                    classesBySize.put(classObject, (Long)classesBySize.get(classObject) + event.getSize());
                    classesByNr.put(classObject, (Long)classesByNr.get(classObject) + 1L);
                } else {
                    classesBySize.put(classObject, event.getSize());
                    classesByNr.put(classObject, 1L);
                }
            }
            if (countStackTraces || printStackTraces) {
                if (printStackTraces && !stackTraces.contains(event.getStackTraceIndex())) {
                    frames.fillIn(event.getStackTraceIndex());
                    System.out.println();
                    for (int i = frames.getNrOfFrames() - 1; i >= 0; --i) {
                        System.out.println(frames.getMethodLocation(i).toString());
                    }
                }
                MethodLocation loc1 = null;
                MethodLocation loc2 = null;
                MethodLocation loc3 = null;
                MethodLocation loc4 = null;
                frames.fillIn(event.getStackTraceIndex());
                int i = frames.getNrOfFrames() - 1;
                if (i >= 0) {
                    loc1 = frames.getMethodLocation(i);
                    if (--i >= 0) {
                        loc2 = frames.getMethodLocation(i);
                        if (--i >= 0) {
                            loc3 = frames.getMethodLocation(i);
                            if (--i >= 0) {
                                loc4 = frames.getMethodLocation(i);
                            }
                        }
                    }
                }
                if (loc2 != null) {
                    pairs.add(new MethodLocationPair(loc1, loc2));
                }
                if (loc3 != null) {
                    triples.add(new MethodLocationTriple(loc1, loc2, loc3));
                }
                if (loc4 != null) {
                    quadrupels.add(new MethodLocationQuadrupel(loc1, loc2, loc3, loc4));
                }
                stackTraces.add(event.getStackTraceIndex());
            }
            if (!countAllocationSites) continue;
            allocationSites.add(new AllocationSite(event));
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Reading took " + 0.001 * (double)(endTime - startTime) + " seconds");
        if (printClassHistogram) {
            VmTrace.setTraceFlag((VmTraceFlag)VmTraceFlag.TRACE_CLASS_STATISTICS);
            System.gc();
            VmTrace.clearTraceFlag((VmTraceFlag)VmTraceFlag.TRACE_CLASS_STATISTICS);
        }
        long nrOfObjects = nrOfNonArrays + nrOfArrays;
        long sizeOfObjects = sizeOfNonArrays + sizeOfArrays;
        System.out.println("Nr of allocated objects            : " + nrOfObjects);
        System.out.println("Nr of allocated non-array objects  : " + nrOfNonArrays);
        System.out.println("Nr of allocated array objects      : " + nrOfArrays);
        System.out.println("Size of allocated objects          : " + sizeOfObjects);
        System.out.println("Size of allocated non-array objects: " + sizeOfNonArrays);
        System.out.println("Size of allocated array objects    : " + sizeOfArrays);
        System.out.println("Average stack trace size           : " + (double)stackTraceSize / (double)nrOfObjects);
        System.out.println("Maximum stack trace size           : " + maxStackSize);
        if (countStackTraces) {
            System.out.println("Number of stack traces             : " + stackTraces.size());
            System.out.println("Number of different top pairs      : " + pairs.size());
            System.out.println("Number of different top triples    : " + triples.size());
            System.out.println("Number of different top quadrupels : " + quadrupels.size());
        }
        if (countAllocationSites) {
            System.out.println("Number of allocation sites         : " + allocationSites.size());
        }
        if (doHistogram) {
            ArrayList<HistogramEntry> sorted = new ArrayList<HistogramEntry>(classesByNr.size());
            for (ClassObject classObject : classesBySize.keySet()) {
                sorted.add(new HistogramEntry(classObject, (Long)classesByNr.get(classObject), (Long)classesBySize.get(classObject)));
            }
            Object[] sorted2 = sorted.toArray(new HistogramEntry[sorted.size()]);
            Arrays.sort(sorted2);
            System.out.println();
            System.out.println(" Nr. of object | Size of objects | Class name");
            System.out.println("---------------+-----------------+---------------------------------------------------");
            for (int i = sorted2.length - 1; i >= 0; --i) {
                System.out.println(sorted2[i]);
            }
        }
    }

    private static final class MethodLocationQuadrupel {
        private final MethodLocation loc1;
        private final MethodLocation loc2;
        private final MethodLocation loc3;
        private final MethodLocation loc4;

        public MethodLocationQuadrupel(MethodLocation loc1, MethodLocation loc2, MethodLocation loc3, MethodLocation loc4) {
            this.loc1 = loc1;
            this.loc2 = loc2;
            this.loc3 = loc3;
            this.loc4 = loc4;
        }

        public int hashCode() {
            return this.loc1.hashCode() ^ this.loc2.hashCode() ^ this.loc3.hashCode() ^ this.loc4.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof MethodLocationQuadrupel) {
                MethodLocationQuadrupel otherQuadrupel = (MethodLocationQuadrupel)other;
                return otherQuadrupel.loc1 == this.loc1 && otherQuadrupel.loc2 == this.loc2 && otherQuadrupel.loc3 == this.loc3 && otherQuadrupel.loc4 == this.loc4;
            }
            return false;
        }
    }

    private static final class MethodLocationTriple {
        private final MethodLocation loc1;
        private final MethodLocation loc2;
        private final MethodLocation loc3;

        public MethodLocationTriple(MethodLocation loc1, MethodLocation loc2, MethodLocation loc3) {
            this.loc1 = loc1;
            this.loc2 = loc2;
            this.loc3 = loc3;
        }

        public int hashCode() {
            return this.loc1.hashCode() ^ this.loc2.hashCode() ^ this.loc3.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof MethodLocationTriple) {
                MethodLocationTriple otherTriple = (MethodLocationTriple)other;
                return otherTriple.loc1 == this.loc1 && otherTriple.loc2 == this.loc2 && otherTriple.loc3 == this.loc3;
            }
            return false;
        }
    }

    private static final class MethodLocationPair {
        private final MethodLocation loc1;
        private final MethodLocation loc2;

        public MethodLocationPair(MethodLocation loc1, MethodLocation loc2) {
            this.loc1 = loc1;
            this.loc2 = loc2;
        }

        public int hashCode() {
            return this.loc1.hashCode() ^ this.loc2.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof MethodLocationPair) {
                MethodLocationPair otherPair = (MethodLocationPair)other;
                return otherPair.loc1 == this.loc1 && otherPair.loc2 == this.loc2;
            }
            return false;
        }
    }

    private static final class AllocationSite {
        private final int stackTraceIndex;
        private final ClassObject classObject;

        public AllocationSite(AllocationEvent event) {
            this.stackTraceIndex = event.getStackTraceIndex();
            this.classObject = event.getClassObject();
        }

        public int hashCode() {
            return this.stackTraceIndex ^ this.classObject.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof AllocationSite) {
                AllocationSite otherSite = (AllocationSite)other;
                return this.stackTraceIndex == otherSite.stackTraceIndex && this.classObject.getId() == otherSite.classObject.getId();
            }
            return false;
        }
    }

    private static final class HistogramEntry
    implements Comparable<HistogramEntry> {
        private final long nrOfObjects;
        private final long sizeOfObejcts;
        private final ClassObject classObject;

        HistogramEntry(ClassObject classObject, long nrOfObjects, long sizeOfObjects) {
            this.classObject = classObject;
            this.nrOfObjects = nrOfObjects;
            this.sizeOfObejcts = sizeOfObjects;
        }

        public String toString() {
            return String.format("%14d | %15d | %s", this.nrOfObjects, this.sizeOfObejcts, this.classObject.getFullName());
        }

        @Override
        public int compareTo(HistogramEntry o) {
            if (this.sizeOfObejcts < o.sizeOfObejcts) {
                return -1;
            }
            if (this.sizeOfObejcts > o.sizeOfObejcts) {
                return 1;
            }
            if (this.nrOfObjects < o.nrOfObjects) {
                return -1;
            }
            if (this.nrOfObjects > o.nrOfObjects) {
                return 0;
            }
            return 0;
        }
    }
}

