/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.internal.alloctrace;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.ControllerFactory;
import com.sap.jvm.profiling.controller.impl.FileControllerImpl;
import com.sap.jvm.profiling.controller.model.alloc.AllocationModel;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.SnapshotStore;
import com.sap.jvm.profiling.snapshot.alloc.AllocationSnapshot;
import com.sap.jvm.profiling.snapshot.alloc.BytesAndObjects;
import com.sap.jvm.profiling.snapshot.alloc.CalledMethodTree;
import com.sap.jvm.profiling.snapshot.alloc.Elements;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueTreeNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DisplayCalledMethodTree {
    public static void main(String[] args) throws FileNotFoundException, IOException {
        if (args.length < 1) {
            System.out.println("DisplayCalledMethodTree <prf-file> [-line-nrs]");
            return;
        }
        FileControllerImpl controller = ControllerFactory.create(args[0], ".", new File("."));
        controller.process(null);
        AllocationModel model = controller.getModelController().getAllocationModel();
        SnapshotStore store = model.getSnapshotStore();
        if (store.size() < 1) {
            System.out.println("File must contain at least one allocation hotspot snapshot");
            return;
        }
        for (int i = 0; i < store.size(); ++i) {
            System.out.println("Snapshot Nr. " + i);
            AllocationSnapshot snapshot = (AllocationSnapshot)store.get(0);
            ResourceName name = snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateCalledMethodTree());
            ProfilingSession session = controller.getProfilingSession();
            ResourceManager manager = session.getResourceManager();
            CalledMethodTree tree = (CalledMethodTree)manager.get(name, new ProgressReporter());
            boolean includeLineNrs = args.length > 1 && args[1].equals("includeLineNrs");
            DisplayCalledMethodTree.printNodes(tree, (SelfAndTotalValueTreeNode[])tree.getRoots(), includeLineNrs);
        }
    }

    private static void printNodes(CalledMethodTree tree, SelfAndTotalValueTreeNode<MethodLocation, BytesAndObjects>[] nodes, boolean includeLineNrs) throws IOException {
        for (SelfAndTotalValueTreeNode<MethodLocation, BytesAndObjects> node : nodes) {
            int depth = node.getDepth();
            for (int i = 0; i < depth; ++i) {
                System.out.print(' ');
            }
            System.out.print(node.getKey());
            System.out.print(' ');
            System.out.print(node.getSelf().getHeapObjects());
            System.out.print(' ');
            System.out.print(node.getSelf().getHeapBytes());
            System.out.print(' ');
            System.out.print(node.getTotal().getHeapObjects());
            System.out.print(' ');
            System.out.println(node.getTotal().getHeapBytes());
            System.out.print(' ');
            System.out.print(node.getSelf().getStackObjects());
            System.out.print(' ');
            System.out.print(node.getSelf().getStackBytes());
            System.out.print(' ');
            System.out.print(node.getTotal().getStackObjects());
            System.out.print(' ');
            System.out.println(node.getTotal().getStackBytes());
            if (node.hasChildren()) {
                if (!node.hasCreatedChildren()) {
                    tree.createChildren(node, new ProgressReporter());
                }
                DisplayCalledMethodTree.printNodes(tree, (SelfAndTotalValueTreeNode[])tree.getChildren(node), includeLineNrs);
            }
            if (!includeLineNrs || !node.hasSubNodes()) continue;
            if (!node.hasCreatedSubNodes()) {
                tree.createSubNodes(node, new ProgressReporter());
            }
            DisplayCalledMethodTree.printNodes(tree, (SelfAndTotalValueTreeNode[])tree.getSubNodes(node), includeLineNrs);
        }
    }
}

