/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.internal.timebasedsampling;

import com.sap.jvm.monitor.vm.VmInfo;
import java.util.concurrent.CountDownLatch;

public class CPUTimeChecker {
    public static void main(String[] args) throws InterruptedException {
        int i;
        int i2;
        if (args.length > 3 || args.length == 1 && "-h".equals(args[0])) {
            System.out.println("Syntax: CPUTimeChecker <nr-of-threads> [<workload> [<runs-per-thread>]]");
            System.out.println();
            System.out.println("nr-of-threads  : The number of parallel threads.");
            System.out.println("                 Default is 100.");
            System.out.println("workload       : The size of the array copy copy in each step.");
            System.out.println("                 The default is 100000.");
            System.out.println("runs-per-thread: The number of copy operations per thread.");
            System.out.println("                 The default is 10000.");
            return;
        }
        int nrOfThreads = args.length > 0 ? Integer.parseInt(args[0]) : 100;
        int workload = args.length > 1 ? Integer.parseInt(args[1]) : 100000;
        final int runsPerThread = args.length > 2 ? Integer.parseInt(args[2]) : 10000;
        final byte[] src = new byte[workload];
        final byte[] dest = new byte[src.length];
        Thread[] threads = new Thread[nrOfThreads];
        final long[] threadCpuTime1 = new long[nrOfThreads];
        final CountDownLatch latch1 = new CountDownLatch(nrOfThreads);
        long cpuTime1 = VmInfo.getTimeInfo().getCpuTime();
        for (i2 = 0; i2 < nrOfThreads; ++i2) {
            final int threadIndex = i2;
            threads[i2] = new Thread(new Runnable(){

                @Override
                public void run() {
                    latch1.countDown();
                    try {
                        latch1.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    for (int j = 0; j < runsPerThread; ++j) {
                        System.arraycopy(src, 0, dest, 0, src.length);
                    }
                    threadCpuTime1[threadIndex] = VmInfo.getThreadTimeInfo((Thread)Thread.currentThread()).getCpuTime();
                }
            });
            threads[i2].start();
        }
        for (i2 = 0; i2 < nrOfThreads; ++i2) {
            threads[i2].join();
        }
        long cpuTime2 = VmInfo.getTimeInfo().getCpuTime();
        final long[] threadCpuTime2 = new long[nrOfThreads];
        final CountDownLatch latch2 = new CountDownLatch(nrOfThreads);
        for (i = 0; i < nrOfThreads; ++i) {
            final int threadIndex = i;
            threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    latch2.countDown();
                    try {
                        latch2.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    for (int j = 0; j < runsPerThread; ++j) {
                        System.arraycopy(src, 0, dest, 0, src.length);
                        try {
                            Thread.sleep(1L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    threadCpuTime2[threadIndex] = VmInfo.getThreadTimeInfo((Thread)Thread.currentThread()).getCpuTime();
                }
            });
            threads[i].start();
        }
        for (i = 0; i < nrOfThreads; ++i) {
            threads[i].join();
        }
        long cpuTime3 = VmInfo.getTimeInfo().getCpuTime();
        long cpuTimeWithoutSleeping = cpuTime2 - cpuTime1;
        long threadCpuTimeWithoutSleeping = 0L;
        for (long cpuTime : threadCpuTime1) {
            threadCpuTimeWithoutSleeping += cpuTime;
        }
        long cpuTimeWithSleeping = cpuTime3 - cpuTime2;
        long threadCpuTimeWithSleeping = 0L;
        for (long cpuTime : threadCpuTime2) {
            threadCpuTimeWithSleeping += cpuTime;
        }
        System.out.println("Without sleeping:");
        System.out.println("CPU time: " + cpuTimeWithoutSleeping);
        System.out.println("Thread CPU time: " + threadCpuTimeWithoutSleeping);
        System.out.println("With sleeping:");
        System.out.println("CPU time: " + cpuTimeWithSleeping);
        System.out.println("Thread CPU time: " + threadCpuTimeWithSleeping);
    }
}

