/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof;

import com.sap.jvm.monitor.cluster.ClusterType;
import com.sap.jvm.monitor.vm.Vm;
import com.sap.jvm.profiling.tools.jvmprof.HostConnection;

public class ClusterConnection {
    private HostConnection connection;
    private int id;
    private ClusterType type;

    public ClusterConnection(HostConnection connection, int id, ClusterType type) {
        this.connection = connection;
        this.id = id;
        this.type = type;
    }

    public Vm getVm() {
        if (this.type != ClusterType.CLUSTER_TYPE_PROCESS) {
            return null;
        }
        return this.connection.getVm(this.id);
    }

    public Vm[] getVms() {
        if (this.type == ClusterType.CLUSTER_TYPE_INSTANCE) {
            return this.connection.getVms(this.id);
        }
        Vm vm = this.getVm();
        if (vm == null) {
            return new Vm[0];
        }
        return new Vm[]{vm};
    }

    public ClusterType getType() {
        return this.type;
    }

    public int getId() {
        return this.id;
    }
}

