/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof;

import com.sap.jvm.profiling.tools.jvmprof.IllegalCommandLineArgumentsException;

public final class CommandLineArguments {
    public static final String PID_KEY = "-pid";
    public static final String SYS_NR_KEY = "-sysnr";
    public static final String VM_ID_KEY = "-vmid";
    public static final String CMD_FILE_KEY = "-cmd";
    public static final String DEST_FILE_KEY = "-dest";
    public static final String PORT_KEY = "-port";
    public static final int DEFAULT_CONTROLLER_PORT = 1199;
    public static final String HELP_KEY0 = "-?";
    public static final String HELP_KEY1 = "-h";
    public static final String HELP_KEY2 = "--help";
    public static final String HELP_KEY3 = "-help";
    private int pid = -1;
    private int sysNr = -1;
    private int vmId = -1;
    private String cmdFilename;
    private String destFilename;
    private int controllerPort = 1199;
    private boolean showHelp = false;

    public CommandLineArguments(String[] args) throws IllegalCommandLineArgumentsException {
        this.parse(args);
    }

    public CommandLineArguments(int pid, String destFilename) {
        this.pid = pid;
        this.destFilename = destFilename;
    }

    public int getPid() {
        return this.pid;
    }

    public int getSystemNumber() {
        return this.sysNr;
    }

    public int getVmId() {
        return this.vmId;
    }

    public String getCommandFilename() {
        return this.cmdFilename;
    }

    public String getDestinationFilename() {
        return this.destFilename;
    }

    public int getControllerPort() {
        return this.controllerPort;
    }

    public void resolveVmIndex(int vmIndex) {
        this.vmId = vmIndex;
    }

    public void resolvePid(int tmpPid) {
        this.pid = tmpPid;
    }

    public boolean showHelp() {
        return this.showHelp;
    }

    private void parse(String[] args) throws IllegalCommandLineArgumentsException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PID_KEY)) {
                if (args.length == ++i) {
                    throw new IllegalCommandLineArgumentsException("No pid value has been specified.");
                }
                try {
                    this.pid = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalCommandLineArgumentsException("The pid was not specified correctly: " + args[i + 1]);
                }
                if (this.pid >= 0) continue;
                throw new IllegalCommandLineArgumentsException("The pid was not specified correctly: " + args[i + 1]);
            }
            if (args[i].equals(SYS_NR_KEY)) {
                if (args.length == ++i) {
                    throw new IllegalCommandLineArgumentsException("No system number value has been specified.");
                }
                try {
                    this.sysNr = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalCommandLineArgumentsException("The system number was not specified correctly: " + args[i + 1]);
                }
                if (this.sysNr >= 0) continue;
                throw new IllegalCommandLineArgumentsException("The system number was not specified correctly: " + args[i + 1]);
            }
            if (args[i].equals(VM_ID_KEY)) {
                if (args.length == ++i) {
                    throw new IllegalCommandLineArgumentsException("No vm identifier value has been specified.");
                }
                try {
                    this.vmId = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalCommandLineArgumentsException("The vm identifier was not specified correctly: " + args[i + 1]);
                }
                if (this.vmId >= 0) continue;
                throw new IllegalCommandLineArgumentsException("The vm identifier was not specified correctly: " + args[i + 1]);
            }
            if (args[i].equals(CMD_FILE_KEY)) {
                if (args.length == ++i) {
                    throw new IllegalCommandLineArgumentsException("No value for command file has been specified.");
                }
                this.cmdFilename = args[i];
                continue;
            }
            if (args[i].equals(DEST_FILE_KEY)) {
                if (args.length == ++i) {
                    throw new IllegalCommandLineArgumentsException("No value for the destination file has been specified.");
                }
                this.destFilename = args[i];
                continue;
            }
            if (args[i].equals(PORT_KEY)) {
                if (args.length == ++i) {
                    throw new IllegalCommandLineArgumentsException("No value for the controller port has been specified.");
                }
                this.controllerPort = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals(HELP_KEY0) || args[i].equals(HELP_KEY1) || args[i].equals(HELP_KEY2) || args[i].equals(HELP_KEY3)) {
                this.showHelp = true;
                continue;
            }
            throw new IllegalCommandLineArgumentsException("Invalid command line argument: " + args[i]);
        }
    }
}

