/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof;

import com.sap.jvm.profiling.tools.jvmprof.CommandLineArguments;
import com.sap.jvm.profiling.tools.jvmprof.Utils;

public final class CommandLineVerifier {
    public static String verify(CommandLineArguments arguments) {
        if (arguments.getCommandFilename() != null || arguments.getDestinationFilename() != null) {
            return CommandLineVerifier.verifyNonInteractive(arguments);
        }
        return CommandLineVerifier.verifyInteractive(arguments);
    }

    public static boolean isNonInteractive(CommandLineArguments arguments) {
        return arguments.getCommandFilename() != null;
    }

    private static String verifyNonInteractive(CommandLineArguments arguments) {
        if (arguments.getPid() == -1 && arguments.getSystemNumber() == -1) {
            return "No valid pid or system number has been specified.";
        }
        if (arguments.getPid() >= 0 && arguments.getSystemNumber() >= 0) {
            return "Specify either a pid or system number -- but not both.";
        }
        if (arguments.getVmId() >= 0 && arguments.getSystemNumber() == -1) {
            return "Use a vm identifier only in combination with a system number.";
        }
        if (arguments.getDestinationFilename() == null) {
            return "No valid destintation file has been specified.";
        }
        if (arguments.getCommandFilename() == null) {
            return "No valid command file has been specified.";
        }
        if (arguments.getSystemNumber() >= 0 && arguments.getVmId() < 0) {
            int vmIndex = Utils.getVmIndex(arguments.getSystemNumber());
            if (vmIndex == -1) {
                return "Cannot determine non-ambiguous VM index for system: " + arguments.getSystemNumber() + ".";
            }
            arguments.resolveVmIndex(vmIndex);
        }
        if (arguments.getSystemNumber() >= 0) {
            int pid = Utils.getPid(arguments.getSystemNumber(), arguments.getVmId());
            if (pid == -1) {
                return "Cannot determine process identifier for system: " + arguments.getSystemNumber() + ".";
            }
            arguments.resolvePid(pid);
        }
        return null;
    }

    private static String verifyInteractive(CommandLineArguments arguments) {
        int vmIndex;
        if (arguments.getPid() >= 0 && arguments.getSystemNumber() >= 0) {
            return "Specify either a pid or system number -- but not both.";
        }
        if (arguments.getVmId() >= 0 && arguments.getSystemNumber() == -1) {
            return "Use a vm identifier only in combination with a system number.";
        }
        if (arguments.getSystemNumber() >= 0 && arguments.getVmId() < 0 && (vmIndex = Utils.getVmIndex(arguments.getSystemNumber())) != -1) {
            arguments.resolveVmIndex(vmIndex);
        }
        if (arguments.getSystemNumber() >= 0 && arguments.getVmId() >= 0) {
            int pid = Utils.getPid(arguments.getSystemNumber(), arguments.getVmId());
            if (pid == -1) {
                return "Cannot determine process identifier for system: " + arguments.getSystemNumber() + ".";
            }
            arguments.resolvePid(pid);
        }
        return null;
    }
}

