/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof;

import com.sap.jvm.monitor.cluster.Cluster;
import com.sap.jvm.monitor.cluster.ClusterInfo;
import com.sap.jvm.monitor.remoteCluster.RemoteCluster;
import com.sap.jvm.monitor.remoteCluster.RemoteVm;
import com.sap.jvm.monitor.vm.Vm;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class HostConnection {
    private String hostname;
    private int port;
    private RemoteCluster cluster;

    public HostConnection(String hostname, int port) throws RemoteException {
        if (hostname != null) {
            try {
                Registry registry = LocateRegistry.getRegistry(hostname, port);
                this.cluster = (RemoteCluster)registry.lookup("RemoteCluster");
            }
            catch (NotBoundException e) {
                RemoteException re = new RemoteException();
                re.initCause(e);
                throw re;
            }
            this.hostname = hostname;
            this.port = port;
        } else {
            this.hostname = "localhost";
            this.port = -1;
        }
    }

    public ClusterInfo[] getClusterInfo() {
        if (this.cluster == null) {
            return Cluster.getClusterInfo();
        }
        try {
            return this.cluster.getClusterInfo();
        }
        catch (RemoteException re) {
            return new ClusterInfo[0];
        }
    }

    public Vm getVm(int processId) {
        if (this.cluster == null) {
            return Cluster.getVm((int)processId);
        }
        try {
            RemoteVm remoteVm = this.cluster.getVm(processId);
            return this.cluster.getVm(remoteVm);
        }
        catch (RemoteException re) {
            return null;
        }
    }

    public Vm[] getVms(int instanceNumber) {
        if (this.cluster == null) {
            return Cluster.getVms((int)instanceNumber);
        }
        try {
            RemoteVm[] remoteVm = this.cluster.getVms(instanceNumber);
            return this.cluster.getVms(remoteVm);
        }
        catch (RemoteException re) {
            return new Vm[0];
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRemoteConnection() {
        return this.cluster != null;
    }
}

