/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof;

import com.sap.jvm.inspector.InspectorInfo;
import com.sap.jvm.profiling.tools.jvmprof.CommandLineArguments;
import com.sap.jvm.profiling.tools.jvmprof.CommandLineVerifier;
import com.sap.jvm.profiling.tools.jvmprof.IllegalCommandLineArgumentsException;
import com.sap.jvm.profiling.tools.jvmprof.JvmProfConsole;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class JvmProf {
    public static final String DEBUG_PROPERTY = "com.sap.jvm.tools.profiling.jvmprof.debug";
    public static final boolean DEBUG = Boolean.getBoolean("com.sap.jvm.tools.profiling.jvmprof.debug");
    private static final String LOG_FILE = "jvmProf";
    private static PrintStream logWriter;
    private static String logFileName;

    public static void printUsage() {
        System.out.println("usage: jvmprof [-? -h --help]");
        System.out.println("usage: jvmprof -pid <pid>");
        System.out.println("usage: jvmprof -sysnr <sysnr> -vmid <vmid>");
        System.out.println("usage: jvmprof -pid <pid> -cmd <command file name> -dest <destination file>");
        System.out.println("usage: jvmprof -sysnr <sysnr> -vmid <vmid> -cmd <command file name> -dest <destination file>");
    }

    public static synchronized PrintStream getLogWriter() {
        if (logWriter != null) {
            return logWriter;
        }
        int pid = InspectorInfo.getOwnProcessId();
        try {
            logFileName = System.getProperty("java.io.tmpdir") + File.separator + LOG_FILE + "_" + pid + ".log";
            logWriter = new PrintStream(new BufferedOutputStream(new FileOutputStream(logFileName)));
        }
        catch (IOException ex) {
            System.exit(2);
        }
        return logWriter;
    }

    public static void main(String[] args) {
        CommandLineArguments arguments = null;
        try {
            arguments = new CommandLineArguments(args);
            CommandLineVerifier.verify(arguments);
        }
        catch (IllegalCommandLineArgumentsException ex) {
            System.out.println(ex.getMessage());
            JvmProf.printUsage();
            System.exit(1);
        }
        if (arguments != null && arguments.showHelp()) {
            JvmProf.printUsage();
            System.exit(0);
        }
        if (InspectorInfo.couldElevate()) {
            System.err.println("WARNING: jvmprof is not run as administrator. This might limit the number of visible JVMs.");
        }
        if (CommandLineVerifier.isNonInteractive(arguments)) {
            new JvmProfConsole().startNonInteractive(arguments);
        } else {
            new JvmProfConsole().startInteractive(arguments);
        }
        if (logWriter != null) {
            logWriter.flush();
            logWriter.close();
            File file = new File(logFileName);
            if (file.length() == 0L) {
                file.delete();
            }
        }
    }
}

