/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof;

import com.sap.jvm.inspector.InspectorInfo;
import com.sap.jvm.monitor.cluster.ClusterInfo;
import com.sap.jvm.monitor.cluster.ClusterType;
import com.sap.jvm.monitor.cluster.InstanceClusterInfo;
import com.sap.jvm.monitor.cluster.ProcessClusterInfo;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.Vm;
import com.sap.jvm.profiling.Connection;
import com.sap.jvm.profiling.core.ProfilingCapabilities;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.tools.jvmprof.ClusterConnection;
import com.sap.jvm.profiling.tools.jvmprof.CommandLineArguments;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.HostConnection;
import com.sap.jvm.profiling.tools.jvmprof.JvmProf;
import com.sap.jvm.profiling.tools.jvmprof.Utils;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.CommandRegistry;
import com.sap.jvm.profiling.tools.jvmprof.command.JvmProfCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.ProfilingCommand;
import com.sap.jvm.profiling.tools.jvmprof.controller.Request;
import com.sap.jvm.profiling.tools.jvmprof.controller.RequestHandler;
import com.sap.jvm.profiling.tools.jvmprof.exception.InvalidArgumentException;
import com.sap.jvm.tools.console.ConsoleReader;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;

public final class JvmProfConsole
implements ExecutionEnvironment {
    private ConsoleReader input;
    private ClusterConnection connection;
    private CommandRegistry cmdRegistry = new CommandRegistry();

    public static String getPaddedNumber(int number, int length) {
        String numberString = String.valueOf(number);
        String padding = "";
        for (int k = numberString.length(); k < length; ++k) {
            padding = padding + " ";
        }
        return padding + numberString;
    }

    public void startInteractive(CommandLineArguments args) {
        HostConnection hostConnection;
        this.input = new ConsoleReader(this.cmdRegistry);
        try {
            hostConnection = new HostConnection(null, -1);
        }
        catch (RemoteException re) {
            re.printStackTrace();
            return;
        }
        try {
            if (!this.selectCluster(hostConnection, args)) {
                return;
            }
            this.commandLoop();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void startNonInteractive(CommandLineArguments args) {
        int pid = args.getPid();
        if (pid == -1) {
            pid = Utils.getPid(args.getSystemNumber(), args.getVmId());
        }
        if (pid < 0) {
            System.err.println("Cannot not find the specified vm (instance number: " + args.getSystemNumber() + ",vm index: " + args.getVmId() + ").");
            return;
        }
        if (JvmProf.DEBUG) {
            JvmProf.getLogWriter().println("JvmProf parameter settings: ");
            JvmProf.getLogWriter().print("pid = " + String.valueOf(pid));
            JvmProf.getLogWriter().print(", prfFileName = " + args.getDestinationFilename());
            JvmProf.getLogWriter().println(", cmdFileName = " + args.getCommandFilename());
        }
        String error = null;
        File cmdFile = new File(args.getCommandFilename());
        if (cmdFile.exists()) {
            try {
                Request request = new Request(pid, cmdFile, args.getDestinationFilename());
                new RequestHandler().handleRequest(request);
                error = request.getErrorMessage();
            }
            catch (IOException e) {
                error = e.getMessage();
            }
        } else {
            error = "Command file '" + args.getCommandFilename() + "' does not exist.";
        }
        if (error != null) {
            System.err.println("Failure during command processing: " + error);
        }
    }

    public ConsoleReader getInput() {
        return this.input;
    }

    public ClusterConnection getClusterConnection() {
        return this.connection;
    }

    @Override
    public String[] getHistory() {
        return this.input.getHistory();
    }

    @Override
    public List<JvmProfCommand> getCommands() {
        return this.cmdRegistry.getCommands();
    }

    @Override
    public Vm getVm(Argument[] args) {
        if (this.getClusterConnection().getType() == ClusterType.CLUSTER_TYPE_PROCESS) {
            return this.getClusterConnection().getVm();
        }
        if (this.getClusterConnection().getType() == ClusterType.CLUSTER_TYPE_INSTANCE) {
            int vm = -1;
            Vm[] vms = this.getClusterConnection().getVms();
            if (vms.length == 1) {
                return vms[0];
            }
            String vmIndexValue = this.getArgumentValue("vm", args);
            do {
                try {
                    if (vmIndexValue == null) {
                        System.out.print("VM => ");
                        vmIndexValue = this.getInput().readLine();
                    }
                    vm = Integer.parseInt(vmIndexValue);
                    vmIndexValue = null;
                }
                catch (IOException | NumberFormatException ex) {
                    vm = -1;
                }
                if (vm < 0) continue;
                for (int i = 0; i < vms.length; ++i) {
                    try {
                        if (vms[i].getStateInfo().getVmIndex() != vm) continue;
                        return vms[i];
                    }
                    catch (InvalidVmException invalidVmException) {
                        // empty catch block
                    }
                }
            } while (vm != -1);
        }
        return null;
    }

    @Override
    public Vm getVm(int index) {
        if (this.getClusterConnection().getType() == ClusterType.CLUSTER_TYPE_PROCESS) {
            return this.getClusterConnection().getVm();
        }
        if (index < 0) {
            return null;
        }
        Vm[] vms = this.getClusterConnection().getVms();
        for (int i = 0; i < vms.length; ++i) {
            try {
                if (vms[i].getStateInfo().getVmIndex() != index) continue;
                return vms[i];
            }
            catch (InvalidVmException invalidVmException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Vm[] getVms() {
        return this.connection.getVms();
    }

    @Override
    public Connection getConnection() {
        return null;
    }

    @Override
    public ProfilingCapabilities getCapabilities() {
        return null;
    }

    @Override
    public String executeAndWait(Command cmd) {
        throw new UnsupportedOperationException("Execute and wait is not supported.");
    }

    @Override
    public String getErrorMessage() {
        throw new UnsupportedOperationException("getErrorMessage is not supported.");
    }

    @Override
    public String getDefaultDestFile() {
        throw new UnsupportedOperationException("getDefaultDestFile is not supported.");
    }

    @Override
    public int getPid() {
        throw new UnsupportedOperationException("getPid is not supported.");
    }

    private void commandLoop() throws IOException {
        String line;
        while ((line = this.input.readLine(false)) != null) {
            try {
                if (line.trim().length() == 0) continue;
                if (this.input.isHistoryCommand(line)) {
                    if ((line = this.input.getHistoryCommand(line)) == null) continue;
                    System.out.println(line);
                }
                try {
                    this.handleCommand(line);
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                }
            }
            catch (InvalidArgumentException ex) {
                System.out.println("Command execution failed: " + ex.getMessage());
            }
        }
    }

    private boolean selectCluster(HostConnection hostConnection, CommandLineArguments args) throws IOException {
        int attachableClusters = 0;
        if (args.getPid() != -1) {
            if (!Utils.existsProcess(args.getPid())) {
                System.err.println("Cannot attach to process: " + args.getPid() + ".");
                System.exit(1);
            }
            this.connection = new ClusterConnection(hostConnection, args.getPid(), ClusterType.CLUSTER_TYPE_PROCESS);
            return true;
        }
        if (args.getSystemNumber() >= 0) {
            this.connection = new ClusterConnection(hostConnection, args.getSystemNumber(), ClusterType.CLUSTER_TYPE_INSTANCE);
            if (!Utils.existsSystem(args.getSystemNumber())) {
                System.err.println("Cannot attach to system: " + args.getSystemNumber() + ".");
                System.exit(1);
            }
            return true;
        }
        ClusterInfo[] clusterInfo = hostConnection.getClusterInfo();
        for (int i = 0; i < clusterInfo.length; ++i) {
            if (clusterInfo[i].getType() == ClusterType.CLUSTER_TYPE_PROCESS) {
                ProcessClusterInfo pci = (ProcessClusterInfo)clusterInfo[i];
                if (!hostConnection.isRemoteConnection() && pci.getProcessId() == InspectorInfo.getOwnProcessId()) continue;
                if (pci.isAttachable()) {
                    Vm vm = hostConnection.getVm(pci.getProcessId());
                    if (vm == null) continue;
                    try {
                        System.out.println("Process " + JvmProfConsole.getPaddedNumber(pci.getProcessId(), 12) + " (Java arguments: " + vm.getStartInfo().getJavaArguments() + ")");
                    }
                    catch (InvalidVmException invalidVmException) {
                        // empty catch block
                    }
                    ++attachableClusters;
                    continue;
                }
                System.out.println("Process " + JvmProfConsole.getPaddedNumber(pci.getProcessId(), 12) + " ERROR: Version mismatch");
                continue;
            }
            if (clusterInfo[i].getType() == ClusterType.CLUSTER_TYPE_INSTANCE) {
                InstanceClusterInfo ici = (InstanceClusterInfo)clusterInfo[i];
                if (ici.isAttachable()) {
                    System.out.println("Systemnumber " + JvmProfConsole.getPaddedNumber(ici.getInstanceId(), 7));
                    ++attachableClusters;
                    continue;
                }
                System.out.println("Systemnumber " + JvmProfConsole.getPaddedNumber(ici.getInstanceId(), 7) + " ERROR: Version mismatch");
                continue;
            }
            System.out.println("Unknown cluster type " + clusterInfo[i].getType());
            return false;
        }
        int id = -1;
        ClusterType type = ClusterType.CLUSTER_TYPE_UNKNOWN;
        if (attachableClusters == 0) {
            System.out.println("No VMs running");
            return false;
        }
        if (attachableClusters == 1) {
            for (int i = 0; i < clusterInfo.length; ++i) {
                if (!clusterInfo[i].isAttachable()) continue;
                type = clusterInfo[i].getType();
                if (type == ClusterType.CLUSTER_TYPE_PROCESS) {
                    id = ((ProcessClusterInfo)clusterInfo[i]).getProcessId();
                    if (!hostConnection.isRemoteConnection() && id == InspectorInfo.getOwnProcessId()) {
                        continue;
                    }
                } else if (type == ClusterType.CLUSTER_TYPE_INSTANCE) {
                    id = ((InstanceClusterInfo)clusterInfo[i]).getInstanceId();
                }
                break;
            }
        } else {
            boolean isValid = false;
            do {
                try {
                    System.out.print("Systemnumber / Process => ");
                    id = Integer.parseInt(this.input.readLine());
                    int found = 0;
                    for (int i = 0; i < clusterInfo.length; ++i) {
                        if (!clusterInfo[i].isAttachable()) continue;
                        if (clusterInfo[i].getType() == ClusterType.CLUSTER_TYPE_PROCESS) {
                            if (id != ((ProcessClusterInfo)clusterInfo[i]).getProcessId()) continue;
                            type = ClusterType.CLUSTER_TYPE_PROCESS;
                            isValid = true;
                            ++found;
                            continue;
                        }
                        if (clusterInfo[i].getType() != ClusterType.CLUSTER_TYPE_INSTANCE || id != ((InstanceClusterInfo)clusterInfo[i]).getInstanceId()) continue;
                        type = ClusterType.CLUSTER_TYPE_INSTANCE;
                        isValid = true;
                        ++found;
                    }
                    if (found <= true) continue;
                    System.out.println("Id " + id + " is ambiguous.");
                    System.out.println(" 0: Systemnumber");
                    System.out.println(" 1: Process");
                    int choice = Integer.parseInt(this.input.readLine().trim());
                    type = choice == 0 ? ClusterType.CLUSTER_TYPE_INSTANCE : ClusterType.CLUSTER_TYPE_PROCESS;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            } while (!isValid && id != -1);
        }
        this.connection = new ClusterConnection(hostConnection, id, type);
        return id != -1;
    }

    private boolean handleCommand(String line) throws IOException, InvalidArgumentException {
        JvmProfCommand cmd = this.cmdRegistry.getCommand(line);
        if (cmd == null) {
            return false;
        }
        Argument[] args = this.cmdRegistry.getArguments(line, cmd.getOpcode());
        if (args != null && args.length == 1 && args[0].getKey().equals("-help")) {
            System.out.println(cmd.getDetailedHelpText());
            return true;
        }
        if (cmd instanceof ProfilingCommand) {
            return this.handleProfilingCommand((ProfilingCommand)cmd, line);
        }
        return cmd.execute(args, this);
    }

    private boolean handleProfilingCommand(ProfilingCommand command, String line) throws InvalidArgumentException {
        Argument[] args = this.cmdRegistry.getArguments(line, command.getOpcode());
        Vm vm = this.getVm(args);
        if (vm == null) {
            System.err.println("Invalid VM handle. Is the VM still running?");
            return false;
        }
        try {
            Request request = new Request(vm.getStateInfo().getPid(), line);
            new RequestHandler().handleRequest(request);
            if (request.hasError()) {
                System.err.println(request.getErrorMessage());
            }
            return request.hasError();
        }
        catch (InvalidVmException ex) {
            System.err.println("Invalid VM handle. Is the VM still running?");
            return false;
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            return false;
        }
    }

    private String getArgumentValue(String key, Argument[] args) {
        if (args == null) {
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].getKey().equals(key)) continue;
            return args[i].getValue();
        }
        return null;
    }

    @Override
    public Response getLastResponse() {
        return null;
    }

    @Override
    public void cancel() throws IOException {
        throw new UnsupportedOperationException("cancel() is not supported.");
    }

    @Override
    public boolean isCancelled() {
        throw new UnsupportedOperationException("isCancelled() is not supported.");
    }

    @Override
    public void setBatchMode(boolean batchMode) {
        throw new UnsupportedOperationException("setBatchMode() is not supported.");
    }

    @Override
    public boolean isBatchMode() {
        throw new UnsupportedOperationException("isBatchMode() is not supported.");
    }
}

