/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof;

import com.sap.jvm.monitor.cluster.Cluster;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.Vm;
import com.sap.jvm.monitor.vm.VmStateInfo;

public final class Utils {
    public static int getPid(int sysNr, int vmId) {
        Vm[] vms = Cluster.getVms((int)sysNr);
        for (int i = 0; i < vms.length; ++i) {
            try {
                VmStateInfo stateInfo = vms[i].getStateInfo();
                if (stateInfo.getVmIndex() != vmId) continue;
                return stateInfo.getPid();
            }
            catch (InvalidVmException invalidVmException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static int getVmIndex(int sysNr) {
        Vm[] vms = Cluster.getVms((int)sysNr);
        if (vms.length != 1) {
            return -1;
        }
        try {
            VmStateInfo stateInfo = vms[0].getStateInfo();
            return stateInfo.getVmIndex();
        }
        catch (InvalidVmException invalidVmException) {
            return -1;
        }
    }

    public static boolean existsProcess(int pid) {
        return Cluster.getVm((int)pid) != null;
    }

    public static boolean existsSystem(int sysNr) {
        Vm[] vms = Cluster.getVms((int)sysNr);
        return vms.length > 0;
    }
}

