/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import java.util.ArrayList;

public final class Argument {
    private final String key;
    private final String value;

    public Argument(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public static String getStringValue(Argument[] args, String key, String defaultValue) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].getKey().equals(key)) continue;
            return args[i].getValue();
        }
        return defaultValue;
    }

    public static String[] getStringValues(Argument[] args, String key) {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].getKey().equals(key)) continue;
            values.add(args[i].getValue());
        }
        String[] retValues = new String[values.size()];
        retValues = values.toArray(retValues);
        return retValues;
    }

    public static boolean getBooleanValue(Argument[] args, String key, boolean defaultValue) {
        String value = Argument.getStringValue(args, key, null);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static int getIntValue(Argument[] args, String key, int defaultValue) {
        String value = Argument.getStringValue(args, key, null);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }
}

