/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.memory.command.DumpClassStatisticCommand;
import com.sap.jvm.profiling.memory.command.MemoryCommandFactory;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.ProfilingCommand;
import java.io.IOException;

public final class ClassStatisticDumpCommand
extends ProfilingCommand {
    private static final String KEY_FORCE_GC = "forceGc";
    private static final boolean VALUE_DEFAULT_FORCE_GC = true;
    private static final String KEY_NAME = "name";
    private static final String VALUE_DEFAULT_KEY_NAME = "ClassStatisticDump";
    private static final MemoryCommandFactory memCmdFactory = ProfilingFactory.createMemoryCommandFactory();

    @Override
    public String getOpcode() {
        return "dump class statistic";
    }

    @Override
    public String getHelpText() {
        return "dumps a class statistic";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Usage: ").append(this.getOpcode()).append(" [<vm>] ").append(" [<forceGc=true|false>] ").append(" [<name=name>] ").append("\n");
        builder.append("\nDefinitions:\n").append("  <vm>\t\t\tThe VM index when running in a cluster environment.\n").append("  <forceGc>\tIf set to 'true'. a GC get triggered in front of the class statistic dump\n\t\t\t\tDefault is 'true'.\n").append("  <name>\tThe name of the  class statistic dump\n\t\t\t\tDefault is 'ClassStatisticDump'.\n");
        return builder.toString();
    }

    @Override
    protected boolean executeInternal(Argument[] args, ExecutionEnvironment execEnv) throws InvalidVmException, IOException {
        boolean forceGC;
        String name = Argument.getStringValue(args, KEY_NAME, VALUE_DEFAULT_KEY_NAME);
        DumpClassStatisticCommand cmd = memCmdFactory.createDumpClassStatisticCommand(name, forceGC = Argument.getBooleanValue(args, KEY_FORCE_GC, true));
        String errorMessage = execEnv.executeAndWait((Command)cmd);
        return errorMessage == null;
    }
}

