/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.profiling.tools.jvmprof.JvmProf;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.ClassStatisticDumpCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.CreateSnapshotCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.DisplayVmsCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.DumpHeapCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.ExitCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.HelpCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.HistoryCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.JvmProfCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.PrintProfilingInformationCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.ProfilingTraceInfoCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.QuitCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StartAllocationTraceCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StartExceptionTraceCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StartIOTraceCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StartMethodCoverageTraceCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StartMethodParameterTraceCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StartNetworkTraceCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StartPerformanceHotspotTrace;
import com.sap.jvm.profiling.tools.jvmprof.command.StartProfilingCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StartSynchronizationTraceCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StartThreadDumpTraceCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StopAllocationTraceCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StopExceptionTraceCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StopIOTraceCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StopMethodCoverageTraceCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StopMethodParameterTraceCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StopNetworkTraceCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StopPerformanceHotspotTraceCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StopProfilingCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StopSynchronizationTraceCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StopThreadDumpTraceCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.ThreadDumpCommand;
import com.sap.jvm.tools.console.Completor;
import com.sap.jvm.tools.util.Tokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class CommandRegistry
implements Completor {
    private List<JvmProfCommand> commands = new ArrayList<JvmProfCommand>();

    public CommandRegistry() {
        this.commands.add(new DisplayVmsCommand());
        this.commands.add(new HistoryCommand());
        this.commands.add(new HelpCommand());
        this.commands.add(new PrintProfilingInformationCommand());
        this.commands.add(new ExitCommand());
        this.commands.add(new QuitCommand());
        this.commands.add(new StartProfilingCommand());
        this.commands.add(new StopProfilingCommand());
        this.commands.add(new StartAllocationTraceCommand());
        this.commands.add(new StopAllocationTraceCommand());
        this.commands.add(new StartPerformanceHotspotTrace());
        this.commands.add(new StopPerformanceHotspotTraceCommand());
        this.commands.add(new CreateSnapshotCommand());
        this.commands.add(new StartMethodParameterTraceCommand());
        this.commands.add(new StopMethodParameterTraceCommand());
        this.commands.add(new StartSynchronizationTraceCommand());
        this.commands.add(new StopSynchronizationTraceCommand());
        this.commands.add(new StartIOTraceCommand());
        this.commands.add(new StopIOTraceCommand());
        this.commands.add(new StartExceptionTraceCommand());
        this.commands.add(new StopExceptionTraceCommand());
        this.commands.add(new StartNetworkTraceCommand());
        this.commands.add(new StopNetworkTraceCommand());
        this.commands.add(new ProfilingTraceInfoCommand());
        this.commands.add(new StartThreadDumpTraceCommand());
        this.commands.add(new ThreadDumpCommand());
        this.commands.add(new StopThreadDumpTraceCommand());
        this.commands.add(new ClassStatisticDumpCommand());
        this.commands.add(new DumpHeapCommand());
        this.commands.add(new StartMethodCoverageTraceCommand());
        this.commands.add(new StopMethodCoverageTraceCommand());
        Collections.sort(this.commands);
    }

    public JvmProfCommand getCommand(String line) throws IOException {
        int i;
        LinkedList<String> candidates;
        String commandString = line;
        int lastIndex = commandString.length();
        do {
            candidates = new LinkedList<String>();
            this.complete(commandString, candidates);
            lastIndex = commandString.lastIndexOf(" ", lastIndex);
            if (lastIndex == -1) break;
            commandString = commandString.substring(0, lastIndex);
        } while (candidates.size() == 0);
        int exactMatchIndex = -1;
        if (candidates.size() == 1) {
            exactMatchIndex = 0;
        } else {
            for (i = 0; i < candidates.size(); ++i) {
                if (!line.startsWith((String)candidates.get(i))) continue;
                exactMatchIndex = i;
                break;
            }
        }
        if (candidates.size() == 0) {
            return null;
        }
        if (exactMatchIndex >= 0) {
            for (i = 0; i < this.commands.size(); ++i) {
                if (!((String)candidates.get(exactMatchIndex)).equals(this.commands.get(i).getOpcode())) continue;
                return this.commands.get(i);
            }
        } else {
            throw new IOException("Ambiguous command found.");
        }
        return null;
    }

    public Argument[] getArguments(String line, String opcode) {
        int pos = 0;
        for (int j = 0; j < line.length() && j < opcode.length() && line.charAt(j) == opcode.charAt(j); ++j) {
            ++pos;
        }
        String arguments = line.substring(pos).trim();
        if (JvmProf.DEBUG) {
            JvmProf.getLogWriter().println("JvmProf: Arguments " + arguments);
        }
        return this.createArguments(arguments);
    }

    public List<JvmProfCommand> getCommands() {
        return this.commands;
    }

    @Override
    public void complete(String buffer, List<String> candidates) {
        int i;
        ArrayList<String> selection = new ArrayList<String>();
        for (i = 0; i < this.commands.size(); ++i) {
            selection.add(this.commands.get(i).getOpcode());
        }
        for (i = 0; i < selection.size(); ++i) {
            if (!((String)selection.get(i)).startsWith(buffer)) continue;
            candidates.add((String)selection.get(i));
        }
        Collections.sort(candidates);
    }

    private Argument[] createArguments(String line) {
        LinkedList<Argument> argList = new LinkedList<Argument>();
        String tmpLine = line.trim();
        boolean helpRequested = this.checkForHelp(tmpLine);
        if (helpRequested) {
            return new Argument[]{new Argument("-help", null)};
        }
        String[] tokens = (tmpLine = this.checkForVm(tmpLine, argList)).equals("") ? new String[]{} : Tokenizer.split(tmpLine, " ");
        for (int i = 0; i < tokens.length; ++i) {
            String key = null;
            String value = "";
            String currentTok = tokens[i];
            int equal = currentTok.indexOf("=");
            if (equal >= 0) {
                key = currentTok.substring(0, equal);
                if (equal != currentTok.length() - 1) {
                    value = currentTok.substring(equal + 1);
                    assert (value.length() > 0);
                } else if (++i < tokens.length) {
                    value = tokens[i];
                }
            } else {
                assert (equal == -1);
                key = currentTok;
                if (++i < tokens.length) {
                    String nextToken = tokens[i];
                    equal = nextToken.indexOf("=");
                    if (equal == 0) {
                        assert (nextToken.length() >= 1);
                        if (nextToken.length() > 1) {
                            value = nextToken.substring(1);
                        } else if (++i < tokens.length) {
                            value = tokens[i];
                        }
                    } else {
                        --i;
                    }
                }
            }
            argList.add(new Argument(key, value));
        }
        Argument[] retValue = new Argument[argList.size()];
        retValue = argList.toArray(retValue);
        return retValue;
    }

    private String checkForVm(String line, List<Argument> argList) {
        String tmpLine = line;
        if (tmpLine.length() != 0) {
            int firstSpace = line.indexOf(32);
            if (firstSpace == -1) {
                firstSpace = tmpLine.length();
            }
            String vmIndexStr = tmpLine.substring(0, firstSpace);
            try {
                Integer.parseInt(vmIndexStr);
                tmpLine = firstSpace + 1 < tmpLine.length() ? tmpLine.substring(firstSpace + 1) : "";
                argList.add(new Argument("vm", vmIndexStr));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return tmpLine;
    }

    private boolean checkForHelp(String line) {
        return line.length() != 0 && line.equals("-help");
    }
}

