/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.core.command.CoreCommandFactory;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.ProfilingCommand;
import java.io.IOException;

public final class CreateSnapshotCommand
extends ProfilingCommand {
    private static final CoreCommandFactory coreCmdFactory = ProfilingFactory.createCoreCommandFactory();
    private static final String KEY_TRACE = "trace";
    private static final String KEY_NAME = "name";
    private static final String KEY_DELTA = "delta";
    private static final boolean VALUE_DEFAULT_DELTA = true;
    private static final String VALUE_DEFAULT_NAME = "New Snapshot";

    @Override
    public String getOpcode() {
        return "create snapshot";
    }

    @Override
    public String getHelpText() {
        return "creates snapshots for started traces inside a VM";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Usage: ").append(this.getOpcode()).append(" [<vm>]").append(" [<name=MySnapshot>]").append(" [<delta=true|false>]").append(" [<trace=allocation|performance|method parameter|io|network|synchronization|gc>]\n");
        builder.append("\nDefinitions:\n").append("  <vm>\t\t\tThe VM index when running in a cluster environment.\n").append("  <name>\t\tThe name of the snapshot.\n\t\t\tDefault is 'New Snapshot'.\n").append("  <delta>\t\tIf set to 'true', only delta snapshots are created.\n\t\t\tDefault is 'true'.\n").append("  <trace>\t\tThe name of the trace for which snapshots have to created.\n\t\t\tDefault is '*' (all started traces).\n");
        return builder.toString();
    }

    @Override
    protected boolean executeInternal(Argument[] args, ExecutionEnvironment execEnv) throws InvalidVmException, IOException {
        String errorMessage;
        String name = Argument.getStringValue(args, KEY_NAME, VALUE_DEFAULT_NAME);
        boolean delta = Argument.getBooleanValue(args, KEY_DELTA, true);
        String trace = Argument.getStringValue(args, KEY_TRACE, null);
        ProfilingTraceType traceType = ProfilingTraceType.ALL_TRACES;
        if (trace != null) {
            if (trace.equals("allocation")) {
                traceType = ProfilingTraceType.ALLOCATION_TRACE;
            } else if (trace.equals("performance")) {
                traceType = ProfilingTraceType.PERFORMANCE_HOTSPOT_TRACE;
            } else if (trace.equals("method parameter")) {
                traceType = ProfilingTraceType.METHOD_PARAMETER_TRACE;
            } else if (trace.equals("io")) {
                traceType = ProfilingTraceType.IO_TRACE;
            } else if (trace.equals("network")) {
                traceType = ProfilingTraceType.NETWORK_TRACE;
            } else if (trace.equals("synchronization")) {
                traceType = ProfilingTraceType.SYNCHRONIZATION_TRACE;
            } else if (trace.equals("gc")) {
                traceType = ProfilingTraceType.GC_TRACE;
            }
        }
        return (errorMessage = execEnv.executeAndWait((Command)coreCmdFactory.createSnapshotMarkerCommand(traceType, name, delta))) == null;
    }
}

