/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.Vm;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.JvmProfCommand;

public final class DisplayVmsCommand
extends JvmProfCommand {
    @Override
    public String getHelpText() {
        return "displays the VMs in the cluster";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Usage: ").append(this.getOpcode()).append("\n");
        return builder.toString();
    }

    @Override
    public String getOpcode() {
        return "display vms";
    }

    @Override
    protected boolean executeInternal(Argument[] args, ExecutionEnvironment execEnv) {
        Vm[] vms = execEnv.getVms();
        System.out.println("+--------+---------+-----------------+----------------+");
        System.out.println("|  VmId  |   Pid   | Profiling State | Profiling Port |");
        System.out.println("+--------+---------+-----------------+----------------+");
        for (int i = 0; i < vms.length; ++i) {
            try {
                System.out.format("| %6d | %7d | %15s | %14d |\n", vms[i].getStateInfo().getVmIndex(), vms[i].getStateInfo().getPid(), vms[i].getProfilingInfo().getNrOfActiveProfilingRuns() > 0 ? "Active" : "Not active", vms[i].getProfilingInfo().getProfilingPort());
                continue;
            }
            catch (InvalidVmException invalidVmException) {
                // empty catch block
            }
        }
        System.out.println("+--------+---------+-----------------+----------------+");
        return true;
    }
}

