/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.memory.command.HprofDumpCommand;
import com.sap.jvm.profiling.memory.command.MemoryCommandFactory;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.ProfilingCommand;
import java.io.IOException;

public final class DumpHeapCommand
extends ProfilingCommand {
    private static final String KEY_FORCE_GC = "forceGc";
    private static final boolean VALUE_DEFAULT_FORCE_GC = true;
    private static final String KEY_NAME = "name";
    private static final String VALUE_DEFAULT_KEY_NAME = "heapDump.hprof";
    private static final String KEY_ENSURE_IDS = "ensureIds";
    private static final boolean VALUE_DEFAULT_ENSURE_IDS = false;
    private static final String KEY_INCLUDE_ADDONS = "includeAddons";
    private static final boolean VALUE_DEFAULT_INCLUDE_ADDONS = true;
    private static final MemoryCommandFactory memCmdFactory = ProfilingFactory.createMemoryCommandFactory();

    @Override
    public String getOpcode() {
        return "dump heap";
    }

    @Override
    public String getHelpText() {
        return "dumps the heap";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Usage: ").append(this.getOpcode()).append(" [<vm>] ").append(" [<forceGc=true|false>] ").append(" [<ensureIds=true|false>] ").append(" [<includeAddons=true|false>] ").append(" [<name=name>] ").append("\n");
        builder.append("\nDefinitions:\n").append("  <vm>\t\t\tThe VM index when running in a cluster environment.\n").append("  <forceGc>\tIf set to 'true', a full GC a is forced when the heap is dumped, so only life objects should be seen in the dump\n\t\t\t\tDefault is 'true'.\n").append("  <ensureIds>\tIf set to 'true', all objects get a unique id assigned to them. This is only useful if the addons are written, since the ids are only included in the addons.\n\t\t\t\tDefault is 'false'.\n").append("  <includeAddons>\tIf set to 'true', the SAP JVM addons will be included too.\n\t\t\t\tDefault is 'true'.\n").append("  <name>\tThe name of the snapshot to assign\n\t\t\t\tDefault is 'heapDump.hprof'.\n");
        return builder.toString();
    }

    @Override
    protected boolean executeInternal(Argument[] args, ExecutionEnvironment execEnv) throws InvalidVmException, IOException {
        String name = Argument.getStringValue(args, KEY_NAME, VALUE_DEFAULT_KEY_NAME);
        boolean forceGC = Argument.getBooleanValue(args, KEY_FORCE_GC, true);
        boolean ensureIds = Argument.getBooleanValue(args, KEY_ENSURE_IDS, false);
        boolean includeAddons = Argument.getBooleanValue(args, KEY_INCLUDE_ADDONS, true);
        HprofDumpCommand cmd = memCmdFactory.createHprofDumpCommand(name, includeAddons, ensureIds, forceGC);
        String errorMessage = execEnv.executeAndWait((Command)cmd);
        return errorMessage == null;
    }
}

