/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.JvmProfCommand;
import java.util.List;

public final class HelpCommand
extends JvmProfCommand {
    @Override
    public String getHelpText() {
        return "shows the help text";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Usage: ").append(this.getOpcode()).append("\n");
        return builder.toString();
    }

    @Override
    public String getOpcode() {
        return "help";
    }

    @Override
    protected boolean executeInternal(Argument[] args, ExecutionEnvironment execEnv) {
        List<JvmProfCommand> commands = execEnv.getCommands();
        if (args.length == 0) {
            for (int i = 0; i < commands.size(); ++i) {
                System.out.println(commands.get(i).getOpcode() + " - " + commands.get(i).getHelpText());
            }
            System.out.println();
            System.out.println("The option '-help' provides detailed information for each command.");
            System.out.println();
            System.out.println("! - repeats the last command.");
            System.out.println("!! - repeats the last command.");
            System.out.println("!N - repeats command with number N in history.");
            System.out.println("!TEXT - repeats command that started with TEXT.");
        } else {
            for (int i = 0; i < commands.size(); ++i) {
                if (!commands.get(i).getOpcode().startsWith(args[0].getKey())) continue;
                System.out.println(commands.get(i).getOpcode() + " - " + commands.get(i).getHelpText());
                System.out.println(commands.get(i).getDetailedHelpText());
                System.out.println();
            }
        }
        return true;
    }
}

