/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.JvmProfConsole;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.JvmProfCommand;

public class HistoryCommand
extends JvmProfCommand {
    @Override
    public String getHelpText() {
        return "shows a list of the commands executed";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Usage: ").append(this.getOpcode()).append("\n");
        return builder.toString();
    }

    @Override
    public String getOpcode() {
        return "history";
    }

    @Override
    protected boolean executeInternal(Argument[] args, ExecutionEnvironment execEnv) {
        System.out.println("History:");
        String[] history = execEnv.getHistory();
        for (int i = 0; i < history.length; ++i) {
            String element = history[i];
            System.out.println(JvmProfConsole.getPaddedNumber(i, 4) + ": " + element);
        }
        return true;
    }
}

