/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.JvmProf;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import java.io.IOException;

public abstract class JvmProfCommand
implements Comparable<JvmProfCommand> {
    public abstract String getHelpText();

    public abstract String getDetailedHelpText();

    public abstract String getOpcode();

    public boolean execute(Argument[] args, ExecutionEnvironment execEnv) throws IOException {
        try {
            if (JvmProf.DEBUG) {
                StringBuilder builder = new StringBuilder("JvmProf: ");
                builder.append(this.getOpcode()).append(" ");
                if (args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        if (i != 0) {
                            builder.append(" ");
                        }
                        builder.append(args[i].getKey()).append("=").append(args[i].getValue());
                    }
                }
                JvmProf.getLogWriter().println(builder.toString());
            }
            boolean retValue = this.executeInternal(args, execEnv);
            if (JvmProf.DEBUG) {
                if (execEnv.isCancelled()) {
                    JvmProf.getLogWriter().println("JvmProf: Command was cancelled.");
                } else if (retValue) {
                    JvmProf.getLogWriter().println("JvmProf: Command sent successfully.");
                } else {
                    JvmProf.getLogWriter().println("JvmProf: Command sending failed.");
                }
            }
            return retValue;
        }
        catch (InvalidVmException e) {
            System.err.println("Invalid VM. Is the VM still running?");
            return false;
        }
    }

    protected abstract boolean executeInternal(Argument[] var1, ExecutionEnvironment var2) throws InvalidVmException, IOException;

    @Override
    public int compareTo(JvmProfCommand o) {
        return this.getOpcode().compareTo(o.getOpcode());
    }
}

