/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.Vm;
import com.sap.jvm.monitor.vm.VmProfilingInfo;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.JvmProfCommand;
import java.io.IOException;

public final class PrintProfilingInformationCommand
extends JvmProfCommand {
    @Override
    public String getHelpText() {
        return "prints information about the profiling state of a VM";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Usage: ").append(this.getOpcode()).append(" [<vm>]\n");
        builder.append("\nDefinitions:\n").append("  <vm>\t\tThe VM index when running in a cluster environment.\n");
        return builder.toString();
    }

    @Override
    public String getOpcode() {
        return "print profiling information";
    }

    @Override
    protected boolean executeInternal(Argument[] args, ExecutionEnvironment execEnv) throws InvalidVmException, IOException {
        Vm vm = execEnv.getVm(args);
        if (vm == null) {
            return false;
        }
        VmProfilingInfo info = vm.getProfilingInfo();
        System.out.println("Number of active profiling runs : " + info.getNrOfActiveProfilingRuns());
        System.out.println("Command line profiling : " + (info.isCommandLineProfilingEnabled() ? "active" : "not active"));
        System.out.println("Profiler attached: " + (info.isProfilerAttached() ? "yes" : "no"));
        System.out.println("Profiling port: " + info.getProfilingPort());
        System.out.println("Attachable profiling run: " + (info.hasAttachableProfilingRun() ? "available" : "not available"));
        return true;
    }
}

