/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.control.command.ControlCommandFactory;
import com.sap.jvm.profiling.control.response.ProfilingTraceInfoResponse;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.core.command.ProfilingSessionType;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.ProfilingCommand;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class ProfilingTraceInfoCommand
extends ProfilingCommand {
    private static final ControlCommandFactory ctrlCmdFactory = ProfilingFactory.createControlCommandFactory();
    private static final String KEY_PRINT_ALL = "all";
    private static final String KEY_PRINT_DETAILED = "details";
    private static final boolean VALUE_DEFAULT_PRINT_ALL = false;
    private static final boolean VALUE_DEFAULT_PRINT_DETAILED = false;

    @Override
    public String getOpcode() {
        return "print profiling traces";
    }

    @Override
    public String getHelpText() {
        return "prints the profiling traces currently active";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Usage: ").append(this.getOpcode()).append(" [<vm>]\n").append(" [<all=true|false>] ").append(" [<details=true|false>] ");
        builder.append("\nDefinitions:\n").append("  <vm>\t\tThe VM index when running in a cluster environment.\n").append("  <all>\tIf set to 'true', all started profiling traces are shown (including those not started by JvmProf).\n\t\t\t\tDefault is 'false'.\n").append("  <details>\tIf set to 'true', parameter details of started profiling traces are shown.\n\t\t\t\tDefault is 'false'.\n");
        return builder.toString();
    }

    void printResponsePacket(Response response, boolean showDetails, int number) {
        int indexOfResponse;
        String packetName = response.getPacketName();
        StringBuilder sb = new StringBuilder();
        sb.append(number + ": ");
        int indexOfEnable = packetName.toLowerCase().indexOf("enable");
        if (indexOfEnable >= 0) {
            indexOfEnable += "enable".length();
        }
        if ((indexOfResponse = packetName.toLowerCase().indexOf("response")) < 0) {
            indexOfResponse = packetName.length() - 1;
        }
        sb.append(packetName.substring(indexOfEnable, indexOfResponse).trim());
        System.out.println(sb.toString());
        if (showDetails) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            response.print(new PrintStream(bos));
            String[] fullOutput = bos.toString().split("\n");
            String[] headerKeys = new String[]{"id", "success", "Time", "error"};
            boolean commonResponseHeader = true;
            for (int index = 1; index < fullOutput.length; ++index) {
                String currentLine = fullOutput[index].trim();
                if (commonResponseHeader) {
                    commonResponseHeader = false;
                    for (String key : headerKeys) {
                        commonResponseHeader = commonResponseHeader || currentLine.startsWith(key);
                    }
                    if (commonResponseHeader) continue;
                }
                System.out.println(currentLine);
            }
            System.out.println();
        }
    }

    @Override
    protected boolean executeInternal(Argument[] args, ExecutionEnvironment execEnv) throws InvalidVmException, IOException {
        Response response;
        boolean detailed;
        String errorMessage = execEnv.executeAndWait((Command)ctrlCmdFactory.createProfilingTraceInfoCommand());
        boolean all = Argument.getStringValue(args, KEY_PRINT_ALL, null) != null;
        boolean bl = detailed = Argument.getStringValue(args, KEY_PRINT_DETAILED, null) != null;
        if (errorMessage == null && (response = execEnv.getLastResponse()) instanceof ProfilingTraceInfoResponse) {
            ProfilingTraceInfoResponse traceInfo = (ProfilingTraceInfoResponse)response;
            Response[] traceInfos = traceInfo.getStartTraceResponses(ProfilingSessionType.TYPE_PROFILING_CONTROL_JVMPROF);
            System.out.println("Profiling traces started by JvmProf:");
            if (traceInfos != null && traceInfos.length > 0) {
                System.out.println();
                int i = 0;
                for (Response traceResponse : traceInfos) {
                    this.printResponsePacket(traceResponse, detailed, ++i);
                }
            } else {
                System.out.println("none");
            }
            if (all) {
                System.out.println();
                System.out.println("Other Profiling traces started:");
                boolean othersExist = false;
                int i = 0;
                for (ProfilingSessionType sessionType : ProfilingSessionType.values()) {
                    if (sessionType == ProfilingSessionType.TYPE_PROFILING_CONTROL_JVMPROF || (traceInfos = traceInfo.getStartTraceResponses(sessionType)) == null || traceInfos.length <= 0) continue;
                    System.out.println();
                    for (Response otherTrace : traceInfos) {
                        this.printResponsePacket(otherTrace, detailed, ++i);
                        othersExist = true;
                    }
                }
                if (!othersExist) {
                    System.out.println("none");
                }
            }
            System.out.println();
            return true;
        }
        return false;
    }
}

