/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.memory.command.AllocationTraceConfiguration;
import com.sap.jvm.profiling.memory.command.AllocationTraceType;
import com.sap.jvm.profiling.memory.command.MemoryCommandFactory;
import com.sap.jvm.profiling.method.command.RequestedMethodParameter;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.JvmProf;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.ParameterDescriptions;
import com.sap.jvm.profiling.tools.jvmprof.command.ProfilingCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StartMethodParameterTraceCommand;
import java.io.IOException;
import java.util.List;

public final class StartAllocationTraceCommand
extends ProfilingCommand {
    private static final MemoryCommandFactory memCmdFactory = ProfilingFactory.createMemoryCommandFactory();
    private static final String KEY_ADAPTIVE = "adaptive";
    private static final boolean VALUE_DEFAULT_ADAPTIVE = false;

    @Override
    public String getOpcode() {
        return "start allocation trace";
    }

    @Override
    public String getHelpText() {
        return "starts the allocation trace inside a VM";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Usage: ").append(this.getOpcode()).append(" [<line_nrs=true|false>] ").append(" [<ids=true|false>] ").append(" [<jruby=true|false>] ").append(" [<vm>] ").append("[<user|session|request|application>=<pattern>]*").append(" [<paramSpec>]*\n");
        builder.append("\nDefinitions:\n").append("  <vm>\t\t\tThe VM index when running in a cluster environment.\n").append("  <adaptive>\t\tEnables the adaptive or full allocation trace.\n\t\t\tDefault is 'false'.\n").append("  <line_nrs>\t\tIf true we include line number information.\n").append("  <ids>\t\tIf true we include ids for every allocation.\n").append("\t\t\tDefault is true\n").append("  <jruby>\t\tIf true we add special support for JRuby.\n").append("\t\t\tDefault is false\n").append(ParameterDescriptions.getThreadFilterDescription(0) + "\n").append("  <paramSpec>\t\tDefines a method parameter which values are profiled in addition.\n\t\t\tWithin the analysis, the object allocations can be accounted to the \n\t\t\tindividual method invocations and parameter values.\n\n\t\t\tFor details refer to 'start method parameter trace -help'.\n\t\t\tDefault is no parameter definitions.");
        return builder.toString();
    }

    @Override
    protected boolean executeInternal(Argument[] args, ExecutionEnvironment execEnv) throws InvalidVmException, IOException {
        boolean adaptive = Argument.getBooleanValue(args, KEY_ADAPTIVE, false);
        boolean includeLinrNrs = Argument.getBooleanValue(args, "line_nrs", true);
        boolean include_ids = Argument.getBooleanValue(args, "ids", false);
        boolean supportJRuby = Argument.getBooleanValue(args, "jruby", false);
        ThreadFilter filter = StartAllocationTraceCommand.createThreadFilter(args);
        List<RequestedMethodParameter> specList = StartMethodParameterTraceCommand.createParameterList(args);
        if (JvmProf.DEBUG) {
            StringBuilder builder = new StringBuilder("JvmProf: Created Options ");
            builder.append("adaptive=").append(adaptive);
            builder.append(" line_nrs=").append(includeLinrNrs);
            builder.append(" ids=").append(include_ids);
            builder.append(" jruby=").append(supportJRuby);
            builder.append(" threadFilter=").append(filter);
            builder.append(" parameter=").append(StartMethodParameterTraceCommand.toString(specList));
            JvmProf.getLogWriter().println(builder.toString());
        }
        Object cmd = null;
        AllocationTraceConfiguration config = new AllocationTraceConfiguration(include_ids ? AllocationTraceType.NO_OBJECT_IDS : AllocationTraceType.WITH_OBJECT_IDS);
        config.setAllocatedObjectThreadFilter(filter);
        config.setIncludeLineNrs(includeLinrNrs);
        config.setSupportsJRuby(supportJRuby);
        if (!specList.isEmpty() && !execEnv.getCapabilities().hasMethodParameterTrace()) {
            return false;
        }
        if (supportJRuby && !execEnv.getCapabilities().getSystemInfo().supportsJRubyInAllocTrace()) {
            return false;
        }
        cmd = specList.isEmpty() ? (adaptive ? memCmdFactory.createEnableAdaptiveAllocationTraceCommand(config) : memCmdFactory.createEnableAllocationTraceCommand(config)) : (adaptive ? memCmdFactory.createEnableAdaptiveAllocationMptTraceCommand(config, specList, true, true, true, false) : memCmdFactory.createEnableAllocationMptTraceCommand(config, specList, true, true, true, false));
        String errorMessage = execEnv.executeAndWait((Command)cmd);
        return errorMessage == null;
    }
}

