/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.exception.command.EnableExceptionTraceCommand;
import com.sap.jvm.profiling.exception.command.ExceptionCommandFactory;
import com.sap.jvm.profiling.exception.command.ExceptionTraceConfiguration;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.JvmProf;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.ProfilingCommand;
import java.io.IOException;

public class StartExceptionTraceCommand
extends ProfilingCommand {
    private static final ExceptionCommandFactory exceptionCmdFactory = ProfilingFactory.createExceptionCommandFactory();

    @Override
    public String getOpcode() {
        return "start exception trace";
    }

    @Override
    public String getHelpText() {
        return "starts the exception trace inside a VM";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Usage: ").append(this.getOpcode()).append(" [line_nrs=true|false>] ").append(" [include_causes=true|false>] ").append(" [include_throw_stack=true|false>] ").append(" [exception_class_filter=<class-filter>] ").append(" [exception_stack_class_filter=<class-filter>] ").append(" [exception_stack_method_filter=<method-filter>] ").append(" [<vm>]\n");
        return builder.toString();
    }

    @Override
    protected boolean executeInternal(Argument[] args, ExecutionEnvironment execEnv) throws InvalidVmException, IOException {
        boolean includeLineNrs = Argument.getBooleanValue(args, "line_nrs", true);
        boolean includeCauses = Argument.getBooleanValue(args, "include_causes", true);
        boolean includeThrowStack = Argument.getBooleanValue(args, "include_throw_stack", true);
        String exceptionClassFilter = Argument.getStringValue(args, "exception_class_filter", "");
        String exceptionStackClassFilter = Argument.getStringValue(args, "exception_stack_class_filter", "");
        String exceptionStackMethodFilter = Argument.getStringValue(args, "exception_stack_method_filter", "");
        if (JvmProf.DEBUG) {
            StringBuilder builder = new StringBuilder("JvmProf: Created Options ");
            builder.append("line_nrs=").append(includeLineNrs);
            builder.append(" include_causes=").append(includeCauses);
            builder.append(" include_throw_stack=").append(includeThrowStack);
            builder.append(" exception_class_filter=\"" + exceptionClassFilter + "\" ");
            builder.append(" exception_stack_class_filter=\"" + exceptionStackClassFilter + "\" ");
            builder.append(" exception_stack_method_filter=\"" + exceptionStackMethodFilter + "\" ");
            JvmProf.getLogWriter().println(builder.toString());
        }
        ExceptionTraceConfiguration config = new ExceptionTraceConfiguration();
        config.setIncludeCauses(includeCauses);
        config.setIncludeLineNrs(includeLineNrs);
        config.setIncludeThrowStackTrace(includeThrowStack);
        config.setExceptionClassFilter(exceptionClassFilter);
        config.setExceptionStackTraceClassFilter(exceptionStackClassFilter);
        config.setExceptionStackTraceMethodFilter(exceptionStackMethodFilter);
        EnableExceptionTraceCommand cmd = exceptionCmdFactory.createEnableExceptionTraceCommand(config);
        String errorMessage = execEnv.executeAndWait((Command)cmd);
        return errorMessage == null;
    }
}

