/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.io.command.EnableIOTraceCommand;
import com.sap.jvm.profiling.io.command.IOCommandFactory;
import com.sap.jvm.profiling.io.command.IOTraceConfiguration;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.JvmProf;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.ParameterDescriptions;
import com.sap.jvm.profiling.tools.jvmprof.command.ProfilingCommand;
import java.io.IOException;

public final class StartIOTraceCommand
extends ProfilingCommand {
    private static final IOCommandFactory ioCmdFactory = ProfilingFactory.createIOCommandFactory();

    @Override
    public String getOpcode() {
        return "start I/O trace";
    }

    @Override
    public String getHelpText() {
        return "starts the I/O trace inside a VM";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Usage: ").append(this.getOpcode()).append(" [<vm>] ").append("[<user|session|request|application>=<pattern>]*").append("\n");
        builder.append("\nDefinitions:\n").append("  <vm>\t\t\tThe VM index when running in a cluster environment.\n").append(ParameterDescriptions.getThreadFilterDescription(0));
        return builder.toString();
    }

    @Override
    protected boolean executeInternal(Argument[] args, ExecutionEnvironment execEnv) throws InvalidVmException, IOException {
        ThreadFilter filter = StartIOTraceCommand.createThreadFilter(args);
        if (JvmProf.DEBUG) {
            StringBuilder builder = new StringBuilder("JvmProf: Created Options ");
            builder.append(" threadFilter=").append(filter);
            JvmProf.getLogWriter().println(builder.toString());
        }
        IOTraceConfiguration config = new IOTraceConfiguration();
        config.setThreadFilter(filter);
        EnableIOTraceCommand cmd = ioCmdFactory.createEnableIOTraceCommand(config);
        String errorMessage = execEnv.executeAndWait((Command)cmd);
        return errorMessage == null;
    }
}

