/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.method.command.EnableMethodCoverageCommand;
import com.sap.jvm.profiling.method.command.MethodCommandFactory;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.JvmProf;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.ProfilingCommand;
import java.io.IOException;

public final class StartMethodCoverageTraceCommand
extends ProfilingCommand {
    private static final MethodCommandFactory methodCmdFactory = ProfilingFactory.createMethodCommandFactory();

    @Override
    public String getOpcode() {
        return "start method coverage trace";
    }

    @Override
    public String getHelpText() {
        return "starts the method coverage trace inside a VM";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Usage: ").append(this.getOpcode()).append(" [<filter=com.sap*>] ").append(" [<vm>] ").append("\n");
        builder.append("\nDefinitions:\n").append("  <vm>\t\t\tThe VM index when running in a cluster environment.\n").append("  <filter>\tIf set only methods matching the filter will be traced.\n").append("\t\t\tDefault is '*'.\n");
        return builder.toString();
    }

    @Override
    protected boolean executeInternal(Argument[] args, ExecutionEnvironment execEnv) throws InvalidVmException, IOException {
        EnableMethodCoverageCommand cmd;
        String errorMessage;
        String filter = Argument.getStringValue(args, "filter", "*");
        if (JvmProf.DEBUG) {
            StringBuilder builder = new StringBuilder("JvmProf: Created Options ");
            builder.append(" filter=").append(filter);
            JvmProf.getLogWriter().println(builder.toString());
        }
        return (errorMessage = execEnv.executeAndWait((Command)(cmd = methodCmdFactory.createEnableMethodCoverageCommand(filter)))) == null;
    }
}

